/*
 * Decompiled with CFR 0.152.
 */
package de.javakaffee.simplequeue;

import com.sleepycat.je.Cursor;
import com.sleepycat.je.Database;
import com.sleepycat.je.DatabaseConfig;
import com.sleepycat.je.DatabaseEntry;
import com.sleepycat.je.DatabaseException;
import com.sleepycat.je.Environment;
import com.sleepycat.je.EnvironmentConfig;
import com.sleepycat.je.LockMode;
import com.sleepycat.je.OperationStatus;
import com.sleepycat.util.RuntimeExceptionWrapper;
import de.javakaffee.simplequeue.KeyComparator;
import java.io.File;
import java.io.IOException;
import java.math.BigInteger;
import java.util.Comparator;
import java.util.Iterator;
import java.util.NoSuchElementException;
import javax.annotation.Nonnull;

public class BDBQueue {
    private final Environment dbEnv;
    private final Database queueDatabase;
    private final int cacheSize;
    private final String queueName;
    private int opsCounter;

    public BDBQueue(String queueEnvPath, String queueName, int cacheSize) throws IOException {
        this(queueEnvPath, queueName, cacheSize, false, true);
    }

    public BDBQueue(String queueEnvPath, String queueName, int cacheSize, boolean readOnly, boolean allowCreate) throws IOException {
        BDBQueue.mkdir(new File(queueEnvPath), allowCreate);
        EnvironmentConfig dbEnvConfig = new EnvironmentConfig();
        dbEnvConfig.setTransactional(false);
        dbEnvConfig.setAllowCreate(allowCreate);
        dbEnvConfig.setReadOnly(readOnly);
        this.dbEnv = new Environment(new File(queueEnvPath), dbEnvConfig);
        DatabaseConfig dbConfig = new DatabaseConfig();
        dbConfig.setTransactional(false);
        dbConfig.setAllowCreate(allowCreate);
        dbConfig.setReadOnly(readOnly);
        dbConfig.setDeferredWrite(true);
        dbConfig.setBtreeComparator((Comparator)new KeyComparator());
        this.queueDatabase = this.dbEnv.openDatabase(null, queueName, dbConfig);
        this.queueName = queueName;
        this.cacheSize = cacheSize;
        this.opsCounter = 0;
    }

    public static void mkdir(@Nonnull File dir, boolean createDirectoryIfNotExisting) throws IOException {
        if (!dir.exists()) {
            if (!createDirectoryIfNotExisting) {
                throw new IOException("The directory " + dir.getAbsolutePath() + " does not exist.");
            }
            if (!dir.mkdirs()) {
                throw new IOException("Could not create directory " + dir.getAbsolutePath());
            }
        }
        if (!dir.isDirectory()) {
            throw new IOException("File " + dir + " exists and is not a directory. Unable to create directory.");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized byte[] poll() throws IOException {
        DatabaseEntry key = new DatabaseEntry();
        DatabaseEntry data = new DatabaseEntry();
        Cursor cursor = this.queueDatabase.openCursor(null, null);
        try {
            cursor.getFirst(key, data, LockMode.RMW);
            if (data.getData() == null) {
                byte[] byArray = null;
                return byArray;
            }
            cursor.delete();
            ++this.opsCounter;
            if (this.opsCounter >= this.cacheSize) {
                this.queueDatabase.sync();
                this.opsCounter = 0;
            }
            byte[] byArray = data.getData();
            return byArray;
        }
        finally {
            cursor.close();
        }
    }

    public synchronized CloseableIterator<byte[]> iterator() throws IOException {
        final DatabaseEntry key = new DatabaseEntry();
        final DatabaseEntry data = new DatabaseEntry();
        final Cursor cursor = this.queueDatabase.openCursor(null, null);
        return new CloseableIterator<byte[]>(){
            private byte[] nextValue;

            @Override
            public void close() {
                cursor.close();
            }

            @Override
            public boolean hasNext() {
                if (this.nextValue == null) {
                    try {
                        OperationStatus status = cursor.getNext(key, data, LockMode.READ_UNCOMMITTED);
                        if (status != OperationStatus.SUCCESS && status != OperationStatus.NOTFOUND) {
                            throw new IllegalStateException("Getting next element did not return successfully: " + status);
                        }
                        this.nextValue = status == OperationStatus.SUCCESS ? data.getData() : null;
                    }
                    catch (DatabaseException e) {
                        throw RuntimeExceptionWrapper.wrapIfNeeded((Throwable)e);
                    }
                    return this.nextValue != null;
                }
                return true;
            }

            @Override
            public byte[] next() {
                if (this.hasNext()) {
                    byte[] v = this.nextValue;
                    this.nextValue = null;
                    return v;
                }
                throw new NoSuchElementException();
            }

            @Override
            public void remove() {
                cursor.delete();
            }
        };
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized byte[] peek() throws IOException {
        DatabaseEntry key = new DatabaseEntry();
        DatabaseEntry data = new DatabaseEntry();
        Cursor cursor = this.queueDatabase.openCursor(null, null);
        try {
            cursor.getFirst(key, data, LockMode.RMW);
            if (data.getData() == null) {
                byte[] byArray = null;
                return byArray;
            }
            byte[] byArray = data.getData();
            return byArray;
        }
        finally {
            cursor.close();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized void remove() throws NoSuchElementException {
        DatabaseEntry key = new DatabaseEntry();
        DatabaseEntry data = new DatabaseEntry();
        Cursor cursor = this.queueDatabase.openCursor(null, null);
        try {
            cursor.getFirst(key, data, LockMode.RMW);
            if (data.getData() == null) {
                throw new NoSuchElementException();
            }
            cursor.delete();
            ++this.opsCounter;
            if (this.opsCounter >= this.cacheSize) {
                this.queueDatabase.sync();
                this.opsCounter = 0;
            }
        }
        finally {
            cursor.close();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized void push(byte[] element) throws IOException {
        DatabaseEntry key = new DatabaseEntry();
        DatabaseEntry data = new DatabaseEntry();
        Cursor cursor = this.queueDatabase.openCursor(null, null);
        try {
            cursor.getLast(key, data, LockMode.RMW);
            BigInteger prevKeyValue = key.getData() == null ? BigInteger.valueOf(-1L) : new BigInteger(key.getData());
            BigInteger newKeyValue = prevKeyValue.add(BigInteger.ONE);
            DatabaseEntry newKey = new DatabaseEntry(newKeyValue.toByteArray());
            DatabaseEntry newData = new DatabaseEntry(element);
            this.queueDatabase.put(null, newKey, newData);
            ++this.opsCounter;
            if (this.opsCounter >= this.cacheSize) {
                this.queueDatabase.sync();
                this.opsCounter = 0;
            }
        }
        finally {
            cursor.close();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized int clear() {
        DatabaseEntry key = new DatabaseEntry();
        DatabaseEntry data = new DatabaseEntry();
        Cursor cursor = this.queueDatabase.openCursor(null, null);
        try {
            int itemsRemoved = 0;
            while (cursor.getNext(key, data, LockMode.RMW) == OperationStatus.SUCCESS && data.getData() != null) {
                cursor.delete();
                ++itemsRemoved;
            }
            this.queueDatabase.sync();
            this.opsCounter = 0;
            int n = itemsRemoved;
            return n;
        }
        finally {
            cursor.close();
        }
    }

    public long size() {
        return this.queueDatabase.count();
    }

    public boolean isEmpty() {
        return this.queueDatabase.count() == 0L;
    }

    public String getQueueName() {
        return this.queueName;
    }

    public void close() {
        boolean interrupted = Thread.interrupted();
        this.queueDatabase.close();
        this.dbEnv.close();
        if (interrupted) {
            Thread.currentThread().interrupt();
        }
    }

    public static interface CloseableIterator<T>
    extends Iterator<T> {
        public void close();
    }
}

