/*
 * Decompiled with CFR 0.152.
 */
package de.javakaffee.web.msm.serializer.kryo;

import com.esotericsoftware.kryo.Kryo;
import com.esotericsoftware.kryo.Serializer;
import com.esotericsoftware.kryo.io.Input;
import com.esotericsoftware.kryo.io.Output;
import com.esotericsoftware.minlog.Log;
import com.sun.faces.util.LRUMap;
import de.javakaffee.web.msm.serializer.kryo.KryoCustomization;
import java.lang.reflect.Field;
import java.util.Map;

public class FacesLRUMapRegistration
implements KryoCustomization {
    @Override
    public void customize(Kryo kryo) {
        kryo.register(LRUMap.class, (Serializer)new LRUMapSerializer(kryo));
    }

    static class LRUMapSerializer
    extends Serializer<LRUMap<?, ?>> {
        private static final Field MAX_CAPACITY_FIELD;
        private final Kryo _kryo;

        public LRUMapSerializer(Kryo kryo) {
            this._kryo = kryo;
        }

        public LRUMap<?, ?> read(Kryo kryo, Input input, Class<LRUMap<?, ?>> type) {
            int maxCapacity = input.readInt(true);
            LRUMap result = new LRUMap(maxCapacity);
            int size = input.readInt(true);
            for (int i = 0; i < size; ++i) {
                Object key = this._kryo.readClassAndObject(input);
                Object value = this._kryo.readClassAndObject(input);
                result.put(key, value);
            }
            return result;
        }

        public void write(Kryo kryo, Output output, LRUMap<?, ?> map) {
            output.writeInt(this.getMaxCapacity(map), true);
            output.writeInt(map.size(), true);
            for (Map.Entry entry : map.entrySet()) {
                this._kryo.writeClassAndObject(output, entry.getKey());
                this._kryo.writeClassAndObject(output, entry.getValue());
            }
            if (Log.TRACE) {
                Log.trace((String)"kryo", (String)("Wrote map: " + map));
            }
        }

        private int getMaxCapacity(LRUMap<?, ?> map) {
            try {
                return MAX_CAPACITY_FIELD.getInt(map);
            }
            catch (Exception e) {
                throw new RuntimeException("Could not access maxCapacity field.", e);
            }
        }

        static {
            try {
                MAX_CAPACITY_FIELD = LRUMap.class.getDeclaredField("maxCapacity");
                MAX_CAPACITY_FIELD.setAccessible(true);
            }
            catch (Exception e) {
                throw new RuntimeException("The LRUMap seems to have changed, could not access expected field.", e);
            }
        }
    }
}

