/*
 * Decompiled with CFR 0.152.
 */
package de.javakaffee.web.msm.serializer.kryo;

import com.esotericsoftware.kryo.Kryo;
import com.esotericsoftware.kryo.Serializer;
import com.esotericsoftware.kryo.serialize.IntSerializer;
import com.esotericsoftware.kryo.serialize.SimpleSerializer;
import com.esotericsoftware.kryo.serialize.StringSerializer;
import de.javakaffee.web.msm.serializer.kryo.KryoCustomization;
import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.Collection;
import org.springframework.security.core.GrantedAuthority;
import org.springframework.security.core.userdetails.User;

public class SpringSecurityUserRegistration
implements KryoCustomization {
    @Override
    public void customize(Kryo kryo) {
        kryo.register(User.class, (Serializer)new SpringSecurityUserSerializer(kryo));
    }

    static class SpringSecurityUserSerializer
    extends SimpleSerializer<User> {
        private final Kryo _kryo;

        public SpringSecurityUserSerializer(Kryo kryo) {
            this._kryo = kryo;
        }

        public User read(ByteBuffer buffer) {
            String password = StringSerializer.get((ByteBuffer)buffer);
            String username = StringSerializer.get((ByteBuffer)buffer);
            int size = IntSerializer.get((ByteBuffer)buffer, (boolean)true);
            ArrayList<GrantedAuthority> authorities = new ArrayList<GrantedAuthority>(size);
            for (int i = 0; i < size; ++i) {
                authorities.add((GrantedAuthority)this._kryo.readClassAndObject(buffer));
            }
            boolean accountNonExpired = buffer.get() == 1;
            boolean accountNonLocked = buffer.get() == 1;
            boolean credentialsNonExpired = buffer.get() == 1;
            boolean enabled = buffer.get() == 1;
            return new User(username, password, enabled, accountNonExpired, credentialsNonExpired, accountNonLocked, authorities);
        }

        public void write(ByteBuffer buffer, User user) {
            StringSerializer.put((ByteBuffer)buffer, (String)user.getPassword());
            StringSerializer.put((ByteBuffer)buffer, (String)user.getUsername());
            Collection authorities = user.getAuthorities();
            IntSerializer.put((ByteBuffer)buffer, (int)authorities.size(), (boolean)true);
            for (GrantedAuthority item : authorities) {
                this._kryo.writeClassAndObject(buffer, (Object)item);
            }
            this.put(buffer, user.isAccountNonExpired());
            this.put(buffer, user.isAccountNonLocked());
            this.put(buffer, user.isCredentialsNonExpired());
            this.put(buffer, user.isEnabled());
        }

        private void put(ByteBuffer buffer, boolean value) {
            buffer.put(value ? (byte)1 : 0);
        }
    }
}

