/*
 * Decompiled with CFR 0.152.
 */
package de.javakaffee.web.msm.serializer.kryo;

import de.javakaffee.web.msm.MemcachedSessionService;
import de.javakaffee.web.msm.SessionAttributesTranscoder;
import de.javakaffee.web.msm.TranscoderFactory;
import de.javakaffee.web.msm.serializer.kryo.KryoTranscoder;
import edu.umd.cs.findbugs.annotations.SuppressWarnings;
import org.apache.juli.logging.Log;
import org.apache.juli.logging.LogFactory;

public class KryoTranscoderFactory
implements TranscoderFactory {
    private static final Log LOG = LogFactory.getLog(KryoTranscoderFactory.class);
    public static final String PROP_INIT_BUFFER_SIZE = "msm.kryo.bufferSize.initial";
    public static final String PROP_ENV_MAX_BUFFER_SIZE = "msm.kryo.bufferSize.max";
    public static final String PROP_ENV_DEFAULT_FACTORY = "msm.kryo.defaultSerializerFactory";
    private boolean _copyCollectionsForSerialization;
    private String[] _customConverterClassNames;
    private KryoTranscoder _transcoder;

    public SessionAttributesTranscoder createTranscoder(MemcachedSessionService.SessionManager manager) {
        return this.getTranscoder(manager.getContainer().getLoader().getClassLoader());
    }

    protected SessionAttributesTranscoder createTranscoder(ClassLoader loader) {
        return this.getTranscoder(loader);
    }

    private KryoTranscoder getTranscoder(ClassLoader classLoader) {
        if (this._transcoder == null) {
            int initialBufferSize = this.getSysPropValue(PROP_INIT_BUFFER_SIZE, 102400);
            int maxBufferSize = this.getSysPropValue(PROP_ENV_MAX_BUFFER_SIZE, 2048000);
            String defaultSerializerFactory = this.getSysPropValue(PROP_ENV_DEFAULT_FACTORY, KryoTranscoder.DEFAULT_SERIALIZER_FACTORY_CLASS);
            this._transcoder = new KryoTranscoder(classLoader, this._customConverterClassNames, this._copyCollectionsForSerialization, initialBufferSize, maxBufferSize, defaultSerializerFactory);
        }
        return this._transcoder;
    }

    private int getSysPropValue(String propName, int defaultValue) {
        int value = defaultValue;
        String propValue = System.getProperty(propName);
        if (propValue != null) {
            try {
                value = Integer.parseInt(propValue);
            }
            catch (NumberFormatException e) {
                LOG.warn((Object)("Could not parse system property " + propName + ": " + e));
            }
        }
        return value;
    }

    private String getSysPropValue(String propName, String defaultValue) {
        String propValue = System.getProperty(propName);
        if (propValue == null || propValue.trim().length() == 0) {
            return defaultValue;
        }
        return propValue;
    }

    public void setCopyCollectionsForSerialization(boolean copyCollectionsForSerialization) {
        this._copyCollectionsForSerialization = copyCollectionsForSerialization;
    }

    @SuppressWarnings(value={"EI_EXPOSE_REP2"})
    public void setCustomConverterClassNames(String[] customConverterClassNames) {
        this._customConverterClassNames = customConverterClassNames;
    }
}

