/*
 * Decompiled with CFR 0.152.
 */
package de.javakaffee.web.msm.serializer.javolution;

import de.javakaffee.web.msm.MemcachedBackupSession;
import de.javakaffee.web.msm.SessionAttributesTranscoder;
import de.javakaffee.web.msm.serializer.javolution.CustomXMLFormat;
import de.javakaffee.web.msm.serializer.javolution.ReflectionBinding;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.Map;
import javolution.xml.XMLBinding;
import javolution.xml.XMLObjectReader;
import javolution.xml.XMLObjectWriter;
import javolution.xml.XMLReferenceResolver;
import javolution.xml.stream.XMLStreamException;
import org.apache.catalina.Loader;
import org.apache.catalina.Manager;
import org.apache.juli.logging.Log;
import org.apache.juli.logging.LogFactory;

public class JavolutionTranscoder
implements SessionAttributesTranscoder {
    static final String REFERENCE_ATTRIBUTE_ID = "__id";
    static final String REFERENCE_ATTRIBUTE_REF_ID = "__ref";
    private static final Log LOG = LogFactory.getLog(JavolutionTranscoder.class);
    private final Manager _manager;
    private final ReflectionBinding _xmlBinding;

    public JavolutionTranscoder(Manager manager) {
        this(manager, false, new CustomXMLFormat[0]);
    }

    public JavolutionTranscoder(Manager manager, boolean copyCollectionsForSerialization, CustomXMLFormat<?> ... customFormats) {
        this._manager = manager;
        Loader loader = this._manager.getContainer().getLoader();
        this._xmlBinding = new ReflectionBinding(loader.getClassLoader(), copyCollectionsForSerialization, customFormats);
    }

    public JavolutionTranscoder(ClassLoader classLoader, boolean copyCollectionsForSerialization, CustomXMLFormat<?> ... customFormats) {
        this._manager = null;
        this._xmlBinding = new ReflectionBinding(classLoader, copyCollectionsForSerialization, customFormats);
    }

    public byte[] serializeAttributes(MemcachedBackupSession session, Map<String, Object> attributes) {
        return this.doSerialize(attributes, "attributes");
    }

    private byte[] doSerialize(Object object, String name) {
        if (object == null) {
            throw new NullPointerException("Can't serialize null");
        }
        XMLObjectWriter writer = null;
        try {
            ByteArrayOutputStream bos = new ByteArrayOutputStream();
            writer = XMLObjectWriter.newInstance((OutputStream)bos);
            XMLReferenceResolver xmlReferenceResolver = new XMLReferenceResolver();
            xmlReferenceResolver.setIdentifierAttribute(REFERENCE_ATTRIBUTE_ID);
            xmlReferenceResolver.setReferenceAttribute(REFERENCE_ATTRIBUTE_REF_ID);
            writer.setReferenceResolver(xmlReferenceResolver);
            writer.setBinding((XMLBinding)this._xmlBinding);
            writer.write(object, name);
            writer.flush();
            if (LOG.isDebugEnabled()) {
                LOG.debug((Object)("Returning serialized data:\n" + new String(bos.toByteArray())));
            }
            byte[] byArray = bos.toByteArray();
            this.closeSilently(writer);
            return byArray;
        }
        catch (Exception e) {
            try {
                LOG.error((Object)"caught exception", (Throwable)e);
                throw new IllegalArgumentException("Could not serialize object", e);
            }
            catch (Throwable throwable) {
                this.closeSilently(writer);
                throw throwable;
            }
        }
    }

    public Map<String, Object> deserializeAttributes(byte[] in) {
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)("Reading serialized data:\n" + new String(in)));
        }
        return (Map)this.doDeserialize(in, "attributes");
    }

    /*
     * Loose catch block
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private <T> T doDeserialize(byte[] in, String name) {
        Object object;
        XMLObjectReader reader = null;
        try {
            ByteArrayInputStream bis = new ByteArrayInputStream(in);
            reader = XMLObjectReader.newInstance((InputStream)bis);
            XMLReferenceResolver xmlReferenceResolver = new XMLReferenceResolver();
            xmlReferenceResolver.setIdentifierAttribute(REFERENCE_ATTRIBUTE_ID);
            xmlReferenceResolver.setReferenceAttribute(REFERENCE_ATTRIBUTE_REF_ID);
            reader.setReferenceResolver(xmlReferenceResolver);
            reader.setBinding((XMLBinding)this._xmlBinding);
            if (!reader.hasNext()) {
                throw new IllegalStateException("reader has no input");
            }
            object = reader.read(name);
        }
        catch (RuntimeException e) {
            try {
                LOG.warn((Object)("Caught Exception decoding " + in.length + " bytes of data"), (Throwable)e);
                throw e;
                catch (XMLStreamException e2) {
                    LOG.warn((Object)("Caught Exception decoding " + in.length + " bytes of data"), (Throwable)e2);
                    throw new RuntimeException(e2);
                }
            }
            catch (Throwable throwable) {
                this.closeSilently(reader);
                throw throwable;
            }
        }
        this.closeSilently(reader);
        return (T)object;
    }

    private void closeSilently(XMLObjectWriter stream) {
        if (stream != null) {
            try {
                stream.close();
            }
            catch (XMLStreamException xMLStreamException) {
                // empty catch block
            }
        }
    }

    private void closeSilently(XMLObjectReader stream) {
        if (stream != null) {
            try {
                stream.close();
            }
            catch (XMLStreamException xMLStreamException) {
                // empty catch block
            }
        }
    }
}

