/*
 * Decompiled with CFR 0.152.
 */
package de.javakaffee.web.msm.storage;

import de.javakaffee.web.msm.storage.StorageClient;
import java.util.concurrent.Future;
import net.spy.memcached.CachedData;
import net.spy.memcached.MemcachedClient;
import net.spy.memcached.transcoders.Transcoder;

public class MemcachedStorageClient
implements StorageClient {
    private MemcachedClient _memcached;

    public MemcachedStorageClient(MemcachedClient memcached) {
        if (memcached == null) {
            throw new NullPointerException("Param \"memcached\" may not be null");
        }
        this._memcached = memcached;
    }

    public MemcachedClient getMemcachedClient() {
        return this._memcached;
    }

    @Override
    public Future<Boolean> add(String key, int exp, byte[] o) {
        return this._memcached.add(key, exp, (Object)o, (Transcoder)ByteArrayTranscoder.INSTANCE);
    }

    @Override
    public Future<Boolean> set(String key, int exp, byte[] o) {
        return this._memcached.set(key, exp, (Object)o, (Transcoder)ByteArrayTranscoder.INSTANCE);
    }

    @Override
    public byte[] get(String key) {
        return (byte[])this._memcached.get(key, (Transcoder)ByteArrayTranscoder.INSTANCE);
    }

    @Override
    public Future<Boolean> delete(String key) {
        return this._memcached.delete(key);
    }

    @Override
    public void shutdown() {
        this._memcached.shutdown();
    }

    public static class ByteArrayTranscoder
    implements Transcoder<byte[]> {
        public static final ByteArrayTranscoder INSTANCE = new ByteArrayTranscoder();

        public boolean asyncDecode(CachedData d) {
            return false;
        }

        public byte[] decode(CachedData d) {
            return d.getData();
        }

        public CachedData encode(byte[] o) {
            return new CachedData(0, o, this.getMaxSize());
        }

        public int getMaxSize() {
            return 0x1400000;
        }
    }
}

