/*
 * Decompiled with CFR 0.152.
 */
package de.javakaffee.web.msm;

import de.javakaffee.web.msm.MemcachedSessionService;
import de.javakaffee.web.msm.RequestTrackingHostValve;
import java.io.IOException;
import javax.annotation.Nonnull;
import javax.servlet.ServletException;
import org.apache.catalina.connector.Request;
import org.apache.catalina.connector.Response;
import org.apache.catalina.valves.ValveBase;
import org.apache.juli.logging.Log;
import org.apache.juli.logging.LogFactory;

public class RequestTrackingContextValve
extends ValveBase {
    static final String INVOKED = "de.javakaffee.msm.contextValve.invoked";
    static final String RELOCATE = "session.relocate";
    protected static final Log _log = LogFactory.getLog(RequestTrackingHostValve.class);
    private final MemcachedSessionService _sessionBackupService;
    protected final String _sessionCookieName;

    public RequestTrackingContextValve(@Nonnull String sessionCookieName, @Nonnull MemcachedSessionService sessionBackupService) {
        this._sessionBackupService = sessionBackupService;
        this._sessionCookieName = sessionCookieName;
    }

    protected String getSessionCookieName() {
        return this._sessionCookieName;
    }

    public boolean wasInvokedWith(Request currentRequest) {
        return currentRequest != null && currentRequest.getNote(INVOKED) == Boolean.TRUE;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void invoke(Request request, Response response) throws IOException, ServletException {
        Object processRequest = request.getNote("de.javakaffee.msm.request.process");
        if (processRequest != Boolean.TRUE) {
            request.setNote(INVOKED, (Object)Boolean.TRUE);
            try {
                this.getNext().invoke(request, response);
            }
            finally {
                request.setNote("de.javakaffee.msm.request.processed", (Object)Boolean.TRUE);
            }
        }
        boolean sessionIdChanged = false;
        try {
            request.setNote(INVOKED, (Object)Boolean.TRUE);
            sessionIdChanged = this.changeRequestedSessionId(request, response);
            this.getNext().invoke(request, response);
        }
        finally {
            request.setNote("de.javakaffee.msm.request.processed", (Object)Boolean.TRUE);
            request.setNote("de.javakaffee.msm.sessionIdChanged", (Object)sessionIdChanged);
        }
    }

    private boolean changeRequestedSessionId(Request request, Response response) {
        if (request.getRequestedSessionId() != null) {
            String newSessionId = this._sessionBackupService.changeSessionIdOnTomcatFailover(request.getRequestedSessionId());
            if (newSessionId == null) {
                newSessionId = this._sessionBackupService.changeSessionIdOnMemcachedFailover(request.getRequestedSessionId());
            }
            if (newSessionId != null) {
                request.changeSessionId(newSessionId);
                return true;
            }
        }
        return false;
    }
}

