/*
 * Decompiled with CFR 0.152.
 */
package de.javakaffee.web.msm.storage;

import de.javakaffee.web.msm.storage.RedisStorageClient;
import java.lang.reflect.Method;
import java.net.URI;
import java.nio.charset.StandardCharsets;
import org.testng.Assert;
import org.testng.annotations.AfterMethod;
import org.testng.annotations.BeforeMethod;
import org.testng.annotations.Test;
import redis.embedded.RedisServer;

public class RedisStorageClientTest {
    private RedisServer embeddedRedisServer;
    private boolean redisProvided;
    private int redisPort;

    @BeforeMethod
    public void setUp(Method testMethod) throws Exception {
        this.redisProvided = Boolean.parseBoolean(System.getProperty("redis.provided", "false"));
        this.redisPort = Integer.parseInt(System.getProperty("redis.port", "16379"));
        if (!this.redisProvided) {
            this.embeddedRedisServer = new RedisServer(Integer.valueOf(this.redisPort));
            this.embeddedRedisServer.start();
        }
    }

    @AfterMethod
    public void tearDown() throws Exception {
        if (this.embeddedRedisServer != null) {
            this.embeddedRedisServer.stop();
            this.embeddedRedisServer = null;
        }
    }

    @Test
    public void testFunctions() throws Exception {
        RedisStorageClient client = this.createClient();
        Assert.assertTrue((boolean)((Boolean)client.add("key1", 0, this.toBytes("foo")).get()));
        Assert.assertTrue((boolean)((Boolean)client.add("key2", 0, this.toBytes("bar")).get()));
        Assert.assertEquals((String)"foo", (String)this.toString(client.get("key1")));
        Assert.assertEquals((String)"bar", (String)this.toString(client.get("key2")));
        Assert.assertTrue((boolean)((Boolean)client.set("key1", 0, this.toBytes("baz")).get()));
        Assert.assertFalse((boolean)((Boolean)client.add("key2", 0, this.toBytes("zoom")).get()));
        Assert.assertEquals((String)"baz", (String)this.toString(client.get("key1")));
        Assert.assertEquals((String)"bar", (String)this.toString(client.get("key2")));
        Assert.assertTrue((boolean)((Boolean)client.delete("key1").get()));
        Assert.assertNull((Object)client.get("key1"));
        Assert.assertEquals((String)"bar", (String)this.toString(client.get("key2")));
        client.shutdown();
    }

    @Test
    public void testExpirationSeconds() throws Exception {
        RedisStorageClient client = this.createClient();
        Assert.assertTrue((boolean)((Boolean)client.add("exp", 2, this.toBytes("foo")).get()));
        Thread.sleep(1000L);
        Assert.assertEquals((String)"foo", (String)this.toString(client.get("exp")));
        Thread.sleep(2000L);
        Assert.assertNull((Object)client.get("exp"));
        client.shutdown();
    }

    @Test
    public void testExpirationTime() throws Exception {
        RedisStorageClient client = this.createClient();
        Assert.assertTrue((boolean)((Boolean)client.add("exp", (int)(2L + System.currentTimeMillis() / 1000L), this.toBytes("foo")).get()));
        Assert.assertEquals((String)"foo", (String)this.toString(client.get("exp")));
        Thread.sleep(1000L);
        Assert.assertEquals((String)"foo", (String)this.toString(client.get("exp")));
        Thread.sleep(2000L);
        Assert.assertNull((Object)client.get("exp"));
        client.shutdown();
    }

    @Test
    public void testAutoReconnect() throws Exception {
        RedisStorageClient client = this.createClient();
        Assert.assertTrue((boolean)((Boolean)client.add("key1", 0, this.toBytes("foo")).get()));
        Assert.assertEquals((String)"foo", (String)this.toString(client.get("key1")));
        if (!this.redisProvided) {
            this.embeddedRedisServer.stop();
            this.embeddedRedisServer.start();
        }
        Assert.assertTrue((boolean)((Boolean)client.add("key1", 0, this.toBytes("foo")).get()));
        Assert.assertEquals((String)"foo", (String)this.toString(client.get("key1")));
        client.shutdown();
    }

    @Test
    public void testCreateUri01() throws Exception {
        RedisStorageClient client = this.createClient();
        URI uri = client.createURI("redis://user:pwd@localhost");
        Assert.assertEquals((String)uri.getScheme(), (String)"redis");
        Assert.assertEquals((String)uri.getUserInfo(), (String)"user:pwd");
        Assert.assertEquals((String)uri.getHost(), (String)"localhost");
        Assert.assertTrue((uri.getPort() == 6379 ? 1 : 0) != 0);
        uri = client.createURI("rediss://:pwd@localhost:9999");
        Assert.assertEquals((String)uri.getScheme(), (String)"rediss");
        Assert.assertEquals((String)uri.getUserInfo(), (String)":pwd");
        Assert.assertTrue((uri.getPort() == 9999 ? 1 : 0) != 0);
        uri = client.createURI("redis://localhost");
        Assert.assertEquals((String)uri.getScheme(), (String)"redis");
        Assert.assertNull((Object)uri.getUserInfo());
        Assert.assertTrue((uri.getPort() == 6379 ? 1 : 0) != 0);
    }

    private RedisStorageClient createClient() {
        return new RedisStorageClient("redis://localhost:" + this.redisPort, 1000L);
    }

    private byte[] toBytes(String s) {
        return s.getBytes(StandardCharsets.UTF_8);
    }

    private String toString(byte[] bytes) {
        return new String(bytes, StandardCharsets.UTF_8);
    }
}

