/*
 * Decompiled with CFR 0.152.
 */
package de.javakaffee.web.msm.integration;

import com.thimbleware.jmemcached.CacheElement;
import com.thimbleware.jmemcached.MemCacheDaemon;
import de.javakaffee.web.msm.MemcachedBackupSession;
import de.javakaffee.web.msm.MemcachedNodesManager;
import de.javakaffee.web.msm.MemcachedSessionService;
import de.javakaffee.web.msm.SessionIdFormat;
import de.javakaffee.web.msm.Statistics;
import de.javakaffee.web.msm.SuffixLocatorConnectionFactory;
import de.javakaffee.web.msm.integration.TestUtils;
import de.javakaffee.web.msm.integration.TomcatBuilder;
import de.javakaffee.web.msm.storage.MemcachedStorageClient;
import java.io.IOException;
import java.lang.reflect.Method;
import java.net.InetSocketAddress;
import java.util.Arrays;
import java.util.concurrent.Callable;
import net.spy.memcached.ConnectionFactory;
import net.spy.memcached.DefaultConnectionFactory;
import net.spy.memcached.MemcachedClient;
import net.spy.memcached.transcoders.Transcoder;
import org.apache.http.HttpException;
import org.apache.http.auth.Credentials;
import org.apache.http.auth.UsernamePasswordCredentials;
import org.apache.http.impl.client.DefaultHttpClient;
import org.apache.juli.logging.Log;
import org.apache.juli.logging.LogFactory;
import org.awaitility.Awaitility;
import org.hamcrest.CustomTypeSafeMatcher;
import org.hamcrest.Matcher;
import org.hamcrest.Matchers;
import org.testng.Assert;
import org.testng.annotations.AfterMethod;
import org.testng.annotations.BeforeMethod;
import org.testng.annotations.Test;

public abstract class TomcatFailoverIntegrationTest {
    private static final Log LOG = LogFactory.getLog(TomcatFailoverIntegrationTest.class);
    private static final String GROUP_WITHOUT_NODE_ID = "withoutNodeId";
    private MemCacheDaemon<?> _daemon;
    private MemCacheDaemon<?> _daemon2 = null;
    private MemcachedClient _client;
    private final MemcachedNodesManager.StorageClientCallback _storageClientCallback = new MemcachedNodesManager.StorageClientCallback(){

        public byte[] get(String key) {
            return (byte[])TomcatFailoverIntegrationTest.this._client.get(key, (Transcoder)MemcachedStorageClient.ByteArrayTranscoder.INSTANCE);
        }
    };
    private TomcatBuilder<?> _tomcat1;
    private TomcatBuilder<?> _tomcat2;
    private static final int TC_PORT_1 = 18888;
    private static final int TC_PORT_2 = 18889;
    private static final String JVM_ROUTE_2 = "tc2";
    private static final String JVM_ROUTE_1 = "tc1";
    private static final String NODE_ID = "n1";
    private static final int MEMCACHED_PORT = 21211;
    private String _memcachedNodes;
    private DefaultHttpClient _httpClient;

    @BeforeMethod
    public void setUp(Method testMethod) throws Throwable {
        InetSocketAddress address = new InetSocketAddress("localhost", 21211);
        this._daemon = TestUtils.createDaemon(address);
        this._daemon.start();
        String[] testGroups = testMethod.getAnnotation(Test.class).groups();
        String nodePrefix = testGroups.length == 0 || !GROUP_WITHOUT_NODE_ID.equals(testGroups[0]) ? "n1:" : "";
        this._memcachedNodes = nodePrefix + "localhost:" + 21211;
        try {
            this._tomcat1 = this.startTomcat(18888, JVM_ROUTE_1);
            this._tomcat2 = this.startTomcat(18889, JVM_ROUTE_2);
        }
        catch (Throwable e) {
            LOG.error((Object)"could not start tomcat.", e);
            throw e;
        }
        MemcachedNodesManager nodesManager = MemcachedNodesManager.createFor((String)this._memcachedNodes, null, null, (MemcachedNodesManager.StorageClientCallback)this._storageClientCallback);
        SuffixLocatorConnectionFactory cf = nodesManager.isEncodeNodeIdInSessionId() ? new SuffixLocatorConnectionFactory(nodesManager, nodesManager.getSessionIdFormat(), Statistics.create(), 1000L, 1000L) : new DefaultConnectionFactory();
        this._client = new MemcachedClient((ConnectionFactory)cf, Arrays.asList(address));
        this._httpClient = new DefaultHttpClient();
    }

    abstract TestUtils<?> getTestUtils();

    private TomcatBuilder<?> startTomcat(int port, String jvmRoute) throws Exception {
        return this.startTomcat(port, TestUtils.SessionAffinityMode.STICKY, jvmRoute, null);
    }

    private TomcatBuilder<?> startTomcat(int port, TestUtils.SessionAffinityMode sessionAffinityMode, String jvmRoute, TestUtils.LoginType loginType) throws Exception {
        return ((TomcatBuilder)this.getTestUtils().tomcatBuilder()).port(port).memcachedNodes(this._memcachedNodes).storageKeyPrefix(null).sticky(sessionAffinityMode.isSticky()).jvmRoute(jvmRoute).loginType(loginType).buildAndStart();
    }

    @AfterMethod
    public void tearDown() throws Exception {
        this._client.shutdown();
        this._httpClient.getConnectionManager().shutdown();
        this._tomcat1.stop();
        this._tomcat2.stop();
        this._daemon.stop();
        if (this._daemon2 != null) {
            this._daemon2.stop();
        }
    }

    @Test(enabled=true)
    public void testHttpSessionActivationListenersNotifiedOnLoadWithJvmRoute() throws Exception {
        MemcachedSessionService.SessionManager manager1 = this._tomcat1.getManager();
        MemcachedSessionService.SessionManager manager2 = this._tomcat2.getManager();
        SessionIdFormat format = new SessionIdFormat();
        String sessionId1 = TestUtils.get(this._httpClient, 18888, null).getSessionId();
        Assert.assertEquals((String)format.extractJvmRoute(sessionId1), (String)JVM_ROUTE_1);
        MemcachedBackupSession session = (MemcachedBackupSession)manager1.findSession(sessionId1);
        session.setAttribute("listener", (Object)new TestUtils.RecordingSessionActivationListener());
        TestUtils.get(this._httpClient, 18888, sessionId1);
        String sessionId2 = TestUtils.get(this._httpClient, 18889, sessionId1).getSessionId();
        Assert.assertEquals((String)format.stripJvmRoute(sessionId2), (String)format.stripJvmRoute(sessionId1));
        Assert.assertEquals((String)format.extractJvmRoute(sessionId2), (String)JVM_ROUTE_2);
        MemcachedBackupSession loaded = (MemcachedBackupSession)manager2.findSession(sessionId2);
        Assert.assertNotNull((Object)loaded);
        TestUtils.RecordingSessionActivationListener listener = (TestUtils.RecordingSessionActivationListener)loaded.getAttribute("listener");
        Assert.assertNotNull((Object)listener);
        String notifiedSessionId = listener.getSessionDidActivate();
        Assert.assertEquals((String)notifiedSessionId, (String)sessionId2);
    }

    @Test(enabled=true)
    public void testHttpSessionActivationListenersNotifiedOnLoadWithoutJvmRoute() throws Exception {
        this._tomcat1.stop();
        this._tomcat2.stop();
        this._tomcat1 = this.startTomcat(18888, null);
        this._tomcat2 = this.startTomcat(18889, null);
        MemcachedSessionService.SessionManager manager1 = this._tomcat1.getManager();
        MemcachedSessionService.SessionManager manager2 = this._tomcat2.getManager();
        SessionIdFormat format = new SessionIdFormat();
        String sessionId1 = TestUtils.get(this._httpClient, 18888, null).getSessionId();
        Assert.assertNull((Object)format.extractJvmRoute(sessionId1));
        MemcachedBackupSession session = (MemcachedBackupSession)manager1.findSession(sessionId1);
        session.setAttribute("listener", (Object)new TestUtils.RecordingSessionActivationListener());
        TestUtils.get(this._httpClient, 18888, sessionId1);
        String sessionId2 = TestUtils.get(this._httpClient, 18889, sessionId1).getSessionId();
        Assert.assertEquals((String)sessionId2, (String)sessionId1);
        MemcachedBackupSession loaded = (MemcachedBackupSession)manager2.findSession(sessionId2);
        Assert.assertNotNull((Object)loaded);
        TestUtils.RecordingSessionActivationListener listener = (TestUtils.RecordingSessionActivationListener)loaded.getAttribute("listener");
        Assert.assertNotNull((Object)listener);
        String notifiedSessionId = listener.getSessionDidActivate();
        Assert.assertEquals((String)notifiedSessionId, (String)sessionId2);
    }

    @Test(enabled=true)
    public void testTomcatFailover() throws IOException, InterruptedException, HttpException {
        SessionIdFormat format = new SessionIdFormat();
        String key = "foo";
        String value = "bar";
        final String sessionId1 = TestUtils.post(this._httpClient, 18888, null, "foo", "bar").getSessionId();
        Assert.assertEquals((String)format.extractJvmRoute(sessionId1), (String)JVM_ROUTE_1);
        Awaitility.await().until((Callable)new Callable<Object>(){

            @Override
            public Object call() throws Exception {
                return TomcatFailoverIntegrationTest.this._client.get(sessionId1);
            }
        }, Matchers.notNullValue());
        TestUtils.Response response = TestUtils.get(this._httpClient, 18889, sessionId1);
        String sessionId2 = response.getSessionId();
        Assert.assertNull((Object)this._client.get(sessionId1));
        Assert.assertNotNull((Object)this._client.get(sessionId2));
        Assert.assertEquals((String)format.stripJvmRoute(sessionId1), (String)format.stripJvmRoute(sessionId2));
        Assert.assertEquals((String)format.extractJvmRoute(sessionId2), (String)JVM_ROUTE_2);
        String actualValue = response.get("foo");
        Assert.assertEquals((String)"bar", (String)actualValue);
        Thread.sleep(10L);
    }

    @Test(enabled=true, groups={"withoutNodeId"})
    public void testTomcatFailoverWithSingleNodeWithoutConfiguredNodeId() throws IOException, InterruptedException, HttpException {
        this.testTomcatFailover();
    }

    @Test(enabled=true)
    public void testLoadedSessionOnlySentIfModified() throws IOException, InterruptedException, HttpException {
        String key = "foo";
        String value = "bar";
        String sessionId1 = TestUtils.post(this._httpClient, 18888, null, "foo", "bar").getSessionId();
        Assert.assertEquals((int)1, (int)this._daemon.getCache().getSetCmds());
        SessionIdFormat format = new SessionIdFormat();
        TestUtils.Response response = TestUtils.get(this._httpClient, 18889, sessionId1);
        Assert.assertEquals((String)format.stripJvmRoute(sessionId1), (String)format.stripJvmRoute(response.getSessionId()));
        Assert.assertEquals((int)2, (int)this._daemon.getCache().getSetCmds());
        TestUtils.post(this._httpClient, 18889, sessionId1, "foo", "bar");
        Assert.assertEquals((int)2, (int)this._daemon.getCache().getSetCmds());
        TestUtils.post(this._httpClient, 18889, sessionId1, "bar", "baz");
        Assert.assertEquals((int)3, (int)this._daemon.getCache().getSetCmds());
        Thread.sleep(10L);
    }

    @Test(enabled=true, dataProviderClass=TestUtils.class, dataProvider="stickynessProvider")
    public void testSerializationOfAuthStuffWithFormAuth(TestUtils.SessionAffinityMode stickyness) throws Exception {
        this._tomcat1.stop();
        this._tomcat2.stop();
        this._tomcat1 = this.startTomcat(18888, stickyness, stickyness.isSticky() ? JVM_ROUTE_1 : null, TestUtils.LoginType.FORM);
        this._tomcat2 = this.startTomcat(18889, stickyness, stickyness.isSticky() ? JVM_ROUTE_2 : null, TestUtils.LoginType.FORM);
        this._tomcat1.setChangeSessionIdOnAuth(false);
        this._tomcat2.setChangeSessionIdOnAuth(false);
        String sessionId = TestUtils.loginWithForm(this._httpClient, 18888);
        TestUtils.Response tc2Response1 = TestUtils.get(this._httpClient, 18889, sessionId);
        if (stickyness.isSticky()) {
            Assert.assertEquals((String)tc2Response1.getResponseSessionId(), (String)new SessionIdFormat().changeJvmRoute(sessionId, JVM_ROUTE_2));
        } else {
            Assert.assertEquals((String)tc2Response1.getSessionId(), (String)sessionId);
        }
    }

    @Test(enabled=true, dataProviderClass=TestUtils.class, dataProvider="stickynessProvider")
    public void testSerializationOfAuthStuffWithBasicAuth(TestUtils.SessionAffinityMode stickyness) throws Exception {
        this._tomcat1.stop();
        this._tomcat2.stop();
        this._tomcat1 = this.startTomcat(18888, stickyness, stickyness.isSticky() ? JVM_ROUTE_1 : null, TestUtils.LoginType.BASIC);
        this._tomcat2 = this.startTomcat(18889, stickyness, stickyness.isSticky() ? JVM_ROUTE_2 : null, TestUtils.LoginType.BASIC);
        this._tomcat1.setChangeSessionIdOnAuth(false);
        this._tomcat2.setChangeSessionIdOnAuth(false);
        TestUtils.Response tc1Response1 = TestUtils.get(this._httpClient, 18888, null, (Credentials)new UsernamePasswordCredentials("testuser", "secret"));
        String sessionId = tc1Response1.getSessionId();
        Assert.assertEquals((String)sessionId, (String)tc1Response1.get("id"));
        TestUtils.Response tc2Response1 = TestUtils.get(this._httpClient, 18889, sessionId);
        if (stickyness.isSticky()) {
            Assert.assertEquals((String)tc2Response1.getResponseSessionId(), (String)new SessionIdFormat().changeJvmRoute(sessionId, JVM_ROUTE_2));
        } else {
            Assert.assertEquals((String)tc2Response1.getSessionId(), (String)sessionId);
        }
    }

    @Test(enabled=true)
    public void testSessionOnlyLoadedOnceWithAuth() throws Exception {
        this._tomcat1.stop();
        this._tomcat2.stop();
        this._tomcat1 = this.startTomcat(18888, TestUtils.SessionAffinityMode.STICKY, JVM_ROUTE_1, TestUtils.LoginType.BASIC);
        this._tomcat2 = this.startTomcat(18889, TestUtils.SessionAffinityMode.STICKY, JVM_ROUTE_2, TestUtils.LoginType.BASIC);
        this._tomcat1.setChangeSessionIdOnAuth(false);
        this._tomcat2.setChangeSessionIdOnAuth(false);
        TestUtils.Response tc1Response1 = TestUtils.get(this._httpClient, 18888, null, (Credentials)new UsernamePasswordCredentials("testuser", "secret"));
        String sessionId = tc1Response1.getSessionId();
        Assert.assertEquals((String)sessionId, (String)tc1Response1.get("id"));
        Assert.assertEquals((int)this._daemon.getCache().getGetHits(), (int)0);
        TestUtils.Response tc2Response1 = TestUtils.get(this._httpClient, 18889, sessionId);
        Assert.assertEquals((String)tc2Response1.getResponseSessionId(), (String)new SessionIdFormat().changeJvmRoute(sessionId, JVM_ROUTE_2));
        Assert.assertEquals((int)this._daemon.getCache().getGetHits(), (int)1);
    }

    @Test(enabled=true, dataProviderClass=TestUtils.class, dataProvider="stickynessProvider")
    public void testSessionModificationOnTomcatFailoverNotLostWithAuth(TestUtils.SessionAffinityMode stickyness) throws Exception {
        this._tomcat1.stop();
        this._tomcat2.stop();
        this._tomcat1 = this.startTomcat(18888, stickyness, stickyness.isSticky() ? JVM_ROUTE_1 : null, TestUtils.LoginType.BASIC);
        this._tomcat2 = this.startTomcat(18889, stickyness, stickyness.isSticky() ? JVM_ROUTE_2 : null, TestUtils.LoginType.BASIC);
        this._tomcat1.setChangeSessionIdOnAuth(false);
        this._tomcat2.setChangeSessionIdOnAuth(false);
        TestUtils.Response tc1Response1 = TestUtils.get(this._httpClient, 18888, null, (Credentials)new UsernamePasswordCredentials("testuser", "secret"));
        String sessionId = tc1Response1.getSessionId();
        Assert.assertEquals((String)sessionId, (String)tc1Response1.get("id"));
        TestUtils.Response tc2Response1 = TestUtils.post(this._httpClient, 18889, "/", sessionId, TestUtils.asMap("foo", "bar"));
        if (stickyness.isSticky()) {
            Assert.assertEquals((String)tc2Response1.getResponseSessionId(), (String)new SessionIdFormat().changeJvmRoute(sessionId, JVM_ROUTE_2));
        } else {
            Assert.assertEquals((String)tc2Response1.getSessionId(), (String)sessionId);
        }
        TestUtils.Response tc2Response2 = TestUtils.get(this._httpClient, 18889, tc2Response1.getResponseSessionId());
        Assert.assertEquals((String)tc2Response2.get("foo"), (String)"bar");
    }

    @Test(enabled=true)
    public void testTomcatFailoverMovesSessionToNonFailoverNode() throws Exception {
        this._daemon2 = this.startMemcached(21212);
        String memcachedNodes = this._memcachedNodes + ",n2:localhost:" + 21212;
        this._tomcat1.getService().setMemcachedNodes(memcachedNodes);
        this._tomcat1.getService().setFailoverNodes(NODE_ID);
        this._tomcat2.getService().setMemcachedNodes(memcachedNodes);
        this._tomcat2.getService().setFailoverNodes("n2");
        final SessionIdFormat format = new SessionIdFormat();
        String key = "foo";
        String value = "bar";
        final String sessionId1 = TestUtils.post(this._httpClient, 18888, null, "foo", "bar").getSessionId();
        Assert.assertEquals((String)format.extractMemcachedId(sessionId1), (String)"n2");
        Assert.assertEquals((long)this._daemon.getCache().getCurrentItems(), (long)0L);
        Assert.assertEquals((long)this._daemon2.getCache().getCurrentItems(), (long)1L);
        TestUtils.Response response = (TestUtils.Response)Awaitility.await().until((Callable)new Callable<TestUtils.Response>(){

            @Override
            public TestUtils.Response call() throws Exception {
                return TestUtils.get(TomcatFailoverIntegrationTest.this._httpClient, 18889, sessionId1);
            }
        }, (Matcher)new CustomTypeSafeMatcher<TestUtils.Response>("session id should contain 'n1'"){

            public boolean matchesSafely(TestUtils.Response response) {
                String sessionId2 = response.getSessionId();
                return format.extractMemcachedId(sessionId2).equals(TomcatFailoverIntegrationTest.NODE_ID);
            }
        });
        Assert.assertEquals((long)this._daemon.getCache().getCurrentItems(), (long)1L);
        String sessionId2 = response.getSessionId();
        Assert.assertEquals((String)format.stripJvmRoute(sessionId1).replaceAll("n2", NODE_ID), (String)format.stripJvmRoute(sessionId2));
        String actualValue = response.get("foo");
        Assert.assertEquals((String)"bar", (String)actualValue);
    }

    private MemCacheDaemon<?> startMemcached(int memcachedPort) throws IOException {
        InetSocketAddress address = new InetSocketAddress("localhost", memcachedPort);
        MemCacheDaemon<CacheElement> daemon2 = TestUtils.createDaemon(address);
        daemon2.start();
        return daemon2;
    }
}

