/*
 * Decompiled with CFR 0.152.
 */
package de.javakaffee.web.msm.integration;

import com.thimbleware.jmemcached.Cache;
import com.thimbleware.jmemcached.CacheElement;
import com.thimbleware.jmemcached.CacheImpl;
import com.thimbleware.jmemcached.Key;
import com.thimbleware.jmemcached.MemCacheDaemon;
import com.thimbleware.jmemcached.storage.CacheStorage;
import com.thimbleware.jmemcached.storage.hash.ConcurrentLinkedHashMap;
import de.javakaffee.web.msm.MemcachedBackupSession;
import de.javakaffee.web.msm.MemcachedSessionService;
import de.javakaffee.web.msm.integration.TomcatBuilder;
import de.javakaffee.web.msm.storage.MemcachedStorageClient;
import de.javakaffee.web.msm.storage.StorageClient;
import java.io.BufferedReader;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Serializable;
import java.io.UnsupportedEncodingException;
import java.lang.reflect.Field;
import java.lang.reflect.InvocationHandler;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.lang.reflect.Proxy;
import java.net.InetSocketAddress;
import java.net.URL;
import java.util.ArrayList;
import java.util.Currency;
import java.util.HashMap;
import java.util.IdentityHashMap;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Set;
import java.util.logging.LogManager;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import javax.servlet.http.HttpSessionActivationListener;
import javax.servlet.http.HttpSessionEvent;
import net.spy.memcached.MemcachedClient;
import org.apache.catalina.Container;
import org.apache.catalina.Loader;
import org.apache.catalina.Service;
import org.apache.catalina.core.StandardContext;
import org.apache.catalina.core.StandardEngine;
import org.apache.catalina.core.StandardHost;
import org.apache.catalina.core.StandardService;
import org.apache.catalina.loader.WebappLoader;
import org.apache.http.Header;
import org.apache.http.HeaderElement;
import org.apache.http.HttpEntity;
import org.apache.http.HttpException;
import org.apache.http.HttpResponse;
import org.apache.http.auth.AuthScope;
import org.apache.http.auth.Credentials;
import org.apache.http.client.ClientProtocolException;
import org.apache.http.client.HttpClient;
import org.apache.http.client.entity.UrlEncodedFormEntity;
import org.apache.http.client.methods.CloseableHttpResponse;
import org.apache.http.client.methods.HttpGet;
import org.apache.http.client.methods.HttpPost;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.client.params.HttpClientParams;
import org.apache.http.impl.auth.BasicScheme;
import org.apache.http.impl.client.DefaultHttpClient;
import org.apache.http.message.BasicNameValuePair;
import org.apache.http.params.HttpParams;
import org.apache.http.protocol.BasicHttpContext;
import org.apache.http.protocol.HttpContext;
import org.apache.http.util.EntityUtils;
import org.apache.juli.logging.LogFactory;
import org.jboss.netty.buffer.ChannelBuffers;
import org.testng.Assert;
import org.testng.annotations.DataProvider;

public abstract class TestUtils<T extends TomcatBuilder<?>> {
    private static final String CONTEXT_PATH = "/";
    private static final String DEFAULT_HOST = "localhost";
    protected static final String PASSWORD = "secret";
    protected static final String USER_NAME = "testuser";
    protected static final String ROLE_NAME = "test";
    public static final String STICKYNESS_PROVIDER = "stickynessProvider";
    public static final String BOOLEAN_PROVIDER = "booleanProvider";

    public static void initLogConfig(Class<? extends TestUtils> clazz) {
        URL loggingProperties = clazz.getResource("/logging.properties");
        try {
            System.setProperty("java.util.logging.config.file", new File(loggingProperties.toURI()).getAbsolutePath());
        }
        catch (Exception e) {
            return;
        }
        try {
            LogManager.getLogManager().readConfiguration();
        }
        catch (Exception e) {
            LogFactory.getLog(TestUtils.class).error((Object)"Could not init logging configuration.", (Throwable)e);
        }
    }

    public static String loginWithForm(DefaultHttpClient client, int tcPort) throws IOException, HttpException {
        Response tc1Response1 = TestUtils.get(client, tcPort, null);
        String sessionId = tc1Response1.getSessionId();
        Assert.assertNotNull((Object)sessionId);
        Assert.assertTrue((boolean)tc1Response1.getContent().contains("j_security_check"), (String)"/j_security_check not found, app is not properly initialized");
        HashMap<String, String> params = new HashMap<String, String>();
        params.put("j_username", USER_NAME);
        params.put("j_password", PASSWORD);
        Response tc1Response2 = TestUtils.post(client, tcPort, "/j_security_check", sessionId, params);
        Assert.assertEquals((String)tc1Response2.getSessionId(), (String)sessionId);
        Assert.assertEquals((String)tc1Response2.get("id"), (String)sessionId);
        return tc1Response2.getSessionId();
    }

    public static String makeRequest(HttpClient client, int port, String rsessionId) throws IOException, HttpException {
        HttpResponse response;
        HttpGet method = new HttpGet("http://localhost:" + port + CONTEXT_PATH);
        if (rsessionId != null) {
            method.setHeader("Cookie", "JSESSIONID=" + rsessionId);
        }
        if ((response = client.execute((HttpUriRequest)method)).getStatusLine().getStatusCode() != 200) {
            throw new RuntimeException("GET did not return status 200, but " + response.getStatusLine());
        }
        String responseSessionId = TestUtils.getSessionIdFromResponse(response);
        EntityUtils.consume((HttpEntity)response.getEntity());
        return responseSessionId == null ? rsessionId : responseSessionId;
    }

    public static Response get(DefaultHttpClient client, int port, String rsessionId) throws IOException, HttpException {
        return TestUtils.get(client, port, null, rsessionId);
    }

    public static Response get(DefaultHttpClient client, int port, String rsessionId, Credentials credentials) throws IOException, HttpException {
        return TestUtils.get(client, port, null, rsessionId, null, null, credentials);
    }

    public static Response get(DefaultHttpClient client, int port, String path, String rsessionId) throws IOException, HttpException {
        return TestUtils.get(client, port, path, rsessionId, null, null, null);
    }

    public static Response get(DefaultHttpClient client, int port, String path, String rsessionId, Map<String, String> params) throws IOException, HttpException {
        return TestUtils.get(client, port, path, rsessionId, null, params, null);
    }

    public static Response get(DefaultHttpClient client, int port, String path, String rsessionId, SessionTrackingMode sessionTrackingMode, Map<String, String> params, Credentials credentials) throws IOException, HttpException {
        CloseableHttpResponse response;
        String url = TestUtils.getUrl(port, path);
        if (params != null && !params.isEmpty()) {
            url = url + TestUtils.toQueryString(params);
        }
        if (rsessionId != null && sessionTrackingMode == SessionTrackingMode.URL) {
            url = url + ";jsessionid=" + rsessionId;
        }
        HttpGet method = new HttpGet(url);
        if (rsessionId != null && sessionTrackingMode == SessionTrackingMode.COOKIE) {
            method.setHeader("Cookie", "JSESSIONID=" + rsessionId);
        }
        Object object = response = credentials == null ? client.execute((HttpUriRequest)method) : TestUtils.executeRequestWithAuth(client, (HttpUriRequest)method, credentials);
        if (response.getStatusLine().getStatusCode() != 200) {
            throw new RuntimeException("GET " + path + " did not return status 200, but " + response.getStatusLine());
        }
        return TestUtils.readResponse(rsessionId, (HttpResponse)response);
    }

    private static String getUrl(int port, String path) throws IllegalArgumentException {
        if (path != null && !path.startsWith(CONTEXT_PATH)) {
            path = CONTEXT_PATH + path;
        }
        return "http://localhost:" + port + (path != null ? path : CONTEXT_PATH);
    }

    private static String toQueryString(Map<String, String> params) {
        StringBuilder sb = new StringBuilder();
        sb.append("?");
        Iterator<Map.Entry<String, String>> iterator = params.entrySet().iterator();
        while (iterator.hasNext()) {
            Map.Entry<String, String> entry = iterator.next();
            sb.append(entry.getKey()).append("=").append(entry.getValue());
            if (!iterator.hasNext()) continue;
            sb.append("&");
        }
        String qs = sb.toString();
        return qs;
    }

    private static HttpResponse executeRequestWithAuth(DefaultHttpClient client, HttpUriRequest method, Credentials credentials) throws IOException, ClientProtocolException {
        client.getCredentialsProvider().setCredentials(AuthScope.ANY, credentials);
        BasicHttpContext localcontext = new BasicHttpContext();
        BasicScheme basicAuth = new BasicScheme();
        localcontext.setAttribute("preemptive-auth", (Object)basicAuth);
        return client.execute(method, (HttpContext)localcontext);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static Response readResponse(String rsessionId, HttpResponse response) throws IOException {
        String responseSessionId = TestUtils.getSessionIdFromResponse(response);
        StringBuilder sb = new StringBuilder();
        LinkedHashMap<String, String> keyValues = new LinkedHashMap<String, String>();
        BufferedReader reader = null;
        try {
            reader = new BufferedReader(new InputStreamReader(response.getEntity().getContent()));
            String line = null;
            while ((line = reader.readLine()) != null) {
                sb.append(line);
                String[] keyValue = line.split("=");
                if (keyValue.length <= 0) continue;
                keyValues.put(keyValue[0], keyValue.length > 1 ? keyValue[1] : null);
            }
        }
        finally {
            if (reader != null) {
                reader.close();
            }
        }
        return new Response(response, responseSessionId == null ? rsessionId : responseSessionId, responseSessionId, sb.toString(), keyValues);
    }

    public static Response post(DefaultHttpClient client, int port, String rsessionId, String paramName, String paramValue) throws IOException, HttpException {
        HashMap<String, String> params = new HashMap<String, String>();
        params.put(paramName, paramValue);
        return TestUtils.post(client, port, null, rsessionId, params);
    }

    public static Response post(DefaultHttpClient client, int port, String path, String rsessionId, Map<String, String> params) throws IOException, HttpException {
        return TestUtils.post(client, port, path, rsessionId, params, null, true);
    }

    public static Response post(DefaultHttpClient client, int port, String path, String rsessionId, Map<String, String> params, @Nullable Credentials credentials, boolean followRedirects) throws IOException, HttpException {
        String baseUri = "http://localhost:" + port;
        String url = TestUtils.getUrl(port, path);
        HttpPost method = new HttpPost(url);
        if (rsessionId != null) {
            method.setHeader("Cookie", "JSESSIONID=" + rsessionId);
        }
        method.setEntity((HttpEntity)TestUtils.createFormEntity(params));
        if (!followRedirects) {
            HttpClientParams.setRedirecting((HttpParams)method.getParams(), (boolean)false);
        }
        CloseableHttpResponse response = credentials == null ? client.execute((HttpUriRequest)method) : TestUtils.executeRequestWithAuth(client, (HttpUriRequest)method, credentials);
        int statusCode = response.getStatusLine().getStatusCode();
        if (followRedirects && TestUtils.isRedirect(statusCode)) {
            return TestUtils.redirect((HttpResponse)response, client, port, rsessionId, baseUri);
        }
        if (statusCode != 200 && (followRedirects || !TestUtils.isRedirect(statusCode))) {
            throw new RuntimeException("POST" + (path != null ? " " + path : "") + " did not return status 200, but " + response.getStatusLine() + "\n" + TestUtils.toString(response.getEntity().getContent()));
        }
        return TestUtils.readResponse(rsessionId, (HttpResponse)response);
    }

    public static boolean isRedirect(int statusCode) {
        return statusCode == 302 || statusCode == 303;
    }

    public static String toString(InputStream in) {
        StringBuilder sb = new StringBuilder();
        BufferedReader reader = null;
        try {
            reader = new BufferedReader(new InputStreamReader(in));
            String line = null;
            while ((line = reader.readLine()) != null) {
                sb.append(line);
            }
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
        finally {
            if (reader != null) {
                try {
                    reader.close();
                }
                catch (IOException iOException) {}
            }
        }
        return sb.toString();
    }

    private static Response redirect(HttpResponse response, DefaultHttpClient client, int port, String rsessionId, String baseUri) throws IOException, HttpException {
        EntityUtils.consume((HttpEntity)response.getEntity());
        String location = response.getFirstHeader("Location").getValue();
        String redirectPath = location.startsWith(baseUri) ? location.substring(baseUri.length(), location.length()) : location;
        return TestUtils.get(client, port, redirectPath, rsessionId);
    }

    private static UrlEncodedFormEntity createFormEntity(Map<String, String> params) throws UnsupportedEncodingException {
        ArrayList<BasicNameValuePair> parameters = new ArrayList<BasicNameValuePair>();
        for (Map.Entry<String, String> param : params.entrySet()) {
            parameters.add(new BasicNameValuePair(param.getKey(), param.getValue()));
        }
        UrlEncodedFormEntity entity = new UrlEncodedFormEntity(parameters, "UTF-8");
        return entity;
    }

    public static String getSessionIdFromResponse(HttpResponse response) {
        Header cookie = response.getFirstHeader("Set-Cookie");
        if (cookie != null) {
            for (HeaderElement header : cookie.getElements()) {
                if (!"JSESSIONID".equals(header.getName())) continue;
                return header.getValue();
            }
        }
        return null;
    }

    public static StandardContext createContext() {
        StandardEngine engine = new StandardEngine();
        engine.setService((Service)new StandardService());
        StandardContext context = new StandardContext();
        context.setPath(CONTEXT_PATH);
        context.setSessionCookiePath(CONTEXT_PATH);
        WebappLoader webappLoader = new WebappLoader(){

            public ClassLoader getClassLoader() {
                return Thread.currentThread().getContextClassLoader();
            }
        };
        context.setLoader((Loader)webappLoader);
        StandardHost host = new StandardHost();
        engine.addChild((Container)host);
        host.addChild((Container)context);
        return context;
    }

    public static MemCacheDaemon<? extends CacheElement> createDaemon(InetSocketAddress address) throws IOException {
        MemCacheDaemon daemon = new MemCacheDaemon();
        ConcurrentLinkedHashMap cacheStorage = ConcurrentLinkedHashMap.create((ConcurrentLinkedHashMap.EvictionPolicy)ConcurrentLinkedHashMap.EvictionPolicy.LRU, (int)100000, (long)0x100000L);
        daemon.setCache((Cache)new CacheImpl((CacheStorage)cacheStorage));
        daemon.setAddr(address);
        daemon.setVerbose(true);
        return daemon;
    }

    public abstract T tomcatBuilder();

    public static String extractNodeId(String sessionId) {
        int idx = sessionId.lastIndexOf(45);
        return idx > -1 ? sessionId.substring(idx + 1) : null;
    }

    public static void assertDeepEquals(Object one, Object another) {
        TestUtils.assertDeepEquals(one, another, new IdentityHashMap<Object, Object>());
    }

    public static void assertDeepEquals(Object one, Object another, Map<Object, Object> alreadyChecked) {
        if (one == another) {
            return;
        }
        if (one == null && another != null || one != null && another == null) {
            Assert.fail((String)("One of both is null: " + one + ", " + another));
        }
        if (alreadyChecked.containsKey(one)) {
            return;
        }
        alreadyChecked.put(one, another);
        Assert.assertEquals(one.getClass(), another.getClass());
        if (one.getClass().isPrimitive() || one instanceof String || one instanceof Character || one instanceof Boolean) {
            Assert.assertEquals((Object)one, (Object)another);
            return;
        }
        if (Map.class.isAssignableFrom(one.getClass())) {
            Map m1 = (Map)one;
            Map m2 = (Map)another;
            Assert.assertEquals((int)m1.size(), (int)m2.size());
            for (Map.Entry entry : m1.entrySet()) {
                TestUtils.assertDeepEquals(entry.getValue(), m2.get(entry.getKey()));
            }
            return;
        }
        if (Set.class.isAssignableFrom(one.getClass())) {
            Set m1 = (Set)one;
            Set m2 = (Set)another;
            Assert.assertEquals((int)m1.size(), (int)m2.size());
            Iterator iter1 = m1.iterator();
            Iterator iter2 = m2.iterator();
            while (iter1.hasNext()) {
                TestUtils.assertDeepEquals(iter1.next(), iter2.next());
            }
            return;
        }
        if (Number.class.isAssignableFrom(one.getClass())) {
            Assert.assertEquals((long)((Number)one).longValue(), (long)((Number)another).longValue());
            return;
        }
        if (one instanceof Currency) {
            Currency currency1 = (Currency)one;
            Currency currency2 = (Currency)another;
            Assert.assertEquals((String)currency1.getCurrencyCode(), (String)currency2.getCurrencyCode());
            Assert.assertEquals((int)currency1.getDefaultFractionDigits(), (int)currency2.getDefaultFractionDigits());
        }
        for (Class<?> clazz = one.getClass(); clazz != null; clazz = clazz.getSuperclass()) {
            TestUtils.assertEqualDeclaredFields(clazz, one, another, alreadyChecked);
        }
    }

    public static void assertEqualDeclaredFields(Class<? extends Object> clazz, Object one, Object another, Map<Object, Object> alreadyChecked) {
        for (Field field : clazz.getDeclaredFields()) {
            field.setAccessible(true);
            if (Modifier.isTransient(field.getModifiers())) continue;
            try {
                TestUtils.assertDeepEquals(field.get(one), field.get(another), alreadyChecked);
            }
            catch (IllegalArgumentException e) {
                throw new RuntimeException(e);
            }
            catch (IllegalAccessException e) {
                throw new RuntimeException(e);
            }
        }
    }

    public static <T> Map<T, T> asMap(T ... keysAndValues) {
        if (keysAndValues == null) {
            return null;
        }
        if (keysAndValues.length % 2 != 0) {
            throw new IllegalArgumentException("You must provide an even number of arguments as key/value pairs.");
        }
        HashMap<T, T> result = new HashMap<T, T>();
        for (int i = 0; i < keysAndValues.length; ++i) {
            if ((i & 1) != 1) continue;
            result.put(keysAndValues[i - 1], keysAndValues[i]);
        }
        return result;
    }

    @DataProvider
    public static Object[][] stickynessProvider() {
        return new Object[][]{{SessionAffinityMode.STICKY}, {SessionAffinityMode.NON_STICKY}};
    }

    @DataProvider
    public static Object[][] booleanProvider() {
        return new Object[][]{{true}, {false}};
    }

    @Nonnull
    public static Key key(@Nonnull String value) {
        return new Key(ChannelBuffers.wrappedBuffer((byte[])value.getBytes()));
    }

    @Nonnull
    public static MemcachedBackupSession createSession(@Nonnull MemcachedSessionService service) {
        MemcachedBackupSession session = service.createEmptySession();
        session.setNew(true);
        session.setValid(true);
        session.setCreationTime(System.currentTimeMillis());
        session.setMaxInactiveInterval(23);
        session.setId("foo-n1");
        return session;
    }

    public static void waitForReconnect(StorageClient client, int expectedNumServers, long timeToWait) throws InterruptedException {
        TestUtils.waitForReconnect(((MemcachedStorageClient)client).getMemcachedClient(), expectedNumServers, timeToWait);
    }

    public static void waitForReconnect(MemcachedClient client, int expectedNumServers, long timeToWait) throws InterruptedException, RuntimeException {
        long start = System.currentTimeMillis();
        while (System.currentTimeMillis() < start + timeToWait) {
            if (client.getAvailableServers().size() >= expectedNumServers) {
                return;
            }
            Thread.sleep(20L);
        }
        throw new RuntimeException("MemcachedClient did not reconnect after " + timeToWait + " millis.");
    }

    public static <T, V> T assertNotNullElementWaitingWithProxy(int elementIndex, long maxTimeToWait, T objectToProxy) {
        return TestUtils.assertWaitingWithProxy(Predicates.elementAt(elementIndex, Predicates.notNull()), maxTimeToWait, objectToProxy);
    }

    public static <T, V> T assertWaitingWithProxy(final Predicate<V> predicate, final long maxTimeToWait, final T objectToProxy) {
        Class<?>[] interfaces = objectToProxy.getClass().getInterfaces();
        return (T)Proxy.newProxyInstance(Thread.currentThread().getContextClassLoader(), interfaces, new InvocationHandler(){

            @Override
            public Object invoke(Object proxy, Method method, Object[] args) throws Throwable {
                return TestUtils.assertPredicateWaiting(predicate, maxTimeToWait, objectToProxy, method, args);
            }
        });
    }

    private static <V> V assertPredicateWaiting(Predicate<V> predicate, long maxTimeToWait, Object obj, Method method, Object[] args) throws Exception {
        long start = System.currentTimeMillis();
        while (System.currentTimeMillis() < start + maxTimeToWait) {
            Object result = method.invoke(obj, args);
            if (predicate.apply(result)) {
                return (V)result;
            }
            try {
                Thread.sleep(10L);
            }
            catch (InterruptedException e) {
                Thread.currentThread().interrupt();
                throw new RuntimeException(e);
            }
        }
        throw new AssertionError((Object)"Expected not null, actual null.");
    }

    static {
        TestUtils.initLogConfig(TestUtils.class);
        System.setProperty("msm.nodeAvailabilityCacheTTL", "50");
    }

    public static class Predicates {
        private static final Predicate<Object> NOT_NULL = new Predicate<Object>(){

            @Override
            public boolean apply(Object input) {
                return input != null;
            }
        };
        private static final Predicate<Object> IS_NULL = new Predicate<Object>(){

            @Override
            public boolean apply(Object input) {
                return input == null;
            }
        };

        public static <T> Predicate<T> notNull() {
            return NOT_NULL;
        }

        public static <T> Predicate<T> isNull() {
            return IS_NULL;
        }

        public static <T> Predicate<T> equalTo(final @Nullable T target) {
            return target == null ? Predicates.isNull() : new Predicate<T>(){

                @Override
                public boolean apply(T input) {
                    return target.equals(input);
                }
            };
        }

        public static <T> Predicate<T[]> elementAt(final int index, final @Nonnull Predicate<T> elementPredicate) {
            return new Predicate<T[]>(){

                @Override
                public boolean apply(T[] input) {
                    return input != null && input.length > index && elementPredicate.apply(input[index]);
                }
            };
        }
    }

    public static interface Predicate<T> {
        public boolean apply(@Nullable T var1);
    }

    public static enum SessionAffinityMode {
        STICKY{

            @Override
            public boolean isSticky() {
                return true;
            }
        }
        ,
        NON_STICKY{

            @Override
            public boolean isSticky() {
                return false;
            }
        };


        public abstract boolean isSticky();
    }

    public static enum SessionTrackingMode {
        COOKIE,
        URL;

    }

    public static final class RecordingSessionActivationListener
    implements HttpSessionActivationListener,
    Serializable {
        private static final long serialVersionUID = 1L;
        private transient String _sessionDidActivate;

        public void sessionWillPassivate(HttpSessionEvent se) {
        }

        public void sessionDidActivate(HttpSessionEvent se) {
            this._sessionDidActivate = se.getSession().getId();
        }

        public String getSessionDidActivate() {
            return this._sessionDidActivate;
        }
    }

    public static class Response {
        private final String _sessionId;
        private final String _responseSessionId;
        private final String _content;
        private final Map<String, String> _keyValues;
        private final HttpResponse _response;

        public Response(HttpResponse response, String sessionId, String responseSessionId, String content, Map<String, String> keyValues) {
            this._response = response;
            this._sessionId = sessionId;
            this._responseSessionId = responseSessionId;
            this._content = content;
            this._keyValues = keyValues;
        }

        public int getStatusCode() {
            return this._response.getStatusLine().getStatusCode();
        }

        public String getHeader(String name) {
            Header header = this._response.getFirstHeader(name);
            return header == null ? null : header.getValue();
        }

        public String getSessionId() {
            return this._sessionId;
        }

        public String getResponseSessionId() {
            return this._responseSessionId;
        }

        public String getContent() {
            return this._content;
        }

        public Map<String, String> getKeyValues() {
            return this._keyValues;
        }

        public String get(String key) {
            return this._keyValues.get(key);
        }
    }

    public static enum LoginType {
        BASIC,
        FORM;

    }
}

