/*
 * Decompiled with CFR 0.152.
 */
package de.javakaffee.web.msm;

import de.javakaffee.web.msm.Statistics;
import java.lang.reflect.Method;
import org.testng.Assert;
import org.testng.annotations.DataProvider;
import org.testng.annotations.Test;

public class StatisticsTest {
    public static void main(String[] args) {
        Method[] methods;
        for (Method method : methods = Statistics.class.getMethods()) {
            if (!method.getName().startsWith("get")) continue;
            System.out.println(method.getName());
        }
    }

    @DataProvider(name="methodNamesProvider")
    public Object[][] createStatisticMethodNames() {
        return new Object[][]{{"getRequestsWithBackupFailure", "requestWithBackupFailure"}, {"getRequestsWithTomcatFailover", "requestWithTomcatFailover"}, {"getRequestsWithMemcachedFailover", "requestWithMemcachedFailover"}, {"getRequestsWithoutSession", "requestWithoutSession"}, {"getRequestsWithoutSessionAccess", "requestWithoutSessionAccess"}, {"getRequestsWithoutAttributesAccess", "requestWithoutAttributesAccess"}, {"getRequestsWithoutSessionModification", "requestWithoutSessionModification"}, {"getRequestsWithSession", "requestWithSession"}, {"getNonStickySessionsPingFailed", "nonStickySessionsPingFailed"}, {"getNonStickySessionsReadOnlyRequest", "nonStickySessionsReadOnlyRequest"}};
    }

    @Test(dataProvider="methodNamesProvider")
    public void testCounts(String getterMethod, String updateMethod) throws Exception {
        Statistics cut = Statistics.create();
        Method getMethod = Statistics.class.getMethod(getterMethod, new Class[0]);
        Assert.assertEquals((long)((Long)getMethod.invoke((Object)cut, new Object[0])), (long)0L);
        Statistics.class.getMethod(updateMethod, new Class[0]).invoke((Object)cut, new Object[0]);
        Assert.assertEquals((long)((Long)getMethod.invoke((Object)cut, new Object[0])), (long)1L);
    }

    @Test
    public void testDisabledRequestWithBackup() {
        Statistics cut = Statistics.create((boolean)false);
        Assert.assertEquals((long)cut.getRequestsWithBackupFailure(), (long)0L);
        cut.requestWithBackupFailure();
        Assert.assertEquals((long)cut.getRequestsWithBackupFailure(), (long)0L);
    }

    @Test
    public void testMinMaxAvgProbe() {
        Statistics.MinMaxAvgProbe cut = new Statistics.MinMaxAvgProbe();
        this.assertValues(cut, 0, 0, 0, 0.0);
        cut.register(1L);
        this.assertValues(cut, 1, 1, 1, 1.0);
        cut.register(1L);
        this.assertValues(cut, 2, 1, 1, 1.0);
        cut.register(4L);
        this.assertValues(cut, 3, 1, 4, 2.0);
        cut.register(0L);
        this.assertValues(cut, 4, 0, 4, 1.5);
    }

    private void assertValues(Statistics.MinMaxAvgProbe cut, int count, int min, int max, double avg) {
        Assert.assertEquals((int)cut.getCount(), (int)count);
        Assert.assertEquals((long)cut.getMin(), (long)min);
        Assert.assertEquals((long)cut.getMax(), (long)max);
        Assert.assertEquals((Object)cut.getAvg(), (Object)avg);
    }
}

