/*
 * Decompiled with CFR 0.152.
 */
package de.javakaffee.web.msm;

import de.javakaffee.web.msm.CurrentRequest;
import de.javakaffee.web.msm.MemcachedSessionService;
import de.javakaffee.web.msm.RequestTrackingHostValve;
import de.javakaffee.web.msm.Statistics;
import java.io.IOException;
import java.util.Collection;
import java.util.concurrent.atomic.AtomicBoolean;
import javax.annotation.Nonnull;
import javax.servlet.ServletException;
import javax.servlet.http.Cookie;
import org.apache.catalina.Container;
import org.apache.catalina.Context;
import org.apache.catalina.Host;
import org.apache.catalina.Valve;
import org.apache.catalina.connector.Request;
import org.apache.catalina.connector.Response;
import org.apache.tomcat.util.http.ServerCookie;
import org.mockito.Matchers;
import org.mockito.Mockito;
import org.mockito.verification.VerificationMode;
import org.testng.Assert;
import org.testng.annotations.AfterMethod;
import org.testng.annotations.BeforeMethod;
import org.testng.annotations.Test;

public abstract class RequestTrackingHostValveTest {
    protected MemcachedSessionService _service;
    private RequestTrackingHostValve _sessionTrackerValve;
    private Valve _nextValve;
    private Request _request;
    private Response _response;

    @BeforeMethod
    public void setUp() throws Exception {
        this._service = (MemcachedSessionService)Mockito.mock(MemcachedSessionService.class);
        this._request = (Request)Mockito.mock(Request.class);
        this._response = (Response)Mockito.mock(Response.class);
        Context _contextContainer = (Context)Mockito.mock(Context.class);
        Host _hostContainer = (Host)Mockito.mock(Host.class);
        MemcachedSessionService.SessionManager _manager = (MemcachedSessionService.SessionManager)Mockito.mock(MemcachedSessionService.SessionManager.class);
        Mockito.when((Object)this._service.getManager()).thenReturn((Object)_manager);
        Mockito.when((Object)_manager.getContext()).thenReturn((Object)_contextContainer);
        Mockito.when((Object)_contextContainer.getParent()).thenReturn((Object)_hostContainer);
        Mockito.when((Object)_contextContainer.getPath()).thenReturn((Object)"/");
        this._sessionTrackerValve = this.createSessionTrackerValve();
        this._nextValve = (Valve)Mockito.mock(Valve.class);
        this._sessionTrackerValve.setNext(this._nextValve);
        this._sessionTrackerValve.setContainer((Container)_hostContainer);
        Mockito.when((Object)this._request.getRequestURI()).thenReturn((Object)"/someRequest");
        Mockito.when((Object)this._request.getMethod()).thenReturn((Object)"GET");
        Mockito.when((Object)this._request.getQueryString()).thenReturn(null);
        Mockito.when((Object)this._request.getContext()).thenReturn((Object)_contextContainer);
        Mockito.when((Object)this._request.getNote((String)Matchers.eq((Object)"de.javakaffee.msm.request.processed"))).thenReturn((Object)Boolean.TRUE);
        Mockito.when((Object)this._request.getNote((String)Matchers.eq((Object)"de.javakaffee.msm.sessionIdChanged"))).thenReturn((Object)Boolean.FALSE);
    }

    @Nonnull
    protected RequestTrackingHostValve createSessionTrackerValve() {
        return new RequestTrackingHostValve(".*\\.(png|gif|jpg|css|js|ico)$", "somesessionid", this._service, Statistics.create(), new AtomicBoolean(true), new CurrentRequest()){

            protected String[] getSetCookieHeaders(Response response) {
                return RequestTrackingHostValveTest.this.getSetCookieHeaders(response);
            }
        };
    }

    protected abstract String[] getSetCookieHeaders(Response var1);

    @AfterMethod
    public void tearDown() throws Exception {
        Mockito.reset((Object[])new Object[]{this._service, this._nextValve, this._request, this._response});
    }

    @Test
    public final void testGetSessionCookieName() throws IOException, ServletException {
        RequestTrackingHostValve cut = new RequestTrackingHostValve(null, "foo", this._service, Statistics.create(), new AtomicBoolean(true), new CurrentRequest()){

            protected String[] getSetCookieHeaders(Response response) {
                Collection result = response.getHeaders("Set-Cookie");
                return result.toArray(new String[result.size()]);
            }
        };
        Assert.assertEquals((String)cut.getSessionCookieName(), (String)"foo");
    }

    @Test
    public final void testProcessRequestNotePresent() throws IOException, ServletException {
        this._sessionTrackerValve.invoke(this._request, this._response);
        ((MemcachedSessionService)Mockito.verify((Object)this._service, (VerificationMode)Mockito.never())).backupSession(Matchers.anyString(), Matchers.anyBoolean(), Matchers.anyString());
        ((Request)Mockito.verify((Object)this._request)).setNote((String)Matchers.eq((Object)"de.javakaffee.msm.request.process"), Matchers.eq((Object)Boolean.TRUE));
    }

    @Test
    public final void testBackupSessionNotInvokedWhenNoSessionIdPresent() throws IOException, ServletException {
        Mockito.when((Object)this._request.getRequestedSessionId()).thenReturn(null);
        Mockito.when((Object)this._response.getHeader((String)Matchers.eq((Object)"Set-Cookie"))).thenReturn(null);
        this._sessionTrackerValve.invoke(this._request, this._response);
        ((MemcachedSessionService)Mockito.verify((Object)this._service, (VerificationMode)Mockito.never())).backupSession(Matchers.anyString(), Matchers.anyBoolean(), Matchers.anyString());
    }

    @Test
    public final void testBackupSessionInvokedWhenResponseCookiePresent() throws IOException, ServletException {
        Mockito.when((Object)this._request.getRequestedSessionId()).thenReturn(null);
        Cookie cookie = new Cookie(this._sessionTrackerValve.getSessionCookieName(), "foo");
        this.setupGetResponseSetCookieHeadersExpectations(this._response, new String[]{this.generateCookieString(cookie)});
        this._sessionTrackerValve.invoke(this._request, this._response);
        ((MemcachedSessionService)Mockito.verify((Object)this._service)).backupSession((String)Matchers.eq((Object)"foo"), Matchers.eq((boolean)false), Matchers.anyString());
    }

    @Test
    public final void testChangeSessionIdForRelocatedSession() throws IOException, ServletException {
        String sessionId = "bar";
        String newSessionId = "newId";
        Mockito.when((Object)this._request.getNote((String)Matchers.eq((Object)"de.javakaffee.msm.sessionIdChanged"))).thenReturn((Object)Boolean.TRUE);
        Mockito.when((Object)this._request.getRequestedSessionId()).thenReturn((Object)"bar");
        Cookie cookie = new Cookie(this._sessionTrackerValve.getSessionCookieName(), "newId");
        this.setupGetResponseSetCookieHeadersExpectations(this._response, new String[]{this.generateCookieString(cookie)});
        this._sessionTrackerValve.invoke(this._request, this._response);
        ((MemcachedSessionService)Mockito.verify((Object)this._service)).backupSession((String)Matchers.eq((Object)"newId"), Matchers.eq((boolean)true), Matchers.anyString());
    }

    @Test
    public final void testRequestFinishedShouldBeInvokedForIgnoredResources() throws IOException, ServletException {
        Mockito.when((Object)this._request.getRequestedSessionId()).thenReturn((Object)"foo");
        Mockito.when((Object)this._request.getRequestURI()).thenReturn((Object)"/pixel.gif");
        this._sessionTrackerValve.invoke(this._request, this._response);
        ((MemcachedSessionService)Mockito.verify((Object)this._service)).requestFinished((String)Matchers.eq((Object)"foo"), Matchers.anyString());
    }

    protected abstract void setupGetResponseSetCookieHeadersExpectations(Response var1, String[] var2);

    @Nonnull
    protected String generateCookieString(Cookie cookie) {
        StringBuffer sb = new StringBuffer();
        ServerCookie.appendCookieValue((StringBuffer)sb, (int)cookie.getVersion(), (String)cookie.getName(), (String)cookie.getValue(), (String)cookie.getPath(), (String)cookie.getDomain(), (String)cookie.getComment(), (int)cookie.getMaxAge(), (boolean)cookie.getSecure(), (boolean)true);
        String setSessionCookieHeader = sb.toString();
        return setSessionCookieHeader;
    }
}

