/*
 * Decompiled with CFR 0.152.
 */
package de.javakaffee.web.msm;

import de.javakaffee.web.msm.MemcachedSessionService;
import de.javakaffee.web.msm.RequestTrackingContextValve;
import java.io.IOException;
import javax.annotation.Nonnull;
import javax.servlet.ServletException;
import org.apache.catalina.Valve;
import org.apache.catalina.connector.Request;
import org.apache.catalina.connector.Response;
import org.mockito.Matchers;
import org.mockito.Mockito;
import org.testng.Assert;
import org.testng.annotations.AfterMethod;
import org.testng.annotations.BeforeMethod;
import org.testng.annotations.Test;

public class RequestTrackingContextValveTest {
    protected MemcachedSessionService _service;
    private RequestTrackingContextValve _sessionTrackerValve;
    private Valve _nextValve;
    private Request _request;
    private Response _response;

    @BeforeMethod
    public void setUp() throws Exception {
        this._service = (MemcachedSessionService)Mockito.mock(MemcachedSessionService.class);
        this._sessionTrackerValve = this.createSessionTrackerValve();
        this._nextValve = (Valve)Mockito.mock(Valve.class);
        this._sessionTrackerValve.setNext(this._nextValve);
        this._request = (Request)Mockito.mock(Request.class);
        this._response = (Response)Mockito.mock(Response.class);
        Mockito.when((Object)this._request.getNote((String)Matchers.eq((Object)"de.javakaffee.msm.request.process"))).thenReturn((Object)Boolean.TRUE);
    }

    @Nonnull
    protected RequestTrackingContextValve createSessionTrackerValve() {
        return new RequestTrackingContextValve("foo", this._service);
    }

    @AfterMethod
    public void tearDown() throws Exception {
        Mockito.reset((Object[])new Object[]{this._service, this._nextValve, this._request, this._response});
    }

    @Test
    public final void testGetSessionCookieName() throws IOException, ServletException {
        RequestTrackingContextValve cut = new RequestTrackingContextValve("foo", this._service);
        Assert.assertEquals((String)cut.getSessionCookieName(), (String)"foo");
    }

    @Test
    public final void testRequestIsMarkedAsProcessed() throws IOException, ServletException {
        this._sessionTrackerValve.invoke(this._request, this._response);
        ((Request)Mockito.verify((Object)this._request)).setNote((String)Matchers.eq((Object)"de.javakaffee.msm.request.processed"), Matchers.eq((Object)Boolean.TRUE));
    }

    @Test
    public final void testChangeSessionIdForRelocatedSession() throws IOException, ServletException {
        String sessionId = "bar";
        String newSessionId = "newId";
        Mockito.when((Object)this._request.getRequestedSessionId()).thenReturn((Object)"bar");
        Mockito.when((Object)this._service.changeSessionIdOnMemcachedFailover((String)Matchers.eq((Object)"bar"))).thenReturn((Object)"newId");
        this._sessionTrackerValve.invoke(this._request, this._response);
        ((Request)Mockito.verify((Object)this._request)).changeSessionId((String)Matchers.eq((Object)"newId"));
        ((Request)Mockito.verify((Object)this._request)).setNote((String)Matchers.eq((Object)"de.javakaffee.msm.sessionIdChanged"), Matchers.eq((Object)Boolean.TRUE));
    }
}

