/*
 * Decompiled with CFR 0.152.
 */
package de.javakaffee.web.msm;

import de.javakaffee.web.msm.BackupResultStatus;
import de.javakaffee.web.msm.BackupSessionTask;
import de.javakaffee.web.msm.JavaSerializationTranscoder;
import de.javakaffee.web.msm.MemcachedBackupSession;
import de.javakaffee.web.msm.MemcachedSessionService;
import de.javakaffee.web.msm.SessionAttributesTranscoder;
import de.javakaffee.web.msm.TranscoderService;
import de.javakaffee.web.msm.integration.TestUtils;
import de.javakaffee.web.msm.integration.TomcatBuilder;
import java.io.IOException;
import java.io.UnsupportedEncodingException;
import java.lang.reflect.Method;
import java.util.Map;
import java.util.concurrent.ExecutionException;
import org.apache.juli.logging.Log;
import org.apache.juli.logging.LogFactory;
import org.testng.Assert;
import org.testng.annotations.AfterMethod;
import org.testng.annotations.BeforeMethod;
import org.testng.annotations.Test;
import redis.clients.jedis.BinaryJedis;
import redis.embedded.RedisServer;

public abstract class RedisIntegrationTest {
    private static final Log LOG = LogFactory.getLog(RedisIntegrationTest.class);
    private RedisServer embeddedRedisServer;
    private BinaryJedis redisClient;
    private TomcatBuilder<?> _tomcat1;
    private final int _portTomcat1 = 18888;
    private boolean redisProvided;
    private TranscoderService transcoderService;

    abstract TestUtils<?> getTestUtils();

    @BeforeMethod
    public void setUp(Method testMethod) throws Throwable {
        this.redisProvided = Boolean.parseBoolean(System.getProperty("redis.provided", "false"));
        int redisPort = Integer.parseInt(System.getProperty("redis.port", "16379"));
        if (!this.redisProvided) {
            this.embeddedRedisServer = new RedisServer(Integer.valueOf(redisPort));
            this.embeddedRedisServer.start();
        }
        try {
            System.setProperty("org.apache.catalina.startup.EXIT_ON_INIT_FAILURE", "true");
            this._tomcat1 = ((TomcatBuilder)this.getTestUtils().tomcatBuilder()).port(18888).memcachedNodes("redis://localhost:" + redisPort).sticky(true).buildAndStart();
        }
        catch (Throwable e) {
            LOG.error((Object)"could not start tomcat.", e);
            throw e;
        }
        this.redisClient = new BinaryJedis("localhost", redisPort);
        this.transcoderService = new TranscoderService((SessionAttributesTranscoder)new JavaSerializationTranscoder(this._tomcat1.getManager()));
    }

    @AfterMethod
    public void tearDown() throws Exception {
        if (this.redisClient != null) {
            this.redisClient.close();
            this.redisClient = null;
        }
        if (this.embeddedRedisServer != null) {
            this.embeddedRedisServer.stop();
            this.embeddedRedisServer = null;
        }
        this._tomcat1.stop();
    }

    @Test
    public void testBackupSessionInRedis() throws InterruptedException, ExecutionException, UnsupportedEncodingException, ClassNotFoundException, IOException {
        MemcachedSessionService service = this._tomcat1.getService();
        MemcachedBackupSession session = TestUtils.createSession(service);
        String sessionId = "12345";
        session.setId("12345");
        session.setAttribute("foo", (Object)"bar");
        BackupSessionTask.BackupResult backupResult = (BackupSessionTask.BackupResult)service.backupSession(session.getIdInternal(), false, null).get();
        Assert.assertEquals((Object)backupResult.getStatus(), (Object)BackupResultStatus.SUCCESS);
        MemcachedBackupSession loadedSession = this.transcoderService.deserialize(this.redisClient.get("12345".getBytes("UTF-8")), this._tomcat1.getManager());
        this.checkSession(loadedSession, session);
    }

    private void checkSession(MemcachedBackupSession actual, MemcachedBackupSession expected) {
        Assert.assertNotNull((Object)actual);
        Assert.assertEquals((String)actual.getId(), (String)expected.getId());
        Assert.assertEquals((Map)actual.getAttributesInternal(), (Map)expected.getAttributesInternal());
    }
}

