/*
 * Decompiled with CFR 0.152.
 */
package de.javakaffee.web.msm;

import de.javakaffee.web.msm.BackupResultStatus;
import de.javakaffee.web.msm.BackupSessionTask;
import de.javakaffee.web.msm.JavaSerializationTranscoder;
import de.javakaffee.web.msm.LockingStrategy;
import de.javakaffee.web.msm.MemcachedBackupSession;
import de.javakaffee.web.msm.MemcachedSessionService;
import de.javakaffee.web.msm.SessionAttributesTranscoder;
import de.javakaffee.web.msm.SessionIdFormat;
import de.javakaffee.web.msm.SessionValidityInfo;
import de.javakaffee.web.msm.TranscoderService;
import de.javakaffee.web.msm.integration.TestUtils;
import de.javakaffee.web.msm.storage.MemcachedStorageClient;
import de.javakaffee.web.msm.storage.StorageClient;
import java.util.Arrays;
import java.util.Collection;
import java.util.concurrent.Callable;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.CyclicBarrier;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import javax.annotation.Nonnull;
import net.spy.memcached.MemcachedClient;
import net.spy.memcached.internal.OperationFuture;
import net.spy.memcached.transcoders.Transcoder;
import org.apache.catalina.Context;
import org.apache.catalina.LifecycleException;
import org.apache.catalina.Session;
import org.apache.catalina.connector.Request;
import org.apache.catalina.core.StandardContext;
import org.mockito.ArgumentCaptor;
import org.mockito.Mockito;
import org.mockito.verification.VerificationMode;
import org.testng.Assert;
import org.testng.annotations.AfterMethod;
import org.testng.annotations.BeforeMethod;
import org.testng.annotations.Test;

public abstract class MemcachedSessionServiceTest {
    private MemcachedSessionService _service;
    private MemcachedClient _memcachedMock;
    private ExecutorService _executor;

    @BeforeMethod
    public void setup() throws Exception {
        StandardContext context = TestUtils.createContext();
        context.setBackgroundProcessorDelay(1);
        MemcachedSessionService.SessionManager manager = this.createSessionManager((Context)context);
        this._service = manager.getMemcachedSessionService();
        this._service.setMemcachedNodes("n1:127.0.0.1:11211");
        this._service.setSessionBackupAsync(false);
        this._service.setSticky(true);
        this._memcachedMock = (MemcachedClient)Mockito.mock(MemcachedClient.class);
        OperationFuture setResultMock = (OperationFuture)Mockito.mock(OperationFuture.class);
        Mockito.when((Object)setResultMock.get()).thenReturn((Object)Boolean.TRUE);
        Mockito.when((Object)setResultMock.get((long)Mockito.anyInt(), (TimeUnit)((Object)Mockito.any(TimeUnit.class)))).thenReturn((Object)Boolean.TRUE);
        Mockito.when((Object)this._memcachedMock.set((String)Mockito.any(String.class), Mockito.anyInt(), Mockito.any(), (Transcoder)Mockito.any(Transcoder.class))).thenReturn((Object)setResultMock);
        OperationFuture deleteResultMock = (OperationFuture)Mockito.mock(OperationFuture.class);
        Mockito.when((Object)deleteResultMock.get()).thenReturn((Object)Boolean.TRUE);
        Mockito.when((Object)this._memcachedMock.delete(Mockito.anyString())).thenReturn((Object)deleteResultMock);
        this.startInternal(manager, this._memcachedMock);
        this._executor = Executors.newCachedThreadPool();
    }

    @AfterMethod
    public void afterMethod() {
        this._executor.shutdown();
    }

    protected void startInternal(@Nonnull MemcachedSessionService.SessionManager manager, @Nonnull MemcachedClient memcachedMock) throws LifecycleException {
        throw new UnsupportedOperationException();
    }

    @Nonnull
    protected abstract MemcachedSessionService.SessionManager createSessionManager(Context var1);

    @Test
    public void testConfigurationFormatMemcachedNodesFeature44() throws LifecycleException {
        this._service.setMemcachedNodes("n1:127.0.0.1:11211");
        this._service.startInternal((StorageClient)new MemcachedStorageClient(this._memcachedMock));
        Assert.assertEquals((Collection)this._service.getNodeIds(), Arrays.asList("n1"));
        this._service.setMemcachedNodes("n1:127.0.0.1:11211 n2:127.0.0.1:11212");
        this._service.startInternal((StorageClient)new MemcachedStorageClient(this._memcachedMock));
        Assert.assertEquals((Collection)this._service.getNodeIds(), Arrays.asList("n1", "n2"));
        this._service.setMemcachedNodes("n1:127.0.0.1:11211,n2:127.0.0.1:11212");
        this._service.startInternal((StorageClient)new MemcachedStorageClient(this._memcachedMock));
        Assert.assertEquals((Collection)this._service.getNodeIds(), Arrays.asList("n1", "n2"));
    }

    @Test
    public void testConfigurationFormatFailoverNodesFeature44() throws LifecycleException {
        this._service.setMemcachedNodes("n1:127.0.0.1:11211 n2:127.0.0.1:11212");
        this._service.setFailoverNodes("n1");
        this._service.startInternal((StorageClient)new MemcachedStorageClient(this._memcachedMock));
        Assert.assertEquals((Collection)this._service.getFailoverNodeIds(), Arrays.asList("n1"));
        this._service.setMemcachedNodes("n1:127.0.0.1:11211 n2:127.0.0.1:11212 n3:127.0.0.1:11213");
        this._service.setFailoverNodes("n1 n2");
        this._service.startInternal((StorageClient)new MemcachedStorageClient(this._memcachedMock));
        Assert.assertEquals((Collection)this._service.getFailoverNodeIds(), Arrays.asList("n1", "n2"));
        this._service.setMemcachedNodes("n1:127.0.0.1:11211 n2:127.0.0.1:11212 n3:127.0.0.1:11213");
        this._service.setFailoverNodes("n1,n2");
        this._service.startInternal((StorageClient)new MemcachedStorageClient(this._memcachedMock));
        Assert.assertEquals((Collection)this._service.getFailoverNodeIds(), Arrays.asList("n1", "n2"));
    }

    @Test
    public void testConfigurationFormatMemcachedNodesFeature105() throws LifecycleException {
        this._service.setMemcachedNodes("127.0.0.1:11211");
        this._service.startInternal((StorageClient)new MemcachedStorageClient(this._memcachedMock));
        Assert.assertEquals((int)this._service.getMemcachedNodesManager().getCountNodes(), (int)1);
        Assert.assertEquals((boolean)this._service.getMemcachedNodesManager().isEncodeNodeIdInSessionId(), (boolean)false);
        Assert.assertEquals((boolean)this._service.getMemcachedNodesManager().isValidForMemcached("123456"), (boolean)true);
        this._service.shutdown();
        this._service.setMemcachedNodes("n1:127.0.0.1:11211");
        this._service.startInternal((StorageClient)new MemcachedStorageClient(this._memcachedMock));
        Assert.assertEquals((int)this._service.getMemcachedNodesManager().getCountNodes(), (int)1);
        Assert.assertEquals((boolean)this._service.getMemcachedNodesManager().isEncodeNodeIdInSessionId(), (boolean)true);
        Assert.assertEquals((boolean)this._service.getMemcachedNodesManager().isValidForMemcached("123456"), (boolean)false);
        Assert.assertEquals((boolean)this._service.getMemcachedNodesManager().isValidForMemcached("123456-n1"), (boolean)true);
    }

    @Test
    public void testBackupSessionFailureWithoutMemcachedNodeIdConfigured105() throws Exception {
        this._service.setMemcachedNodes("127.0.0.1:11211");
        this._service.setSessionBackupAsync(false);
        this._service.startInternal((StorageClient)new MemcachedStorageClient(this._memcachedMock));
        MemcachedBackupSession session = TestUtils.createSession(this._service);
        session.access();
        session.endAccess();
        session.setAttribute("foo", (Object)"bar");
        OperationFuture futureMock = (OperationFuture)Mockito.mock(OperationFuture.class);
        Mockito.when((Object)futureMock.get()).thenThrow(new Throwable[]{new ExecutionException(new RuntimeException("Simulated exception."))});
        Mockito.when((Object)futureMock.get((long)Mockito.anyInt(), (TimeUnit)((Object)Mockito.any(TimeUnit.class)))).thenThrow(new Throwable[]{new ExecutionException(new RuntimeException("Simulated exception."))});
        Mockito.when((Object)this._memcachedMock.set((String)Mockito.eq((Object)session.getId()), Mockito.anyInt(), Mockito.any(), (Transcoder)Mockito.any(Transcoder.class))).thenReturn((Object)futureMock);
        BackupSessionTask.BackupResult backupResult = (BackupSessionTask.BackupResult)this._service.backupSession(session.getIdInternal(), false, null).get();
        Assert.assertEquals((Object)backupResult.getStatus(), (Object)BackupResultStatus.FAILURE);
        ((MemcachedClient)Mockito.verify((Object)this._memcachedMock, (VerificationMode)Mockito.times((int)1))).set((String)Mockito.eq((Object)session.getId()), Mockito.anyInt(), Mockito.any(), (Transcoder)Mockito.any(Transcoder.class));
    }

    @Test
    public void testOnlySendModifiedSessions() throws InterruptedException, ExecutionException {
        MemcachedBackupSession session = TestUtils.createSession(this._service);
        session.access();
        session.endAccess();
        session.setAttribute("foo", (Object)"bar");
        this._service.backupSession(session.getIdInternal(), false, null).get();
        ((MemcachedClient)Mockito.verify((Object)this._memcachedMock, (VerificationMode)Mockito.times((int)1))).set((String)Mockito.eq((Object)session.getId()), Mockito.anyInt(), Mockito.any(), (Transcoder)Mockito.any(Transcoder.class));
        Thread.sleep(5L);
        session.access();
        session.endAccess();
        session.setAttribute("foo", (Object)"bar");
        session.setAttribute("bar", (Object)"baz");
        this._service.backupSession(session.getIdInternal(), false, null).get();
        ((MemcachedClient)Mockito.verify((Object)this._memcachedMock, (VerificationMode)Mockito.times((int)2))).set((String)Mockito.eq((Object)session.getId()), Mockito.anyInt(), Mockito.any(), (Transcoder)Mockito.any(Transcoder.class));
        Thread.sleep(5L);
        this._service.backupSession(session.getIdInternal(), false, null).get();
        ((MemcachedClient)Mockito.verify((Object)this._memcachedMock, (VerificationMode)Mockito.times((int)2))).set((String)Mockito.eq((Object)session.getId()), Mockito.anyInt(), Mockito.any(), (Transcoder)Mockito.any(Transcoder.class));
    }

    @Test
    public void testOnlyHashAttributesOfAccessedAttributes() throws InterruptedException, ExecutionException {
        TranscoderService transcoderServiceMock = (TranscoderService)Mockito.mock(TranscoderService.class);
        ConcurrentMap anyMap = (ConcurrentMap)Mockito.any(ConcurrentMap.class);
        Mockito.when((Object)transcoderServiceMock.serializeAttributes((MemcachedBackupSession)Mockito.any(MemcachedBackupSession.class), anyMap)).thenReturn((Object)new byte[0]);
        this._service.setTranscoderService(transcoderServiceMock);
        MemcachedBackupSession session = TestUtils.createSession(this._service);
        session.access();
        session.endAccess();
        session.setAttribute("foo", (Object)"bar");
        this._service.backupSession(session.getIdInternal(), false, null).get();
        ((TranscoderService)Mockito.verify((Object)transcoderServiceMock, (VerificationMode)Mockito.times((int)1))).serializeAttributes((MemcachedBackupSession)Mockito.eq((Object)session), (ConcurrentMap)Mockito.eq((Object)session.getAttributesInternal()));
        session.access();
        session.endAccess();
        this._service.backupSession(session.getIdInternal(), false, null).get();
        ((TranscoderService)Mockito.verify((Object)transcoderServiceMock, (VerificationMode)Mockito.times((int)1))).serializeAttributes((MemcachedBackupSession)Mockito.eq((Object)session), (ConcurrentMap)Mockito.eq((Object)session.getAttributesInternal()));
    }

    @Test
    public void testOnlyHashAttributesOfAccessedSessionsAndAttributes() throws InterruptedException, ExecutionException {
        TranscoderService transcoderServiceMock = (TranscoderService)Mockito.mock(TranscoderService.class);
        ConcurrentMap anyMap = (ConcurrentMap)Mockito.any(ConcurrentMap.class);
        Mockito.when((Object)transcoderServiceMock.serializeAttributes((MemcachedBackupSession)Mockito.any(MemcachedBackupSession.class), anyMap)).thenReturn((Object)new byte[0]);
        this._service.setTranscoderService(transcoderServiceMock);
        MemcachedBackupSession session = TestUtils.createSession(this._service);
        session.setAttribute("foo", (Object)"bar");
        this._service.backupSession(session.getIdInternal(), false, null).get();
        ((TranscoderService)Mockito.verify((Object)transcoderServiceMock, (VerificationMode)Mockito.times((int)1))).serializeAttributes((MemcachedBackupSession)Mockito.eq((Object)session), (ConcurrentMap)Mockito.eq((Object)session.getAttributesInternal()));
        Thread.sleep(5L);
        session.access();
        session.getAttribute("foo");
        this._service.backupSession(session.getIdInternal(), false, null).get();
        ((TranscoderService)Mockito.verify((Object)transcoderServiceMock, (VerificationMode)Mockito.times((int)2))).serializeAttributes((MemcachedBackupSession)Mockito.eq((Object)session), (ConcurrentMap)Mockito.eq((Object)session.getAttributesInternal()));
        Thread.sleep(5L);
        this._service.backupSession(session.getIdInternal(), false, null).get();
        ((TranscoderService)Mockito.verify((Object)transcoderServiceMock, (VerificationMode)Mockito.times((int)2))).serializeAttributes((MemcachedBackupSession)Mockito.eq((Object)session), (ConcurrentMap)Mockito.eq((Object)session.getAttributesInternal()));
    }

    @Test(dataProviderClass=TestUtils.class, dataProvider="stickynessProvider")
    public void testChangeSessionId(TestUtils.SessionAffinityMode stickyness) throws InterruptedException, ExecutionException, TimeoutException {
        this._service.setStickyInternal(stickyness.isSticky());
        if (!stickyness.isSticky()) {
            this._service.setLockingMode(LockingStrategy.LockingMode.NONE, null, false);
        }
        MemcachedBackupSession session = TestUtils.createSession(this._service);
        session.setAttribute("foo", (Object)"bar");
        this._service.backupSession(session.getIdInternal(), false, "foo").get();
        String oldSessionId = session.getId();
        this._service.getManager().changeSessionId((Session)session);
        this._service.backupSession(session.getIdInternal(), false, "foo");
        ((MemcachedClient)Mockito.verify((Object)this._memcachedMock, (VerificationMode)Mockito.times((int)1))).delete((String)Mockito.eq((Object)oldSessionId));
        ((MemcachedClient)Mockito.verify((Object)this._memcachedMock, (VerificationMode)Mockito.times((int)1))).set((String)Mockito.eq((Object)session.getId()), Mockito.anyInt(), Mockito.any(), (Transcoder)Mockito.any(Transcoder.class));
        if (!stickyness.isSticky()) {
            Thread.sleep(200L);
            ((MemcachedClient)Mockito.verify((Object)this._memcachedMock, (VerificationMode)Mockito.times((int)1))).delete((String)Mockito.eq((Object)new SessionIdFormat().createValidityInfoKeyName(oldSessionId)));
            ((MemcachedClient)Mockito.verify((Object)this._memcachedMock, (VerificationMode)Mockito.times((int)1))).set((String)Mockito.eq((Object)new SessionIdFormat().createValidityInfoKeyName(session.getId())), Mockito.anyInt(), Mockito.any(), (Transcoder)Mockito.any(Transcoder.class));
        }
    }

    @Test(dataProviderClass=TestUtils.class, dataProvider="stickynessProvider")
    public void testSessionTimeoutUnlimitedWithSessionLoaded(TestUtils.SessionAffinityMode stickyness) throws InterruptedException, ExecutionException, LifecycleException {
        this._service.setStickyInternal(stickyness.isSticky());
        if (!stickyness.isSticky()) {
            this._service.setLockingMode(LockingStrategy.LockingMode.NONE, null, false);
            this._service.setMemcachedNodes("n1:127.0.0.1:11211 n2:127.0.0.1:11212");
            this._service.startInternal((StorageClient)new MemcachedStorageClient(this._memcachedMock));
        }
        MemcachedBackupSession session = TestUtils.createSession(this._service);
        session.setMaxInactiveInterval(-1);
        session.access();
        session.endAccess();
        session.setAttribute("foo", (Object)"bar");
        String sessionId = session.getId();
        this._service.backupSession(sessionId, false, "unused").get();
        ((MemcachedClient)Mockito.verify((Object)this._memcachedMock, (VerificationMode)Mockito.times((int)1))).set((String)Mockito.eq((Object)sessionId), Mockito.eq((int)0), Mockito.any(), (Transcoder)Mockito.any(Transcoder.class));
        if (!stickyness.isSticky()) {
            String validityKey = new SessionIdFormat().createValidityInfoKeyName(sessionId);
            ((MemcachedClient)Mockito.verify((Object)this._memcachedMock, (VerificationMode)Mockito.times((int)1))).set((String)Mockito.eq((Object)validityKey), Mockito.eq((int)0), Mockito.any(), (Transcoder)Mockito.any(Transcoder.class));
            ExecutorService executorService = this._service.getLockingStrategy().getExecutorService();
            executorService.shutdown();
            executorService.awaitTermination(1L, TimeUnit.SECONDS);
            Thread.sleep(15L);
            String backupSessionKey = new SessionIdFormat().createBackupKey(sessionId);
            ((MemcachedClient)Mockito.verify((Object)this._memcachedMock, (VerificationMode)Mockito.times((int)1))).set((String)Mockito.eq((Object)backupSessionKey), Mockito.eq((int)0), Mockito.any(), (Transcoder)Mockito.any(Transcoder.class));
            String backupValidityKey = new SessionIdFormat().createBackupKey(validityKey);
            ((MemcachedClient)Mockito.verify((Object)this._memcachedMock, (VerificationMode)Mockito.times((int)1))).set((String)Mockito.eq((Object)backupValidityKey), Mockito.eq((int)0), Mockito.any(), (Transcoder)Mockito.any(Transcoder.class));
        }
    }

    @Test
    public void testSessionTimeoutUnlimitedWithNonStickySessionNotLoaded() throws InterruptedException, ExecutionException, LifecycleException, TimeoutException {
        this._service.setStickyInternal(false);
        this._service.setLockingMode(LockingStrategy.LockingMode.NONE, null, false);
        this._service.setMemcachedNodes("n1:127.0.0.1:11211 n2:127.0.0.1:11212");
        this._service.startInternal((StorageClient)new MemcachedStorageClient(this._memcachedMock));
        String sessionId = "someSessionNotLoaded-n1";
        String validityKey = new SessionIdFormat().createValidityInfoKeyName("someSessionNotLoaded-n1");
        byte[] validityData = SessionValidityInfo.encode((long)-1L, (long)System.currentTimeMillis(), (long)System.currentTimeMillis());
        Mockito.when((Object)this._memcachedMock.get((String)Mockito.eq((Object)validityKey), (Transcoder)Mockito.any(Transcoder.class))).thenReturn((Object)validityData);
        OperationFuture futureMock = (OperationFuture)Mockito.mock(OperationFuture.class);
        Mockito.when((Object)futureMock.get()).thenReturn((Object)Boolean.FALSE);
        Mockito.when((Object)futureMock.get((long)Mockito.anyInt(), (TimeUnit)((Object)Mockito.any(TimeUnit.class)))).thenReturn((Object)Boolean.FALSE);
        Mockito.when((Object)this._memcachedMock.add((String)Mockito.any(String.class), Mockito.anyInt(), Mockito.any(), (Transcoder)Mockito.any(Transcoder.class))).thenReturn((Object)futureMock);
        this._service.backupSession("someSessionNotLoaded-n1", false, "unused").get();
        ((MemcachedClient)Mockito.verify((Object)this._memcachedMock, (VerificationMode)Mockito.times((int)1))).set((String)Mockito.eq((Object)validityKey), Mockito.eq((int)0), Mockito.any(), (Transcoder)Mockito.any(Transcoder.class));
        this._service.getLockingStrategy().getExecutorService().shutdown();
        Thread.sleep(15L);
        ((MemcachedClient)Mockito.verify((Object)this._memcachedMock, (VerificationMode)Mockito.times((int)1))).add((String)Mockito.eq((Object)"someSessionNotLoaded-n1"), Mockito.anyInt(), Mockito.any(), (Transcoder)Mockito.any(Transcoder.class));
        String backupSessionKey = new SessionIdFormat().createBackupKey("someSessionNotLoaded-n1");
        ((MemcachedClient)Mockito.verify((Object)this._memcachedMock, (VerificationMode)Mockito.times((int)1))).add((String)Mockito.eq((Object)backupSessionKey), Mockito.anyInt(), Mockito.any(), (Transcoder)Mockito.any(Transcoder.class));
        String backupValidityKey = new SessionIdFormat().createBackupKey(validityKey);
        ((MemcachedClient)Mockito.verify((Object)this._memcachedMock, (VerificationMode)Mockito.times((int)1))).set((String)Mockito.eq((Object)backupValidityKey), Mockito.eq((int)0), Mockito.any(), (Transcoder)Mockito.any(Transcoder.class));
    }

    @Test
    public void testOnlyHashAttributesOfAccessedFilteredAttributes() throws InterruptedException, ExecutionException {
        TranscoderService transcoderServiceMock = (TranscoderService)Mockito.mock(TranscoderService.class);
        this._service.setTranscoderService(transcoderServiceMock);
        MemcachedBackupSession session = TestUtils.createSession(this._service);
        this._service.setSessionAttributeFilter("^(foo|bar)$");
        session.setAttribute("baz", (Object)"baz");
        session.access();
        session.endAccess();
        this._service.backupSession(session.getIdInternal(), false, null).get();
        ((TranscoderService)Mockito.verify((Object)transcoderServiceMock, (VerificationMode)Mockito.never())).serializeAttributes((MemcachedBackupSession)Mockito.any(), (ConcurrentMap)Mockito.any());
    }

    @Test
    public void testOnlyFilteredAttributesAreIncludedInSessionBackup() throws InterruptedException, ExecutionException {
        TranscoderService transcoderServiceMock = (TranscoderService)Mockito.mock(TranscoderService.class);
        ConcurrentMap anyMap = (ConcurrentMap)Mockito.any(ConcurrentMap.class);
        Mockito.when((Object)transcoderServiceMock.serializeAttributes((MemcachedBackupSession)Mockito.any(MemcachedBackupSession.class), anyMap)).thenReturn((Object)new byte[0]);
        this._service.setTranscoderService(transcoderServiceMock);
        MemcachedBackupSession session = TestUtils.createSession(this._service);
        this._service.setSessionAttributeFilter("^(foo|bar)$");
        session.setAttribute("foo", (Object)"foo");
        session.setAttribute("bar", (Object)"bar");
        session.setAttribute("baz", (Object)"baz");
        this._service.backupSession(session.getIdInternal(), false, null).get();
        ArgumentCaptor model = ArgumentCaptor.forClass(ConcurrentMap.class);
        ((TranscoderService)Mockito.verify((Object)transcoderServiceMock, (VerificationMode)Mockito.times((int)1))).serializeAttributes((MemcachedBackupSession)Mockito.eq((Object)session), (ConcurrentMap)model.capture());
        Assert.assertTrue((boolean)((ConcurrentMap)model.getValue()).containsKey("foo"));
        Assert.assertTrue((boolean)((ConcurrentMap)model.getValue()).containsKey("bar"));
        Assert.assertFalse((boolean)((ConcurrentMap)model.getValue()).containsKey("baz"));
    }

    @Test
    public void testOnlyFilteredAttributesAreIncludedDuringUpdateExpiration() throws InterruptedException, ExecutionException {
        TranscoderService transcoderServiceMock = (TranscoderService)Mockito.mock(TranscoderService.class);
        ConcurrentMap anyMap = (ConcurrentMap)Mockito.any(ConcurrentMap.class);
        Mockito.when((Object)transcoderServiceMock.serializeAttributes((MemcachedBackupSession)Mockito.any(MemcachedBackupSession.class), anyMap)).thenReturn((Object)new byte[0]);
        this._service.setTranscoderService(transcoderServiceMock);
        MemcachedBackupSession session = TestUtils.createSession(this._service);
        this._service.setSessionAttributeFilter("^(foo|bar)$");
        session.setAttribute("foo", (Object)"foo");
        session.setAttribute("bar", (Object)"bar");
        session.setAttribute("baz", (Object)"baz");
        session.access();
        session.endAccess();
        this._service.updateExpirationInMemcached();
        ArgumentCaptor model = ArgumentCaptor.forClass(ConcurrentMap.class);
        ((TranscoderService)Mockito.verify((Object)transcoderServiceMock, (VerificationMode)Mockito.times((int)1))).serializeAttributes((MemcachedBackupSession)Mockito.eq((Object)session), (ConcurrentMap)model.capture());
        Assert.assertTrue((boolean)((ConcurrentMap)model.getValue()).containsKey("foo"));
        Assert.assertTrue((boolean)((ConcurrentMap)model.getValue()).containsKey("bar"));
        Assert.assertFalse((boolean)((ConcurrentMap)model.getValue()).containsKey("baz"));
    }

    @Test
    public void testSessionsRefCountHandlingIssue111() throws Exception {
        this._service.setSticky(false);
        this._service.setLockingMode(LockingStrategy.LockingMode.ALL.name());
        TranscoderService transcoderService = new TranscoderService((SessionAttributesTranscoder)new JavaSerializationTranscoder());
        this._service.setTranscoderService(transcoderService);
        this._service.setStorageClient((StorageClient)new MemcachedStorageClient(this._memcachedMock));
        this._service.startInternal();
        OperationFuture addResultMock = (OperationFuture)Mockito.mock(OperationFuture.class);
        Mockito.when((Object)addResultMock.get()).thenReturn((Object)true);
        Mockito.when((Object)addResultMock.get(Mockito.anyLong(), (TimeUnit)((Object)Mockito.any(TimeUnit.class)))).thenReturn((Object)true);
        Mockito.when((Object)this._memcachedMock.add(Mockito.anyString(), Mockito.anyInt(), Mockito.any(), (Transcoder)Mockito.any(Transcoder.class))).thenReturn((Object)addResultMock);
        final MemcachedBackupSession session = TestUtils.createSession(this._service);
        Assert.assertNotNull((Object)session.getId());
        Future result = this._service.backupSession(session.getId(), false, "unused");
        Assert.assertFalse((boolean)this._service.getManager().getSessionsInternal().containsKey(session.getId()));
        Request requestMock = (Request)Mockito.mock(Request.class);
        Mockito.when((Object)requestMock.getNote((String)Mockito.eq((Object)"de.javakaffee.msm.contextValve.invoked"))).thenReturn((Object)Boolean.TRUE);
        this._service.getTrackingHostValve().storeRequestThreadLocal(requestMock);
        Mockito.when((Object)this._memcachedMock.get((String)Mockito.eq((Object)session.getId()), (Transcoder)Mockito.any(Transcoder.class))).thenReturn((Object)transcoderService.serialize(session));
        final MemcachedBackupSession session2 = this._service.findSession(session.getId());
        Assert.assertTrue((boolean)session2.isLocked());
        Assert.assertEquals((int)session2.getRefCount(), (int)1);
        session2.setAttribute("foo", (Object)"bar");
        final CyclicBarrier barrier = new CyclicBarrier(2);
        Future<BackupSessionTask.BackupResult> request2 = this._executor.submit(new Callable<BackupSessionTask.BackupResult>(){

            @Override
            public BackupSessionTask.BackupResult call() throws Exception {
                MemcachedBackupSession session3 = MemcachedSessionServiceTest.this._service.findSession(session.getId());
                Assert.assertSame((Object)session3, (Object)session2);
                Assert.assertEquals((int)session3.getRefCount(), (int)2);
                barrier.await();
                barrier.await();
                Future result = MemcachedSessionServiceTest.this._service.backupSession(session.getId(), false, "unused");
                MemcachedSessionServiceTest.this._service.getTrackingHostValve().resetRequestThreadLocal();
                Assert.assertEquals((Object)((BackupSessionTask.BackupResult)result.get()).getStatus(), (Object)BackupResultStatus.SUCCESS);
                Assert.assertFalse((boolean)MemcachedSessionServiceTest.this._service.getManager().getSessionsInternal().containsKey(session.getId()));
                Assert.assertEquals((int)session2.getRefCount(), (int)0);
                return (BackupSessionTask.BackupResult)result.get();
            }
        });
        barrier.await();
        result = this._service.backupSession(session.getId(), false, null);
        this._service.getTrackingHostValve().resetRequestThreadLocal();
        Assert.assertEquals((Object)((BackupSessionTask.BackupResult)result.get()).getStatus(), (Object)BackupResultStatus.SKIPPED);
        Assert.assertTrue((boolean)this._service.getManager().getSessionsInternal().containsKey(session.getId()));
        Assert.assertEquals((int)session2.getRefCount(), (int)1);
        barrier.await();
        request2.get();
    }

    @Test
    public void testInvalidNonStickySessionDoesNotCallOnBackupWithoutLoadedSessionIssue137() throws Exception {
        this._service.setStickyInternal(false);
        this._service.setLockingMode(LockingStrategy.LockingMode.NONE, null, false);
        this._service.startInternal((StorageClient)new MemcachedStorageClient(this._memcachedMock));
        String sessionId = "nonStickySessionToTimeOut-n1";
        Request requestMock = (Request)Mockito.mock(Request.class);
        Mockito.when((Object)requestMock.getNote((String)Mockito.eq((Object)"de.javakaffee.msm.contextValve.invoked"))).thenReturn((Object)Boolean.TRUE);
        this._service.getTrackingHostValve().storeRequestThreadLocal(requestMock);
        MemcachedBackupSession session = this._service.findSession("nonStickySessionToTimeOut-n1");
        Assert.assertNull((Object)session);
        this._service.backupSession("nonStickySessionToTimeOut-n1", false, null).get();
        String validityKey = new SessionIdFormat().createValidityInfoKeyName("nonStickySessionToTimeOut-n1");
        ((MemcachedClient)Mockito.verify((Object)this._memcachedMock, (VerificationMode)Mockito.times((int)0))).get((String)Mockito.eq((Object)validityKey));
    }
}

