/*
 * Decompiled with CFR 0.152.
 */
package de.javakaffee.web.msm;

import com.thimbleware.jmemcached.MemCacheDaemon;
import de.javakaffee.web.msm.MemcachedNodesManager;
import de.javakaffee.web.msm.MemcachedSessionService;
import de.javakaffee.web.msm.SessionIdFormat;
import de.javakaffee.web.msm.Statistics;
import de.javakaffee.web.msm.SuffixLocatorConnectionFactory;
import de.javakaffee.web.msm.integration.TestUtils;
import de.javakaffee.web.msm.integration.TomcatBuilder;
import de.javakaffee.web.msm.storage.MemcachedStorageClient;
import java.io.IOException;
import java.lang.reflect.Method;
import java.net.InetSocketAddress;
import java.util.Arrays;
import java.util.Map;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import javax.annotation.Nonnull;
import net.spy.memcached.ConnectionFactory;
import net.spy.memcached.DefaultConnectionFactory;
import net.spy.memcached.MemcachedClient;
import net.spy.memcached.MemcachedClientIF;
import net.spy.memcached.transcoders.Transcoder;
import org.apache.catalina.Context;
import org.apache.catalina.LifecycleException;
import org.apache.catalina.Session;
import org.apache.http.HttpException;
import org.apache.http.client.HttpClient;
import org.apache.http.impl.client.DefaultHttpClient;
import org.apache.juli.logging.Log;
import org.apache.juli.logging.LogFactory;
import org.awaitility.Awaitility;
import org.hamcrest.Matchers;
import org.testng.Assert;
import org.testng.annotations.AfterMethod;
import org.testng.annotations.BeforeMethod;
import org.testng.annotations.Test;

public abstract class MemcachedSessionManagerIntegrationTest {
    private static final Log LOG = LogFactory.getLog(MemcachedSessionManagerIntegrationTest.class);
    private static final String GROUP_WITHOUT_NODE_ID = "withoutNodeId";
    private MemCacheDaemon<?> _daemon;
    private MemcachedClientIF _memcached;
    private TomcatBuilder<?> _tomcat1;
    private int _portTomcat1;
    private final String _memcachedNodeId = "n1";
    private String _memcachedNodes;
    private DefaultHttpClient _httpClient;
    private int _memcachedPort;
    private final MemcachedNodesManager.StorageClientCallback _storageClientCallback = new MemcachedNodesManager.StorageClientCallback(){

        public byte[] get(String key) {
            return (byte[])MemcachedSessionManagerIntegrationTest.this._memcached.get(key, (Transcoder)MemcachedStorageClient.ByteArrayTranscoder.INSTANCE);
        }
    };

    @BeforeMethod
    public void setUp(Method testMethod) throws Throwable {
        this._portTomcat1 = 18888;
        this._memcachedPort = 21211;
        InetSocketAddress address = new InetSocketAddress("localhost", this._memcachedPort);
        this._daemon = TestUtils.createDaemon(address);
        this._daemon.start();
        String[] testGroups = testMethod.getAnnotation(Test.class).groups();
        String nodePrefix = testGroups.length == 0 || !GROUP_WITHOUT_NODE_ID.equals(testGroups[0]) ? "n1:" : "";
        this._memcachedNodes = nodePrefix + "localhost:" + this._memcachedPort;
        try {
            System.setProperty("org.apache.catalina.startup.EXIT_ON_INIT_FAILURE", "true");
            this._tomcat1 = this.tcBuilder().buildAndStart();
        }
        catch (Throwable e) {
            LOG.error((Object)"could not start tomcat.", e);
            throw e;
        }
        this._memcached = this.createMemcachedClient(this._memcachedNodes, address);
        this._httpClient = new DefaultHttpClient();
    }

    private TomcatBuilder<?> tcBuilder() {
        return ((TomcatBuilder)this.getTestUtils().tomcatBuilder()).port(this._portTomcat1).memcachedNodes(this._memcachedNodes).sticky(true).jvmRoute("app1");
    }

    private MemcachedClient createMemcachedClient(String memcachedNodes, InetSocketAddress address) throws IOException, InterruptedException {
        MemcachedNodesManager nodesManager = MemcachedNodesManager.createFor((String)memcachedNodes, null, null, (MemcachedNodesManager.StorageClientCallback)this._storageClientCallback);
        SuffixLocatorConnectionFactory cf = nodesManager.isEncodeNodeIdInSessionId() ? new SuffixLocatorConnectionFactory(nodesManager, nodesManager.getSessionIdFormat(), Statistics.create(), 1000L, 1000L) : new DefaultConnectionFactory();
        MemcachedClient result = new MemcachedClient((ConnectionFactory)cf, Arrays.asList(address));
        Thread.sleep(100L);
        return result;
    }

    @AfterMethod
    public void tearDown() throws Exception {
        this._memcached.shutdown();
        this._tomcat1.stop();
        this._httpClient.getConnectionManager().shutdown();
        this._daemon.stop();
    }

    @Test(enabled=true)
    public void testContextReload() throws IOException, InterruptedException, HttpException {
        String sessionId1 = TestUtils.post(this._httpClient, this._portTomcat1, null, "foo", "bar").getSessionId();
        Assert.assertNotNull((Object)sessionId1, (String)"No session created.");
        this._tomcat1.getContext().reload();
        TestUtils.Response response = TestUtils.get(this._httpClient, this._portTomcat1, sessionId1);
        String actualValue = response.get("foo");
        Assert.assertEquals((String)"bar", (String)actualValue);
    }

    @Test(enabled=true, dataProviderClass=TestUtils.class, dataProvider="stickynessProvider")
    public void testSessionUpdatedInMemcachedWhenSessionAttributeIsRemovedIssue106(TestUtils.SessionAffinityMode sessionAffinity) throws IOException, InterruptedException, HttpException {
        this.setStickyness(sessionAffinity);
        String key = "foo";
        String value = "bar";
        String sessionId1 = TestUtils.post(this._httpClient, this._portTomcat1, null, "foo", "bar").getSessionId();
        Assert.assertNotNull((Object)sessionId1, (String)"No session created.");
        TestUtils.Response response = TestUtils.get(this._httpClient, this._portTomcat1, sessionId1);
        Assert.assertEquals((String)response.getSessionId(), (String)sessionId1);
        Assert.assertEquals((String)response.get("foo"), (String)"bar");
        Map<String, String> params = TestUtils.asMap("remove", "foo");
        response = TestUtils.get(this._httpClient, this._portTomcat1, "/", sessionId1, params);
        Assert.assertEquals((String)response.getSessionId(), (String)sessionId1);
        Assert.assertNull((Object)response.get("foo"));
        response = TestUtils.get(this._httpClient, this._portTomcat1, sessionId1);
        Assert.assertEquals((String)response.getSessionId(), (String)sessionId1);
        Assert.assertNull((Object)response.get("foo"));
    }

    @Test(enabled=true)
    public void testConfiguredMemcachedNodeId() throws IOException, InterruptedException, HttpException {
        String sessionId1 = TestUtils.makeRequest((HttpClient)this._httpClient, this._portTomcat1, null);
        Assert.assertNotNull((Object)sessionId1, (String)"No session created.");
        String nodeId = sessionId1.substring(sessionId1.indexOf(45) + 1, sessionId1.indexOf(46));
        Assert.assertEquals((String)"n1", (String)nodeId, (String)"Invalid memcached node id");
    }

    @Test(enabled=true, groups={"withoutNodeId"})
    public void testSessionIdIsNotChangedIfSingleNodeWithNoMemcachedNodeIdConfigured() throws IOException, InterruptedException, HttpException {
        String sessionId1 = TestUtils.makeRequest((HttpClient)this._httpClient, this._portTomcat1, null);
        Assert.assertNotNull((Object)sessionId1, (String)"No session created.");
        Assert.assertTrue((sessionId1.indexOf(45) == -1 ? 1 : 0) != 0);
    }

    @Test(enabled=true, groups={"withoutNodeId"}, dataProviderClass=TestUtils.class, dataProvider="stickynessProvider")
    public void testSessionFoundIfSingleNodeWithNoMemcachedNodeIdConfigured(TestUtils.SessionAffinityMode sessionAffinity) throws IOException, InterruptedException, HttpException {
        this.setStickyness(sessionAffinity);
        String key = "foo";
        String value = "bar";
        String sessionId1 = TestUtils.post(this._httpClient, this._portTomcat1, null, "foo", "bar").getSessionId();
        Assert.assertNotNull((Object)sessionId1, (String)"No session created.");
        TestUtils.Response response = TestUtils.get(this._httpClient, this._portTomcat1, sessionId1);
        String sessionId2 = response.getSessionId();
        Assert.assertEquals((String)sessionId2, (String)sessionId1);
        String actualValue = response.get("foo");
        Assert.assertEquals((String)"bar", (String)actualValue);
    }

    @Test(enabled=true)
    public void testSessionIdJvmRouteCompatibility() throws IOException, InterruptedException, HttpException {
        String sessionId1 = TestUtils.makeRequest((HttpClient)this._httpClient, this._portTomcat1, null);
        Assert.assertNotNull((Object)sessionId1, (String)"No session created.");
        Assert.assertTrue((boolean)sessionId1.matches("[^-.]+-[^.]+(\\.[\\w]+)?"), (String)"Invalid session format, must be <sid>-<memcachedId>[.<jvmRoute>].");
    }

    @Test(enabled=true, dataProviderClass=TestUtils.class, dataProvider="stickynessProvider")
    public void testInvalidSessionId(TestUtils.SessionAffinityMode sessionAffinity) throws IOException, InterruptedException, HttpException {
        this.setStickyness(sessionAffinity);
        String sessionId1 = TestUtils.makeRequest((HttpClient)this._httpClient, this._portTomcat1, "12345");
        Assert.assertNotNull((Object)sessionId1, (String)"No session created.");
        Assert.assertTrue((sessionId1.indexOf(45) > -1 ? 1 : 0) != 0, (String)"Invalid session id format");
    }

    private void setStickyness(TestUtils.SessionAffinityMode sessionAffinity) {
        if (!sessionAffinity.isSticky()) {
            this._tomcat1.getEngine().setJvmRoute(null);
        }
        MemcachedSessionService.SessionManager manager = this._tomcat1.getManager();
        manager.setSticky(sessionAffinity.isSticky());
        try {
            TestUtils.waitForReconnect(manager.getMemcachedSessionService().getStorageClient(), 1, 500L);
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
            throw new RuntimeException(e);
        }
    }

    @Test(enabled=true, dataProviderClass=TestUtils.class, dataProvider="stickynessProvider")
    public void testSessionAvailableInMemcached(TestUtils.SessionAffinityMode sessionAffinity) throws IOException, InterruptedException, HttpException {
        this.setStickyness(sessionAffinity);
        String sessionId1 = TestUtils.makeRequest((HttpClient)this._httpClient, this._portTomcat1, null);
        Assert.assertNotNull((Object)sessionId1, (String)"No session created.");
        Thread.sleep(50L);
        Assert.assertNotNull((Object)this._memcached.get(sessionId1), (String)"Session not available in memcached.");
    }

    @Test(enabled=true, dataProviderClass=TestUtils.class, dataProvider="stickynessProvider")
    public void testSessionAvailableInMemcachedWithCookiesDisabled(TestUtils.SessionAffinityMode sessionAffinity) throws Exception {
        this._tomcat1.stop();
        this._tomcat1 = this.tcBuilder().sticky(sessionAffinity.isSticky()).cookies(false).jvmRoute("app1").buildAndStart();
        TestUtils.Response response = TestUtils.get(this._httpClient, this._portTomcat1, null);
        String sessionId = response.get("id");
        Assert.assertNotNull((Object)sessionId, (String)"No session created.");
        Thread.sleep(50L);
        Assert.assertNotNull((Object)this._memcached.get(sessionId), (String)"Session not available in memcached.");
    }

    @Test(enabled=true, dataProviderClass=TestUtils.class, dataProvider="stickynessProvider")
    public void testExpiredSessionRemovedFromMemcached(@Nonnull TestUtils.SessionAffinityMode sessionAffinity) throws IOException, InterruptedException, HttpException {
        this.setStickyness(sessionAffinity);
        String sessionId1 = TestUtils.makeRequest((HttpClient)this._httpClient, this._portTomcat1, null);
        Assert.assertNotNull((Object)sessionId1, (String)"No session created.");
        this.waitForSessionExpiration(sessionAffinity.isSticky());
        Assert.assertNull((Object)this._memcached.get(sessionId1), (String)"Expired session still existing in memcached");
    }

    @Test(enabled=true, dataProviderClass=TestUtils.class, dataProvider="stickynessProvider")
    public void testInvalidatedSessionRemovedFromMemcached(@Nonnull TestUtils.SessionAffinityMode sessionAffinity) throws IOException, InterruptedException, HttpException {
        this.setStickyness(sessionAffinity);
        final String sessionId1 = TestUtils.makeRequest((HttpClient)this._httpClient, this._portTomcat1, null);
        Assert.assertNotNull((Object)sessionId1, (String)"No session created.");
        TestUtils.Response response = TestUtils.get(this._httpClient, this._portTomcat1, "/invalidate", sessionId1);
        Assert.assertNull((Object)response.getResponseSessionId());
        Assert.assertNull((Object)this._memcached.get(sessionId1), (String)"Invalidated session still existing in memcached");
        if (!sessionAffinity.isSticky()) {
            Awaitility.await().until((Callable)new Callable<Object>(){

                @Override
                public Object call() throws Exception {
                    return MemcachedSessionManagerIntegrationTest.this._memcached.get(new SessionIdFormat().createValidityInfoKeyName(sessionId1));
                }
            }, Matchers.nullValue());
        }
    }

    @Test(enabled=true, dataProviderClass=TestUtils.class, dataProvider="stickynessProvider")
    public void testInvalidSessionNotFound(@Nonnull TestUtils.SessionAffinityMode sessionAffinity) throws IOException, InterruptedException, HttpException {
        this.setStickyness(sessionAffinity);
        String sessionId1 = TestUtils.makeRequest((HttpClient)this._httpClient, this._portTomcat1, null);
        Assert.assertNotNull((Object)sessionId1, (String)"No session created.");
        Thread.sleep(2100L);
        String sessionId2 = TestUtils.makeRequest((HttpClient)this._httpClient, this._portTomcat1, sessionId1);
        Assert.assertNotSame((Object)sessionId1, (Object)sessionId2, (String)"Expired session returned.");
    }

    @Test(enabled=true, dataProviderClass=TestUtils.class, dataProvider="stickynessProvider")
    public void testExpirationOfSessionsInMemcachedIfBackupWasSkippedSimple(TestUtils.SessionAffinityMode stickyness) throws Exception {
        MemcachedSessionService.SessionManager manager = this._tomcat1.getManager();
        this.setStickyness(stickyness);
        int delay = manager.getContext().getBackgroundProcessorDelay();
        manager.setMaxInactiveInterval(delay * 4);
        String sessionId1 = TestUtils.makeRequest((HttpClient)this._httpClient, this._portTomcat1, null);
        Assert.assertNotNull((Object)sessionId1, (String)"No session created.");
        Assert.assertNotNull((Object)this._memcached.get(sessionId1), (String)"Session not available in memcached.");
        Thread.sleep(TimeUnit.SECONDS.toMillis(delay * 2));
        Assert.assertEquals((String)TestUtils.makeRequest((HttpClient)this._httpClient, this._portTomcat1, sessionId1), (String)sessionId1, (String)"SessionId should be the same");
        Thread.sleep(TimeUnit.SECONDS.toMillis(delay * 3));
        Assert.assertNotNull((Object)this._memcached.get(sessionId1), (String)"Session should still exist in memcached.");
        Thread.sleep(TimeUnit.SECONDS.toMillis(delay) + 500L);
        Assert.assertNotSame((Object)TestUtils.makeRequest((HttpClient)this._httpClient, this._portTomcat1, sessionId1), (Object)sessionId1, (String)"The sessionId should have changed due to expired sessin");
    }

    @Test(enabled=true, dataProviderClass=TestUtils.class, dataProvider="stickynessProvider")
    public void testExpirationOfSessionsInMemcachedIfBackupWasSkippedManyReadonlyRequests(TestUtils.SessionAffinityMode stickyness) throws Exception {
        MemcachedSessionService.SessionManager manager = this._tomcat1.getManager();
        this.setStickyness(stickyness);
        int delay = manager.getContext().getBackgroundProcessorDelay();
        manager.setMaxInactiveInterval(delay * 4);
        String sessionId1 = TestUtils.makeRequest((HttpClient)this._httpClient, this._portTomcat1, null);
        Assert.assertNotNull((Object)sessionId1, (String)"No session created.");
        TestUtils.assertWaitingWithProxy(TestUtils.Predicates.notNull(), 200L, this._memcached).get(sessionId1);
        Thread.sleep(TimeUnit.SECONDS.toMillis(delay * 3));
        Assert.assertEquals((String)TestUtils.makeRequest((HttpClient)this._httpClient, this._portTomcat1, sessionId1), (String)sessionId1, (String)"SessionId should be the same");
        Assert.assertNotNull((Object)this._memcached.get(sessionId1), (String)"Session should still exist in memcached.");
        Thread.sleep(TimeUnit.SECONDS.toMillis(delay * 3));
        Assert.assertEquals((String)TestUtils.makeRequest((HttpClient)this._httpClient, this._portTomcat1, sessionId1), (String)sessionId1, (String)"SessionId should be the same");
        Assert.assertNotNull((Object)this._memcached.get(sessionId1), (String)"Session should still exist in memcached.");
        Thread.sleep(TimeUnit.SECONDS.toMillis(manager.getMaxInactiveInterval()) - 500L);
        Assert.assertNotNull((Object)this._memcached.get(sessionId1), (String)"Session should still exist in memcached.");
        Thread.sleep(TimeUnit.SECONDS.toMillis(delay) + 500L);
        Assert.assertNotSame((Object)TestUtils.makeRequest((HttpClient)this._httpClient, this._portTomcat1, sessionId1), (Object)sessionId1, (String)"The sessionId should have changed due to expired sessin");
    }

    @Test(enabled=true)
    public void testNotAssociatedSessionGetsAssociatedIssue49() throws InterruptedException, IOException, ExecutionException, TimeoutException {
        this._daemon.stop();
        MemcachedSessionService.SessionManager manager = this._tomcat1.getManager();
        manager.setMaxInactiveInterval(5);
        manager.setSticky(true);
        SessionIdFormat sessionIdFormat = new SessionIdFormat();
        Session session = manager.createSession(null);
        Assert.assertNull((Object)sessionIdFormat.extractMemcachedId(session.getId()));
        this._daemon.start();
        TestUtils.waitForReconnect(manager.getMemcachedSessionService().getStorageClient(), 1, 4000L);
        String newSessionId = manager.getMemcachedSessionService().changeSessionIdOnMemcachedFailover(session.getId());
        Assert.assertNotNull((Object)newSessionId);
        Assert.assertEquals((String)newSessionId, (String)session.getId());
        Assert.assertEquals((String)sessionIdFormat.extractMemcachedId(newSessionId), (String)"n1");
    }

    @Test(enabled=true)
    public void testDisableMsmAtRuntime() throws InterruptedException, IOException, ExecutionException, TimeoutException, LifecycleException, HttpException {
        MemcachedSessionService.SessionManager manager = this._tomcat1.getManager();
        manager.setSticky(true);
        manager.setEnabled(false);
        this._memcached.shutdown();
        this._daemon.stop();
        this.checkSessionFunctionalityWithMsmDisabled();
    }

    @Test(enabled=true)
    public void testStartMsmDisabled() throws Exception {
        this._memcached.shutdown();
        this._daemon.stop();
        this._tomcat1.stop();
        Thread.sleep(500L);
        String memcachedNodes = "n1:localhost:" + this._memcachedPort;
        this._tomcat1 = ((TomcatBuilder)this.getTestUtils().tomcatBuilder()).port(this._portTomcat1).memcachedNodes(memcachedNodes).sticky(true).enabled(false).jvmRoute("app1").buildAndStart();
        LOG.info((Object)"Waiting, check logs to see if the client causes any 'Connection refused' logging...");
        Thread.sleep(1000L);
        this.checkSessionFunctionalityWithMsmDisabled();
        this._daemon.start();
        this._memcached = this.createMemcachedClient(memcachedNodes, new InetSocketAddress("localhost", this._memcachedPort));
        this._tomcat1.getManager().setEnabled(true);
        Thread.sleep(100L);
        String sessionId1 = TestUtils.makeRequest((HttpClient)this._httpClient, this._portTomcat1, null);
        Assert.assertNotNull((Object)sessionId1, (String)"No session created.");
        Assert.assertNotNull((Object)new SessionIdFormat().extractMemcachedId(sessionId1), (String)"memcached node id missing with msm switched to enabled");
        Thread.sleep(50L);
        Assert.assertNotNull((Object)this._memcached.get(sessionId1), (String)"Session not available in memcached.");
        this.waitForSessionExpiration(true);
        Assert.assertNull((Object)this._memcached.get(sessionId1), (String)"Expired session still existing in memcached");
    }

    abstract TestUtils<?> getTestUtils();

    private void checkSessionFunctionalityWithMsmDisabled() throws IOException, HttpException, InterruptedException {
        Assert.assertTrue((boolean)this._tomcat1.getManager().getMemcachedSessionService().isSticky());
        String sessionId1 = TestUtils.makeRequest((HttpClient)this._httpClient, this._portTomcat1, null);
        Assert.assertNotNull((Object)sessionId1, (String)"No session created.");
        Assert.assertNull((Object)new SessionIdFormat().extractMemcachedId(sessionId1), (String)"Got a memcached node id, even with msm disabled.");
        this.waitForSessionExpiration(true);
        String sessionId2 = TestUtils.makeRequest((HttpClient)this._httpClient, this._portTomcat1, sessionId1);
        Assert.assertNotSame((Object)sessionId2, (Object)sessionId1, (String)"SessionId not changed.");
    }

    private void waitForSessionExpiration(boolean sticky) throws InterruptedException {
        MemcachedSessionService.SessionManager manager = this._tomcat1.getManager();
        Assert.assertEquals((boolean)manager.getMemcachedSessionService().isSticky(), (boolean)sticky);
        Context container = manager.getContext();
        long timeout = TimeUnit.SECONDS.toMillis(sticky ? (long)(container.getBackgroundProcessorDelay() + manager.getMaxInactiveInterval()) : (long)(2 * manager.getMaxInactiveInterval())) + 1000L;
        Thread.sleep(timeout);
    }
}

