/*
 * Decompiled with CFR 0.152.
 */
package de.javakaffee.web.msm;

import de.javakaffee.web.msm.MemcachedNodesManager;
import de.javakaffee.web.msm.NodeIdList;
import de.javakaffee.web.msm.SessionIdFormat;
import de.javakaffee.web.msm.StorageKeyFormat;
import java.io.IOException;
import java.net.InetSocketAddress;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import net.spy.memcached.OperationTimeoutException;
import org.mockito.Matchers;
import org.mockito.Mockito;
import org.testng.Assert;
import org.testng.annotations.BeforeMethod;
import org.testng.annotations.DataProvider;
import org.testng.annotations.Test;

public class MemcachedNodesManagerTest {
    private MemcachedNodesManager.StorageClientCallback _mcc;

    @BeforeMethod
    public void beforeClass() {
        this._mcc = (MemcachedNodesManager.StorageClientCallback)Mockito.mock(MemcachedNodesManager.StorageClientCallback.class);
    }

    @Test(expectedExceptions={IllegalArgumentException.class})
    public void testParseWithNullShouldThrowException() {
        MemcachedNodesManager.createFor(null, null, null, (MemcachedNodesManager.StorageClientCallback)this._mcc);
    }

    @Test(expectedExceptions={IllegalArgumentException.class})
    public void testParseWithEmptyStringShouldThrowException() {
        MemcachedNodesManager.createFor((String)"", null, null, (MemcachedNodesManager.StorageClientCallback)this._mcc);
    }

    @Test(expectedExceptions={IllegalArgumentException.class})
    public void testSingleSimpleNodeAndFailoverNodeShouldThrowException() {
        MemcachedNodesManager.createFor((String)"localhost:11211", (String)"n1", null, (MemcachedNodesManager.StorageClientCallback)this._mcc);
    }

    @Test(expectedExceptions={IllegalArgumentException.class})
    public void testSingleNodeAndFailoverNodeShouldThrowException() {
        MemcachedNodesManager.createFor((String)"n1:localhost:11211", (String)"n1", null, (MemcachedNodesManager.StorageClientCallback)this._mcc);
    }

    @Test(expectedExceptions={IllegalArgumentException.class})
    public void testCouchbaseNodesAndFailoverNodeShouldThrowException() {
        MemcachedNodesManager.createFor((String)"http://localhost:8091/pools", (String)"n1", null, (MemcachedNodesManager.StorageClientCallback)this._mcc);
    }

    @DataProvider
    public static Object[][] nodesAndExpectedCountDataProvider() {
        return new Object[][]{{"localhost:11211", 1}, {"http://localhost:8091/pools", 1}, {"http://10.10.0.1:8091/pools,http://10.10.0.2:8091/pools", 2}, {"n1:localhost:11211", 1}, {"n1:localhost:11211,n2:localhost:11212", 2}, {"n1:localhost:11211 n2:localhost:11212", 2}};
    }

    @Test(dataProvider="nodesAndExpectedCountDataProvider")
    public void testCountNodes(String memcachedNodes, int expectedCount) {
        MemcachedNodesManager result = MemcachedNodesManager.createFor((String)memcachedNodes, null, null, (MemcachedNodesManager.StorageClientCallback)this._mcc);
        Assert.assertNotNull((Object)result);
        Assert.assertEquals((int)result.getCountNodes(), (int)expectedCount);
    }

    @DataProvider
    public static Object[][] nodesAndPrimaryNodesDataProvider() {
        return new Object[][]{{"localhost:11211", null, new NodeIdList(new String[0])}, {"http://localhost:8091/pools", null, new NodeIdList(new String[0])}, {"http://10.10.0.1:8091/pools,http://10.10.0.2:8091/pools", null, new NodeIdList(new String[0])}, {"n1:localhost:11211", null, new NodeIdList(new String[]{"n1"})}, {"n1:localhost:11211,n2:localhost:11212", "n1", new NodeIdList(new String[]{"n2"})}, {"n1:localhost:11211,n2:localhost:11212,n3:localhost:11213", "n1", new NodeIdList(new String[]{"n2", "n3"})}, {"n1:localhost:11211,n2:localhost:11212,n3:localhost:11213", "n1,n2", new NodeIdList(new String[]{"n3"})}};
    }

    @Test(dataProvider="nodesAndPrimaryNodesDataProvider")
    public void testPrimaryNodes(String memcachedNodes, String failoverNodes, NodeIdList expectedPrimaryNodeIds) {
        MemcachedNodesManager result = MemcachedNodesManager.createFor((String)memcachedNodes, (String)failoverNodes, null, (MemcachedNodesManager.StorageClientCallback)this._mcc);
        Assert.assertNotNull((Object)result);
        Assert.assertEquals((Collection)result.getPrimaryNodeIds(), (Collection)expectedPrimaryNodeIds);
    }

    @DataProvider
    public static Object[][] nodesAndFailoverNodesDataProvider() {
        return new Object[][]{{"localhost:11211", null, Collections.emptyList()}, {"localhost:11211", "", Collections.emptyList()}, {"http://localhost:8091/pools", null, Collections.emptyList()}, {"n1:localhost:11211", null, Collections.emptyList()}, {"n1:localhost:11211,n2:localhost:11212", "n1", Arrays.asList("n1")}, {"n1:localhost:11211,n2:localhost:11212,n3:localhost:11213", "n1,n2", Arrays.asList("n1", "n2")}, {"n1:localhost:11211,n2:localhost:11212,n3:localhost:11213", "n1 n2", Arrays.asList("n1", "n2")}};
    }

    @Test(dataProvider="nodesAndFailoverNodesDataProvider")
    public void testFailoverNodes(String memcachedNodes, String failoverNodes, List<String> expectedFailoverNodeIds) {
        MemcachedNodesManager result = MemcachedNodesManager.createFor((String)memcachedNodes, (String)failoverNodes, null, (MemcachedNodesManager.StorageClientCallback)this._mcc);
        Assert.assertNotNull((Object)result);
        Assert.assertEquals((Collection)result.getFailoverNodeIds(), expectedFailoverNodeIds);
    }

    @DataProvider
    public static Object[][] nodesAndExpectedEncodedInSessionIdDataProvider() {
        return new Object[][]{{"localhost:11211", null, false}, {"http://localhost:8091/pools", null, false}, {"http://10.10.0.1:8091/pools,http://10.10.0.2:8091/pools", null, false}, {"n1:localhost:11211", null, true}, {"n1:localhost:11211,n2:localhost:11212", "n1", true}};
    }

    @Test(dataProvider="nodesAndExpectedEncodedInSessionIdDataProvider")
    public void testIsEncodeNodeIdInSessionId(String memcachedNodes, String failoverNodes, boolean expectedIsEncodeNodeIdInSessionId) {
        MemcachedNodesManager result = MemcachedNodesManager.createFor((String)memcachedNodes, null, null, (MemcachedNodesManager.StorageClientCallback)this._mcc);
        Assert.assertNotNull((Object)result);
        Assert.assertEquals((boolean)result.isEncodeNodeIdInSessionId(), (boolean)expectedIsEncodeNodeIdInSessionId);
    }

    @Test(expectedExceptions={IllegalArgumentException.class})
    public void testGetNodeIdShouldThrowExceptionForNullArgument() {
        MemcachedNodesManager result = MemcachedNodesManager.createFor((String)"n1:localhost:11211", null, null, (MemcachedNodesManager.StorageClientCallback)this._mcc);
        result.getNodeId(null);
    }

    @DataProvider
    public static Object[][] testGetNodeIdDataProvider() {
        return new Object[][]{{"n1:localhost:11211", null, new InetSocketAddress("localhost", 11211), "n1"}, {"n1:localhost:11211,n2:localhost:11212", null, new InetSocketAddress("localhost", 11212), "n2"}, {"n1:localhost:11211,n2:localhost:11212", "n1", new InetSocketAddress("localhost", 11211), "n1"}};
    }

    @Test(dataProvider="testGetNodeIdDataProvider")
    public void testGetNodeId(String memcachedNodes, String failoverNodes, InetSocketAddress socketAddress, String expectedNodeId) {
        MemcachedNodesManager result = MemcachedNodesManager.createFor((String)memcachedNodes, (String)failoverNodes, null, (MemcachedNodesManager.StorageClientCallback)this._mcc);
        Assert.assertEquals((String)result.getNodeId(socketAddress), (String)expectedNodeId);
    }

    @Test
    public void testGetNextPrimaryNodeId() {
        Assert.assertNull((Object)MemcachedNodesManager.createFor((String)"n1:localhost:11211", null, null, (MemcachedNodesManager.StorageClientCallback)this._mcc).getNextPrimaryNodeId("n1"));
        Assert.assertEquals((String)MemcachedNodesManager.createFor((String)"n1:localhost:11211,n2:localhost:11212", null, null, (MemcachedNodesManager.StorageClientCallback)this._mcc).getNextPrimaryNodeId("n1"), (String)"n2");
    }

    @Test
    public void testGetNextAvailableNodeId() throws IOException {
        Assert.assertNull((Object)MemcachedNodesManager.createFor((String)"n1:localhost:11211", null, null, (MemcachedNodesManager.StorageClientCallback)this._mcc).getNextAvailableNodeId("n1"));
        Assert.assertEquals((String)MemcachedNodesManager.createFor((String)"n1:localhost:11211,n2:localhost:11212", null, null, (MemcachedNodesManager.StorageClientCallback)this._mcc).getNextAvailableNodeId("n1"), (String)"n2");
        MemcachedNodesManager.StorageClientCallback mcc = (MemcachedNodesManager.StorageClientCallback)Mockito.mock(MemcachedNodesManager.StorageClientCallback.class);
        Mockito.when((Object)mcc.get(Matchers.anyString())).thenReturn(null);
        Mockito.when((Object)mcc.get(Matchers.endsWith((String)"n2"))).thenThrow(new Throwable[]{new OperationTimeoutException("SimulatedException")});
        Assert.assertNull((Object)MemcachedNodesManager.createFor((String)"n1:localhost:11211,n2:localhost:11212", null, null, (MemcachedNodesManager.StorageClientCallback)mcc).getNextAvailableNodeId("n1"));
        Assert.assertEquals((String)MemcachedNodesManager.createFor((String)"n1:localhost:11211,n2:localhost:11212,n3:localhost:11213", null, null, (MemcachedNodesManager.StorageClientCallback)mcc).getNextAvailableNodeId("n1"), (String)"n3");
    }

    @DataProvider
    public static Object[][] testgGetAllMemcachedAddressesDataProvider() {
        return new Object[][]{{"localhost:11211", null, Arrays.asList(new InetSocketAddress("localhost", 11211))}, {"http://localhost:8091/pools", null, Arrays.asList(new InetSocketAddress("localhost", 8091))}, {"http://10.10.0.1:8091/pools,http://10.10.0.2:8091/pools", null, Arrays.asList(new InetSocketAddress("10.10.0.1", 8091), new InetSocketAddress("10.10.0.2", 8091))}, {"n1:localhost:11211", null, Arrays.asList(new InetSocketAddress("localhost", 11211))}, {"n1:localhost:11211,n2:localhost:11212", null, Arrays.asList(new InetSocketAddress("localhost", 11211), new InetSocketAddress("localhost", 11212))}, {"n1:localhost:11211,n2:localhost:11212", "n1", Arrays.asList(new InetSocketAddress("localhost", 11211), new InetSocketAddress("localhost", 11212))}};
    }

    @Test(dataProvider="testgGetAllMemcachedAddressesDataProvider")
    public void testGetAllMemcachedAddresses(String memcachedNodes, String failoverNodes, Collection<InetSocketAddress> expectedSocketAddresses) {
        MemcachedNodesManager result = MemcachedNodesManager.createFor((String)memcachedNodes, (String)failoverNodes, null, (MemcachedNodesManager.StorageClientCallback)this._mcc);
        Assert.assertEquals((Collection)result.getAllMemcachedAddresses(), expectedSocketAddresses);
    }

    @Test
    public void testGetSessionIdFormat() {
        SessionIdFormat sessionIdFormat = MemcachedNodesManager.createFor((String)"n1:localhost:11211", null, null, (MemcachedNodesManager.StorageClientCallback)this._mcc).getSessionIdFormat();
        Assert.assertNotNull((Object)sessionIdFormat);
    }

    @Test
    public void testSessionIdFormatForSingleNodeSetupShouldSupportLocking() {
        SessionIdFormat sessionIdFormat = MemcachedNodesManager.createFor((String)"localhost:11211", null, (StorageKeyFormat)StorageKeyFormat.EMPTY, (MemcachedNodesManager.StorageClientCallback)this._mcc).getSessionIdFormat();
        Assert.assertNotNull((Object)sessionIdFormat);
        String sessionId = "12345678";
        Assert.assertEquals((String)sessionIdFormat.createLockName("12345678"), (String)"lock:12345678");
    }

    @Test
    public void testCreateSessionIdShouldOnlyAddNodeIdIfPresent() {
        Assert.assertEquals((String)MemcachedNodesManager.createFor((String)"n1:localhost:11211", null, null, (MemcachedNodesManager.StorageClientCallback)this._mcc).createSessionId("foo"), (String)"foo-n1");
        Assert.assertEquals((String)MemcachedNodesManager.createFor((String)"localhost:11211", null, null, (MemcachedNodesManager.StorageClientCallback)this._mcc).createSessionId("foo"), (String)"foo");
    }

    @Test
    public void testSetNodeAvailable() {
        MemcachedNodesManager cut = MemcachedNodesManager.createFor((String)"n1:localhost:11211,n2:localhost:11212", null, null, (MemcachedNodesManager.StorageClientCallback)this._mcc);
        Assert.assertTrue((boolean)cut.isNodeAvailable("n1"));
        Assert.assertTrue((boolean)cut.isNodeAvailable("n2"));
        cut.setNodeAvailable("n1", false);
        Assert.assertFalse((boolean)cut.isNodeAvailable("n1"));
        Assert.assertTrue((boolean)cut.isNodeAvailable("n2"));
    }

    @Test
    public void testIsCouchbaseBucketConfig() {
        Assert.assertTrue((boolean)MemcachedNodesManager.createFor((String)"http://10.10.0.1:8091/pools", null, null, (MemcachedNodesManager.StorageClientCallback)this._mcc).isCouchbaseBucketConfig());
        Assert.assertTrue((boolean)MemcachedNodesManager.createFor((String)"http://10.10.0.1:8091/pools,http://10.10.0.2:8091/pools", null, null, (MemcachedNodesManager.StorageClientCallback)this._mcc).isCouchbaseBucketConfig());
    }

    @Test
    public void testGetCouchbaseBucketURIs() throws URISyntaxException {
        Assert.assertEquals((Collection)MemcachedNodesManager.createFor((String)"http://10.10.0.1:8091/pools", null, null, (MemcachedNodesManager.StorageClientCallback)this._mcc).getCouchbaseBucketURIs(), Arrays.asList(new URI("http://10.10.0.1:8091/pools")));
        Assert.assertEquals((Collection)MemcachedNodesManager.createFor((String)"http://10.10.0.1:8091/pools,http://10.10.0.2:8091/pools", null, null, (MemcachedNodesManager.StorageClientCallback)this._mcc).getCouchbaseBucketURIs(), Arrays.asList(new URI("http://10.10.0.1:8091/pools"), new URI("http://10.10.0.2:8091/pools")));
    }

    @Test
    public void testChangeSessionIdForTomcatFailover() {
        Assert.assertEquals((String)MemcachedNodesManager.createFor((String)"localhost:11211", null, null, (MemcachedNodesManager.StorageClientCallback)this._mcc).changeSessionIdForTomcatFailover(MemcachedNodesManagerTest.sessionId("123", null, null), null), (String)MemcachedNodesManagerTest.sessionId("123", null, null));
        Assert.assertEquals((String)MemcachedNodesManager.createFor((String)"localhost:11211", null, null, (MemcachedNodesManager.StorageClientCallback)this._mcc).changeSessionIdForTomcatFailover(MemcachedNodesManagerTest.sessionId("123", null, "tc1"), "tc2"), (String)MemcachedNodesManagerTest.sessionId("123", null, "tc2"));
        Assert.assertEquals((String)MemcachedNodesManager.createFor((String)"n1:localhost:11211,n2:localhost:11212", null, null, (MemcachedNodesManager.StorageClientCallback)this._mcc).changeSessionIdForTomcatFailover(MemcachedNodesManagerTest.sessionId("123", "n1", null), null), (String)MemcachedNodesManagerTest.sessionId("123", "n1", null));
        Assert.assertEquals((String)MemcachedNodesManager.createFor((String)"n1:localhost:11211,n2:localhost:11212", null, null, (MemcachedNodesManager.StorageClientCallback)this._mcc).changeSessionIdForTomcatFailover(MemcachedNodesManagerTest.sessionId("123", "n1", null), "tc2"), (String)MemcachedNodesManagerTest.sessionId("123", "n1", "tc2"));
        Assert.assertEquals((String)MemcachedNodesManager.createFor((String)"n1:localhost:11211,n2:localhost:11212", null, null, (MemcachedNodesManager.StorageClientCallback)this._mcc).changeSessionIdForTomcatFailover(MemcachedNodesManagerTest.sessionId("123", "n1", "tc1"), "tc2"), (String)MemcachedNodesManagerTest.sessionId("123", "n1", "tc2"));
        Assert.assertEquals((String)MemcachedNodesManager.createFor((String)"n1:localhost:11211,n2:localhost:11212", (String)"n2", null, (MemcachedNodesManager.StorageClientCallback)this._mcc).changeSessionIdForTomcatFailover(MemcachedNodesManagerTest.sessionId("123", "n1", null), null), (String)MemcachedNodesManagerTest.sessionId("123", "n1", null));
        Assert.assertEquals((String)MemcachedNodesManager.createFor((String)"n1:localhost:11211,n2:localhost:11212", (String)"n2", null, (MemcachedNodesManager.StorageClientCallback)this._mcc).changeSessionIdForTomcatFailover(MemcachedNodesManagerTest.sessionId("123", "n1", null), "tc2"), (String)MemcachedNodesManagerTest.sessionId("123", "n1", "tc2"));
        Assert.assertEquals((String)MemcachedNodesManager.createFor((String)"n1:localhost:11211,n2:localhost:11212", (String)"n2", null, (MemcachedNodesManager.StorageClientCallback)this._mcc).changeSessionIdForTomcatFailover(MemcachedNodesManagerTest.sessionId("123", "n1", "tc1"), "tc2"), (String)MemcachedNodesManagerTest.sessionId("123", "n1", "tc2"));
        Assert.assertEquals((String)MemcachedNodesManager.createFor((String)"n1:localhost:11211,n2:localhost:11212", (String)"n1", null, (MemcachedNodesManager.StorageClientCallback)this._mcc).changeSessionIdForTomcatFailover(MemcachedNodesManagerTest.sessionId("123", "n1", null), null), (String)MemcachedNodesManagerTest.sessionId("123", "n2", null));
        Assert.assertEquals((String)MemcachedNodesManager.createFor((String)"n1:localhost:11211,n2:localhost:11212", (String)"n1", null, (MemcachedNodesManager.StorageClientCallback)this._mcc).changeSessionIdForTomcatFailover(MemcachedNodesManagerTest.sessionId("123", "n1", null), "tc2"), (String)MemcachedNodesManagerTest.sessionId("123", "n2", "tc2"));
        Assert.assertEquals((String)MemcachedNodesManager.createFor((String)"n1:localhost:11211,n2:localhost:11212", (String)"n1", null, (MemcachedNodesManager.StorageClientCallback)this._mcc).changeSessionIdForTomcatFailover(MemcachedNodesManagerTest.sessionId("123", "n1", "tc1"), "tc2"), (String)MemcachedNodesManagerTest.sessionId("123", "n2", "tc2"));
    }

    private static String sessionId(String plainId, String memcachedId, String jvmRoute) {
        SessionIdFormat sessionIdFormat = new SessionIdFormat();
        String withMemcachedId = sessionIdFormat.createSessionId(plainId, memcachedId);
        return jvmRoute != null ? sessionIdFormat.changeJvmRoute(withMemcachedId, jvmRoute) : withMemcachedId;
    }
}

