/*
 * Decompiled with CFR 0.152.
 */
package de.javakaffee.web.msm;

import de.javakaffee.web.msm.MemcachedBackupSession;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import org.testng.Assert;
import org.testng.annotations.AfterMethod;
import org.testng.annotations.BeforeMethod;
import org.testng.annotations.Test;

public class MemcachedBackupSessionTest {
    private MemcachedBackupSession cut;
    private ExecutorService executor;
    private ExecutorService alternateExecutor;

    @BeforeMethod
    public void beforeMethod() {
        this.cut = new MemcachedBackupSession();
        this.executor = Executors.newCachedThreadPool();
        this.alternateExecutor = Executors.newCachedThreadPool();
    }

    @AfterMethod
    public void afterMethod() {
        this.executor.shutdown();
        this.alternateExecutor.shutdown();
    }

    @Test
    public void testRefCount() throws InterruptedException, ExecutionException {
        Assert.assertEquals((int)this.cut.getRefCount(), (int)0);
        this.cut.registerReference();
        Assert.assertEquals((int)this.cut.getRefCount(), (int)1);
        Assert.assertEquals((int)this.cut.getRefCount(), (int)1);
        this.cut.releaseReference();
        Assert.assertEquals((int)this.cut.getRefCount(), (int)0);
        Runnable registerReference = new Runnable(){

            @Override
            public void run() {
                MemcachedBackupSessionTest.this.cut.registerReference();
            }
        };
        this.executor.submit(registerReference).get();
        Assert.assertEquals((int)this.cut.getRefCount(), (int)1);
        this.alternateExecutor.submit(registerReference).get();
        Assert.assertEquals((int)this.cut.getRefCount(), (int)2);
        this.cut.releaseReference();
        Assert.assertEquals((int)this.cut.getRefCount(), (int)2);
    }
}

