/*
 * Decompiled with CFR 0.152.
 */
package de.javakaffee.web.msm.integration;

import de.javakaffee.web.msm.JavaSerializationTranscoderFactory;
import de.javakaffee.web.msm.LockingStrategy;
import de.javakaffee.web.msm.MemcachedSessionService;
import de.javakaffee.web.msm.integration.TestUtils;
import javax.annotation.Nonnull;
import org.apache.catalina.Context;
import org.apache.catalina.Engine;
import org.apache.catalina.Role;
import org.apache.catalina.User;
import org.apache.catalina.UserDatabase;
import org.apache.catalina.users.MemoryUserDatabase;

public abstract class TomcatBuilder<T> {
    public static final String CONTEXT_PATH = "";
    protected static final String DEFAULT_HOST = "localhost";
    protected static final String DEFAULT_TRANSCODER_FACTORY = JavaSerializationTranscoderFactory.class.getName();
    protected static final String USER_DATABASE = "UserDatabase";
    protected static final String PASSWORD = "secret";
    protected static final String USER_NAME = "testuser";
    protected static final String ROLE_NAME = "test";
    public static final String STICKYNESS_PROVIDER = "stickynessProvider";
    public static final String BOOLEAN_PROVIDER = "booleanProvider";
    protected int port;
    protected int sessionTimeout = 1;
    protected boolean cookies = true;
    protected String jvmRoute = null;
    protected TestUtils.LoginType loginType = null;
    protected String memcachedNodes;
    protected String failoverNodes;
    protected boolean enabled = true;
    protected boolean sticky = true;
    protected LockingStrategy.LockingMode lockingMode;
    protected String memcachedProtocol = "text";
    protected String username = null;
    protected String transcoderFactoryClassName = JavaSerializationTranscoderFactory.class.getName();
    protected String storageKeyPrefix;

    public TomcatBuilder<T> port(int port) {
        this.port = port;
        return this;
    }

    public TomcatBuilder<T> sessionTimeout(int sessionTimeout) {
        this.sessionTimeout = sessionTimeout;
        return this;
    }

    public TomcatBuilder<T> cookies(boolean cookies) {
        this.cookies = cookies;
        return this;
    }

    public TomcatBuilder<T> memcachedNodes(String memcachedNodes) {
        this.memcachedNodes = memcachedNodes;
        return this;
    }

    public TomcatBuilder<T> failoverNodes(String failoverNodes) {
        this.failoverNodes = failoverNodes;
        return this;
    }

    public TomcatBuilder<T> storageKeyPrefix(String storageKeyPrefix) {
        this.storageKeyPrefix = storageKeyPrefix;
        return this;
    }

    public TomcatBuilder<T> enabled(boolean enabled) {
        this.enabled = enabled;
        return this;
    }

    public TomcatBuilder<T> sticky(boolean sticky) {
        this.sticky = sticky;
        return this;
    }

    public TomcatBuilder<T> lockingMode(LockingStrategy.LockingMode lockingMode) {
        this.lockingMode = lockingMode;
        return this;
    }

    public TomcatBuilder<T> memcachedProtocol(String memcachedProtocol) {
        this.memcachedProtocol = memcachedProtocol;
        return this;
    }

    public TomcatBuilder<T> username(String memcachedUsername) {
        this.username = memcachedUsername;
        return this;
    }

    public TomcatBuilder<T> jvmRoute(String jvmRoute) {
        this.jvmRoute = jvmRoute;
        return this;
    }

    public TomcatBuilder<T> loginType(TestUtils.LoginType loginType) {
        this.loginType = loginType;
        return this;
    }

    public TomcatBuilder<T> transcoderFactoryClassName(String transcoderFactoryClassName) {
        this.transcoderFactoryClassName = transcoderFactoryClassName;
        return this;
    }

    public abstract TomcatBuilder<T> buildAndStart() throws Exception;

    public abstract void stop() throws Exception;

    public abstract Context getContext();

    public abstract MemcachedSessionService.SessionManager getManager();

    public abstract MemcachedSessionService getService();

    public abstract Engine getEngine();

    public abstract void setChangeSessionIdOnAuth(boolean var1);

    protected UserDatabase createUserDatabase() {
        MemoryUserDatabase userDatabase = new MemoryUserDatabase();
        Role role = userDatabase.createRole(ROLE_NAME, "the role for unit tests");
        User user = userDatabase.createUser(USER_NAME, PASSWORD, "the user for unit tests");
        user.addRole(role);
        return userDatabase;
    }

    @Nonnull
    protected abstract MemcachedSessionService.SessionManager createSessionManager();
}

