/*
 * Decompiled with CFR 0.152.
 */
package de.javakaffee.web.msm.integration;

import com.thimbleware.jmemcached.Key;
import com.thimbleware.jmemcached.MemCacheDaemon;
import de.javakaffee.web.msm.LockingStrategy;
import de.javakaffee.web.msm.MemcachedNodesManager;
import de.javakaffee.web.msm.MemcachedSessionService;
import de.javakaffee.web.msm.NodeIdList;
import de.javakaffee.web.msm.SessionIdFormat;
import de.javakaffee.web.msm.Statistics;
import de.javakaffee.web.msm.SuffixLocatorConnectionFactory;
import de.javakaffee.web.msm.integration.TestUtils;
import de.javakaffee.web.msm.integration.TomcatBuilder;
import edu.umd.cs.findbugs.annotations.SuppressWarnings;
import java.io.IOException;
import java.net.InetSocketAddress;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import java.util.regex.Pattern;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.spy.memcached.ConnectionFactory;
import net.spy.memcached.MemcachedClient;
import org.apache.http.HttpException;
import org.apache.http.auth.Credentials;
import org.apache.http.auth.UsernamePasswordCredentials;
import org.apache.http.conn.ClientConnectionManager;
import org.apache.http.conn.scheme.PlainSocketFactory;
import org.apache.http.conn.scheme.Scheme;
import org.apache.http.conn.scheme.SchemeRegistry;
import org.apache.http.conn.scheme.SchemeSocketFactory;
import org.apache.http.impl.client.DefaultHttpClient;
import org.apache.http.impl.conn.tsccm.ThreadSafeClientConnManager;
import org.apache.juli.logging.Log;
import org.apache.juli.logging.LogFactory;
import org.testng.Assert;
import org.testng.annotations.AfterMethod;
import org.testng.annotations.BeforeMethod;
import org.testng.annotations.DataProvider;
import org.testng.annotations.Test;

public abstract class NonStickySessionsIntegrationTest {
    private static final Log LOG = LogFactory.getLog(NonStickySessionsIntegrationTest.class);
    private MemCacheDaemon<?> _daemon1;
    private MemCacheDaemon<?> _daemon2;
    private MemCacheDaemon<?> _daemon3;
    private MemcachedClient _client;
    private final MemcachedNodesManager.MemcachedClientCallback _memcachedClientCallback = new MemcachedNodesManager.MemcachedClientCallback(){

        public Object get(String key) {
            return NonStickySessionsIntegrationTest.this._client.get(key);
        }
    };
    private TomcatBuilder<?> _tomcat1;
    private TomcatBuilder<?> _tomcat2;
    private static final int TC_PORT_1 = 18888;
    private static final int TC_PORT_2 = 18889;
    private static final String NODE_ID_1 = "n1";
    private static final String NODE_ID_2 = "n2";
    private static final String NODE_ID_3 = "n3";
    private static final int MEMCACHED_PORT_1 = 21211;
    private static final int MEMCACHED_PORT_2 = 21212;
    private static final int MEMCACHED_PORT_3 = 21213;
    private static final String MEMCACHED_NODES = "n1:localhost:21211,n2:localhost:21212";
    private DefaultHttpClient _httpClient;
    private ExecutorService _executor;

    @BeforeMethod
    public void setUp() throws Throwable {
        InetSocketAddress address1 = new InetSocketAddress("localhost", 21211);
        this._daemon1 = TestUtils.createDaemon(address1);
        this._daemon1.start();
        InetSocketAddress address2 = new InetSocketAddress("localhost", 21212);
        this._daemon2 = TestUtils.createDaemon(address2);
        this._daemon2.start();
        try {
            this._tomcat1 = this.startTomcat(18888);
            this._tomcat2 = this.startTomcat(18889);
        }
        catch (Throwable e) {
            LOG.error((Object)"could not start tomcat.", e);
            throw e;
        }
        MemcachedNodesManager nodesManager = MemcachedNodesManager.createFor((String)MEMCACHED_NODES, null, null, (MemcachedNodesManager.MemcachedClientCallback)this._memcachedClientCallback);
        this._client = new MemcachedClient((ConnectionFactory)new SuffixLocatorConnectionFactory(nodesManager, nodesManager.getSessionIdFormat(), Statistics.create(), 1000L, 1000L), Arrays.asList(address1, address2));
        SchemeRegistry schemeRegistry = new SchemeRegistry();
        schemeRegistry.register(new Scheme("http", 80, (SchemeSocketFactory)PlainSocketFactory.getSocketFactory()));
        this._httpClient = new DefaultHttpClient((ClientConnectionManager)new ThreadSafeClientConnManager(schemeRegistry));
        this._executor = Executors.newCachedThreadPool();
    }

    abstract TestUtils<?> getTestUtils();

    private TomcatBuilder<?> startTomcat(int port) throws Exception {
        return this.startTomcat(port, MEMCACHED_NODES, null);
    }

    private TomcatBuilder<?> startTomcat(int port, String memcachedNodes, LockingStrategy.LockingMode lockingMode) throws Exception {
        return ((TomcatBuilder)this.getTestUtils().tomcatBuilder()).port(port).sessionTimeout(5).memcachedNodes(memcachedNodes).sticky(false).lockingMode(lockingMode).storageKeyPrefix(null).buildAndStart();
    }

    @AfterMethod
    public void tearDown() throws Exception {
        this._client.shutdown();
        this._daemon1.stop();
        this._daemon2.stop();
        if (this._daemon3 != null && this._daemon3.isRunning()) {
            this._daemon3.stop();
        }
        this._tomcat1.stop();
        this._tomcat2.stop();
        this._httpClient.getConnectionManager().shutdown();
        this._executor.shutdownNow();
    }

    @DataProvider
    public Object[][] lockingModes() {
        return new Object[][]{{LockingStrategy.LockingMode.ALL, null}, {LockingStrategy.LockingMode.AUTO, null}, {LockingStrategy.LockingMode.URI_PATTERN, Pattern.compile(".*")}, {LockingStrategy.LockingMode.NONE, null}};
    }

    @DataProvider
    public Object[][] lockingModesWithSessionLocking() {
        return new Object[][]{{LockingStrategy.LockingMode.ALL, null}, {LockingStrategy.LockingMode.AUTO, null}, {LockingStrategy.LockingMode.URI_PATTERN, Pattern.compile(".*")}};
    }

    @Test(enabled=true, dataProvider="lockingModesWithSessionLocking")
    @SuppressWarnings(value={"NP_NULL_ON_SOME_PATH_FROM_RETURN_VALUE"})
    public void testLoadBackupSessionShouldWorkWithInfiniteSessionTimeoutIssue120(@Nonnull LockingStrategy.LockingMode lockingMode, @Nullable Pattern uriPattern) throws IOException, InterruptedException, HttpException, ExecutionException {
        this._tomcat1.getManager().setMaxInactiveInterval(-1);
        this.setLockingMode(lockingMode, uriPattern);
        String sessionId = TestUtils.post(this._httpClient, 18888, null, "k1", "v1").getSessionId();
        Assert.assertNotNull((Object)sessionId);
        Thread.sleep(200L);
        TestUtils.Response response = TestUtils.get(this._httpClient, 18888, sessionId);
        Assert.assertEquals((String)response.getSessionId(), (String)sessionId);
        Assert.assertEquals((String)response.get("k1"), (String)"v1");
        SessionIdFormat fmt = new SessionIdFormat();
        String nodeId = fmt.extractMemcachedId(sessionId);
        MemCacheDaemon<?> primary = NODE_ID_1.equals(nodeId) ? this._daemon1 : this._daemon2;
        primary.stop();
        Thread.sleep(200L);
        response = TestUtils.get(this._httpClient, 18888, sessionId);
        Assert.assertEquals((String)fmt.createNewSessionId(response.getSessionId(), nodeId), (String)sessionId);
        Assert.assertEquals((String)response.get("k1"), (String)"v1");
    }

    @Test(enabled=true, dataProvider="lockingModesWithSessionLocking")
    @SuppressWarnings(value={"NP_NULL_ON_SOME_PATH_FROM_RETURN_VALUE"})
    public void testLoadBackupSessionShouldWorkWithHighSessionTimeoutIssue104(@Nonnull LockingStrategy.LockingMode lockingMode, @Nullable Pattern uriPattern) throws IOException, InterruptedException, HttpException, ExecutionException {
        this._tomcat1.getManager().setMaxInactiveInterval(1296001);
        this.setLockingMode(lockingMode, uriPattern);
        String sessionId = TestUtils.post(this._httpClient, 18888, null, "k1", "v1").getSessionId();
        Assert.assertNotNull((Object)sessionId);
        Thread.sleep(200L);
        TestUtils.Response response = TestUtils.get(this._httpClient, 18888, sessionId);
        Assert.assertEquals((String)response.getSessionId(), (String)sessionId);
        Assert.assertEquals((String)response.get("k1"), (String)"v1");
        SessionIdFormat fmt = new SessionIdFormat();
        String nodeId = fmt.extractMemcachedId(sessionId);
        MemCacheDaemon<?> primary = NODE_ID_1.equals(nodeId) ? this._daemon1 : this._daemon2;
        primary.stop();
        Thread.sleep(200L);
        response = TestUtils.get(this._httpClient, 18888, sessionId);
        Assert.assertEquals((String)fmt.createNewSessionId(response.getSessionId(), nodeId), (String)sessionId);
        Assert.assertEquals((String)response.get("k1"), (String)"v1");
    }

    @Test(enabled=true, dataProvider="lockingModesWithSessionLocking")
    public void testSessionLockingSupportedWithSingleNodeSetup(@Nonnull LockingStrategy.LockingMode lockingMode, @Nullable Pattern uriPattern) throws IOException, InterruptedException, HttpException, ExecutionException {
        this._tomcat1.getManager().setMemcachedNodes("localhost:21211");
        this._tomcat1.getManager().setLockingMode(lockingMode, uriPattern, false);
        String sessionId = TestUtils.post(this._httpClient, 18888, null, "k1", "v1").getSessionId();
        Assert.assertNotNull((Object)sessionId);
        TestUtils.Response response = TestUtils.get(this._httpClient, 18888, sessionId);
        Assert.assertEquals((String)response.getSessionId(), (String)sessionId);
        Assert.assertEquals((String)response.get("k1"), (String)"v1");
        TestUtils.post(this._httpClient, 18888, sessionId, "k2", "v2");
        response = TestUtils.get(this._httpClient, 18888, sessionId);
        Assert.assertEquals((String)response.getSessionId(), (String)sessionId);
        Assert.assertEquals((String)response.get("k1"), (String)"v1");
        Assert.assertEquals((String)response.get("k2"), (String)"v2");
    }

    @Test(enabled=true, dataProvider="lockingModesWithSessionLocking")
    public void testParallelRequestsToSameTomcatInstanceIssue111(@Nonnull LockingStrategy.LockingMode lockingMode, @Nullable Pattern uriPattern) throws IOException, InterruptedException, HttpException, ExecutionException {
        this.setLockingMode(lockingMode, uriPattern);
        final String sessionId = TestUtils.post(this._httpClient, 18888, null, "k1", "v1").getSessionId();
        Assert.assertNotNull((Object)sessionId);
        Future<TestUtils.Response> response2 = this._executor.submit(new Callable<TestUtils.Response>(){

            @Override
            public TestUtils.Response call() throws Exception {
                return TestUtils.post(NonStickySessionsIntegrationTest.this._httpClient, 18888, "/sleep", sessionId, TestUtils.asMap("millies", "500", "k2", "v2"));
            }
        });
        Thread.sleep(200L);
        TestUtils.post(this._httpClient, 18888, sessionId, "k3", "v3");
        TestUtils.Response finalResponse = TestUtils.get(this._httpClient, 18889, sessionId);
        Assert.assertEquals((String)finalResponse.getSessionId(), (String)sessionId);
        Assert.assertEquals((String)response2.get().getSessionId(), (String)sessionId);
        Assert.assertEquals((String)finalResponse.get("k1"), (String)"v1");
        Assert.assertEquals((String)finalResponse.get("k2"), (String)"v2");
        Assert.assertEquals((String)finalResponse.get("k3"), (String)"v3");
    }

    @Test(enabled=true)
    public void testNoStaleSessionsWithNonStickySessions() throws IOException, InterruptedException, HttpException {
        this._tomcat1.getManager().setMaxInactiveInterval(1);
        this._tomcat2.getManager().setMaxInactiveInterval(1);
        String key = "foo";
        String value1 = "bar";
        String sessionId1 = TestUtils.post(this._httpClient, 18888, null, "foo", "bar").getSessionId();
        Assert.assertNotNull((Object)sessionId1);
        Object session = this._client.get(sessionId1);
        Assert.assertNotNull((Object)session, (String)("Session not found in memcached: " + sessionId1));
        String value2 = "baz";
        String sessionId2 = TestUtils.post(this._httpClient, 18889, sessionId1, "foo", "baz").getSessionId();
        Assert.assertEquals((String)sessionId2, (String)sessionId1);
        TestUtils.Response response = TestUtils.get(this._httpClient, 18888, sessionId1);
        Assert.assertEquals((String)response.getSessionId(), (String)sessionId1);
        Assert.assertEquals((String)response.get("foo"), (String)"baz");
    }

    private void setLockingMode(@Nonnull LockingStrategy.LockingMode lockingMode, @Nullable Pattern uriPattern) {
        this._tomcat1.getManager().setLockingMode(lockingMode, uriPattern, true);
        this._tomcat2.getManager().setLockingMode(lockingMode, uriPattern, true);
    }

    @Test(enabled=true, dataProvider="lockingModesWithSessionLocking")
    public void testParallelRequestsDontCauseDataLoss(@Nonnull LockingStrategy.LockingMode lockingMode, @Nullable Pattern uriPattern) throws IOException, InterruptedException, HttpException, ExecutionException {
        this.setLockingMode(lockingMode, uriPattern);
        String key1 = "k1";
        String value1 = "v1";
        final String sessionId = TestUtils.post(this._httpClient, 18888, null, "k1", "v1").getSessionId();
        Assert.assertNotNull((Object)sessionId);
        String key2 = "k2";
        String value2 = "v2";
        LOG.info((Object)"Start request 1");
        Future<TestUtils.Response> response1 = this._executor.submit(new Callable<TestUtils.Response>(){

            @Override
            public TestUtils.Response call() throws Exception {
                return TestUtils.post(NonStickySessionsIntegrationTest.this._httpClient, 18888, "/sleep", sessionId, TestUtils.asMap("millies", "500", "k2", "v2"));
            }
        });
        Thread.sleep(100L);
        String key3 = "k3";
        String value3 = "v3";
        LOG.info((Object)"Start request 2");
        TestUtils.Response response2 = TestUtils.post(this._httpClient, 18889, sessionId, "k3", "v3");
        Assert.assertEquals((String)response1.get().getSessionId(), (String)sessionId);
        Assert.assertEquals((String)response2.getSessionId(), (String)sessionId);
        TestUtils.Response response3 = TestUtils.get(this._httpClient, 18888, sessionId);
        Assert.assertEquals((String)response3.getSessionId(), (String)sessionId);
        LOG.info((Object)"Got response for request 2");
        Assert.assertEquals((String)response3.get("k1"), (String)"v1");
        Assert.assertEquals((String)response3.get("k2"), (String)"v2");
        Assert.assertEquals((String)response3.get("k3"), (String)"v3");
    }

    @Test(enabled=true)
    public void testReadOnlyRequestsDontLockSessionForAutoLocking() throws IOException, InterruptedException, HttpException, ExecutionException {
        this.setLockingMode(LockingStrategy.LockingMode.AUTO, null);
        String key1 = "k1";
        String value1 = "v1";
        final String sessionId = TestUtils.post(this._httpClient, 18888, null, "k1", "v1").getSessionId();
        Assert.assertNotNull((Object)sessionId);
        String path = "/mypath";
        Map<String, String> params = TestUtils.asMap("foo", "bar");
        TestUtils.Response response0 = TestUtils.get(this._httpClient, 18888, "/mypath", sessionId, params);
        Assert.assertEquals((String)response0.getSessionId(), (String)sessionId);
        long timeToWaitInMillis = 500L;
        final Map<String, String> paramsWait = TestUtils.asMap("millies", String.valueOf(500L));
        TestUtils.Response response1 = TestUtils.get(this._httpClient, 18888, "/sleep", sessionId, paramsWait);
        Assert.assertEquals((String)response1.getSessionId(), (String)sessionId);
        long start = System.currentTimeMillis();
        Future<TestUtils.Response> response2 = this._executor.submit(new Callable<TestUtils.Response>(){

            @Override
            public TestUtils.Response call() throws Exception {
                return TestUtils.get(NonStickySessionsIntegrationTest.this._httpClient, 18888, "/sleep", sessionId, paramsWait);
            }
        });
        Future<TestUtils.Response> response3 = this._executor.submit(new Callable<TestUtils.Response>(){

            @Override
            public TestUtils.Response call() throws Exception {
                return TestUtils.get(NonStickySessionsIntegrationTest.this._httpClient, 18888, "/sleep", sessionId, paramsWait);
            }
        });
        response2.get();
        response3.get();
        Assert.assertTrue((System.currentTimeMillis() - start < 1000L ? 1 : 0) != 0, (String)"The time for both requests should be less than 2 * the wait time if they don't block each other.");
        Assert.assertEquals((String)response2.get().getSessionId(), (String)sessionId);
        Assert.assertEquals((String)response3.get().getSessionId(), (String)sessionId);
        Future<TestUtils.Response> response4 = this._executor.submit(new Callable<TestUtils.Response>(){

            @Override
            public TestUtils.Response call() throws Exception {
                return TestUtils.post(NonStickySessionsIntegrationTest.this._httpClient, 18888, "/sleep", sessionId, TestUtils.asMap("millies", "500", "foo", "bar"));
            }
        });
        Thread.sleep(50L);
        TestUtils.Response response5 = TestUtils.get(this._httpClient, 18888, "/mypath", sessionId, params);
        Assert.assertEquals((String)response5.getSessionId(), (String)sessionId);
        Assert.assertFalse((boolean)response4.isDone(), (String)"The readonly request should return before the long, session locking one");
        Assert.assertEquals((String)response4.get().getSessionId(), (String)sessionId);
    }

    @Test(enabled=true)
    public void testRequestsDontLockSessionForNotMatchingUriPattern() throws IOException, InterruptedException, HttpException, ExecutionException {
        String pathToLock = "/locksession";
        this.setLockingMode(LockingStrategy.LockingMode.URI_PATTERN, Pattern.compile("/locksession.*"));
        final String sessionId = TestUtils.get(this._httpClient, 18888, null).getSessionId();
        Assert.assertNotNull((Object)sessionId);
        long timeToWaitInMillis = 500L;
        final Map<String, String> paramsWait = TestUtils.asMap("sleep", "true", "millies", String.valueOf(500L));
        long start = System.currentTimeMillis();
        Future<TestUtils.Response> response2 = this._executor.submit(new Callable<TestUtils.Response>(){

            @Override
            public TestUtils.Response call() throws Exception {
                return TestUtils.get(NonStickySessionsIntegrationTest.this._httpClient, 18888, "/pathNotMatchingLockUriPattern", sessionId, paramsWait);
            }
        });
        Future<TestUtils.Response> response3 = this._executor.submit(new Callable<TestUtils.Response>(){

            @Override
            public TestUtils.Response call() throws Exception {
                return TestUtils.get(NonStickySessionsIntegrationTest.this._httpClient, 18888, "/locksession", sessionId, paramsWait);
            }
        });
        response2.get();
        response3.get();
        Assert.assertTrue((System.currentTimeMillis() - start < 1000L ? 1 : 0) != 0, (String)"The time for both requests should be less than 2 * the wait time if they don't block each other.");
        Assert.assertEquals((String)response2.get().getSessionId(), (String)sessionId);
        Assert.assertEquals((String)response3.get().getSessionId(), (String)sessionId);
        Future<TestUtils.Response> response4 = this._executor.submit(new Callable<TestUtils.Response>(){

            @Override
            public TestUtils.Response call() throws Exception {
                return TestUtils.get(NonStickySessionsIntegrationTest.this._httpClient, 18888, "/locksession", sessionId, paramsWait);
            }
        });
        Thread.sleep(50L);
        TestUtils.Response response5 = TestUtils.get(this._httpClient, 18888, "/pathNotMatchingLockUriPattern", sessionId);
        Assert.assertEquals((String)response5.getSessionId(), (String)sessionId);
        Assert.assertFalse((boolean)response4.isDone(), (String)"The non locking request should return before the long, session locking one");
        Assert.assertEquals((String)response4.get().getSessionId(), (String)sessionId);
    }

    @Test(enabled=true, dataProvider="lockingModes")
    public void testNonStickySessionIsValidEvenWhenAccessedReadonly(@Nonnull LockingStrategy.LockingMode lockingMode, @Nullable Pattern uriPattern) throws IOException, InterruptedException, HttpException, ExecutionException {
        this._tomcat1.getManager().setMaxInactiveInterval(1);
        this._tomcat1.getManager().setLockingMode(lockingMode, uriPattern, true);
        String sessionId = TestUtils.get(this._httpClient, 18888, null).getSessionId();
        Assert.assertNotNull((Object)sessionId);
        Assert.assertEquals((String)TestUtils.get(this._httpClient, 18888, sessionId).getSessionId(), (String)sessionId);
        Thread.sleep(500L);
        Assert.assertEquals((String)TestUtils.get(this._httpClient, 18888, sessionId).getSessionId(), (String)sessionId);
        Thread.sleep(500L);
        Assert.assertEquals((String)TestUtils.get(this._httpClient, 18888, sessionId).getSessionId(), (String)sessionId);
    }

    @Test(enabled=true, dataProvider="sessionTrackingModesProvider")
    public void testNonStickySessionIsValidForDifferentSessionTrackingModes(@Nonnull TestUtils.SessionTrackingMode sessionTrackingMode) throws IOException, InterruptedException, HttpException, ExecutionException {
        this._tomcat1.getManager().setMaxInactiveInterval(1);
        this._tomcat1.getManager().setLockingMode(LockingStrategy.LockingMode.ALL, null, true);
        String sessionId = TestUtils.get(this._httpClient, 18888, null).getSessionId();
        Assert.assertNotNull((Object)sessionId);
        TestUtils.Response response = TestUtils.get(this._httpClient, 18888, "/requestedSessionInfo", sessionId, sessionTrackingMode, null, null);
        Assert.assertEquals((String)response.getSessionId(), (String)sessionId);
        Assert.assertEquals((String)response.get("requestedSessionId"), (String)sessionId);
        Assert.assertEquals((boolean)Boolean.parseBoolean(response.get("isRequestedSessionIdValid")), (boolean)true);
        Thread.sleep(100L);
        response = TestUtils.get(this._httpClient, 18888, "/requestedSessionInfo", sessionId, sessionTrackingMode, null, null);
        Assert.assertEquals((String)response.getSessionId(), (String)sessionId);
        Assert.assertEquals((String)response.get("requestedSessionId"), (String)sessionId);
        Assert.assertEquals((boolean)Boolean.parseBoolean(response.get("isRequestedSessionIdValid")), (boolean)true);
    }

    @Test(enabled=true)
    @SuppressWarnings(value={"NP_NULL_ON_SOME_PATH_FROM_RETURN_VALUE"})
    public void testNonStickySessionIsStoredInSecondaryMemcachedForBackup() throws IOException, InterruptedException, HttpException {
        this._tomcat1.getManager().setMaxInactiveInterval(1);
        this._tomcat2.getManager().setMaxInactiveInterval(1);
        String sessionId1 = TestUtils.post(this._httpClient, 18888, null, "foo", "bar").getSessionId();
        Assert.assertNotNull((Object)sessionId1);
        this.waitForMemcachedClient(100L);
        SessionIdFormat fmt = new SessionIdFormat();
        String nodeId = fmt.extractMemcachedId(sessionId1);
        MemCacheDaemon<?> primary = nodeId.equals(NODE_ID_1) ? this._daemon1 : this._daemon2;
        MemCacheDaemon<?> secondary = nodeId.equals(NODE_ID_1) ? this._daemon2 : this._daemon1;
        Assert.assertNotNull((Object)primary.getCache().get(new Key[]{TestUtils.key(sessionId1)})[0], (String)sessionId1);
        Assert.assertNotNull((Object)primary.getCache().get(new Key[]{TestUtils.key(fmt.createValidityInfoKeyName(sessionId1))})[0], (String)fmt.createValidityInfoKeyName(sessionId1));
        Thread.sleep(500L);
        Assert.assertNotNull((Object)secondary.getCache().get(new Key[]{TestUtils.key(fmt.createBackupKey(sessionId1))})[0]);
        Assert.assertNotNull((Object)secondary.getCache().get(new Key[]{TestUtils.key(fmt.createBackupKey(fmt.createValidityInfoKeyName(sessionId1)))})[0]);
    }

    @Test(enabled=true)
    @SuppressWarnings(value={"NP_NULL_ON_SOME_PATH_FROM_RETURN_VALUE"})
    public void testNonStickySessionSecondaryBackupFailover() throws IOException, InterruptedException, HttpException {
        InetSocketAddress address3 = new InetSocketAddress("localhost", 21213);
        this._daemon3 = TestUtils.createDaemon(address3);
        this._daemon3.start();
        String memcachedNodes = "n1:localhost:21211,n2:localhost:21212,n3:localhost:21213";
        MemcachedSessionService.SessionManager manager = this._tomcat1.getManager();
        manager.setMaxInactiveInterval(5);
        manager.setMemcachedNodes("n1:localhost:21211,n2:localhost:21212,n3:localhost:21213");
        manager.getMemcachedSessionService().setSessionBackupAsync(false);
        TestUtils.waitForReconnect(manager.getMemcachedSessionService().getMemcached(), 3, 1000L);
        NodeIdList nodeIdList = NodeIdList.create((String[])new String[]{NODE_ID_1, NODE_ID_2, NODE_ID_3});
        HashMap memcachedsByNodeId = new HashMap();
        memcachedsByNodeId.put(NODE_ID_1, this._daemon1);
        memcachedsByNodeId.put(NODE_ID_2, this._daemon2);
        memcachedsByNodeId.put(NODE_ID_3, this._daemon3);
        String sessionId1 = TestUtils.post(this._httpClient, 18888, null, "key", "v1").getSessionId();
        Assert.assertNotNull((Object)sessionId1);
        SessionIdFormat fmt = new SessionIdFormat();
        String nodeId = fmt.extractMemcachedId(sessionId1);
        MemCacheDaemon first = (MemCacheDaemon)memcachedsByNodeId.get(nodeId);
        TestUtils.assertNotNullElementWaitingWithProxy(0, 100L, first.getCache()).get(new Key[]{TestUtils.key(sessionId1)});
        TestUtils.assertNotNullElementWaitingWithProxy(0, 100L, first.getCache()).get(new Key[]{TestUtils.key(fmt.createValidityInfoKeyName(sessionId1))});
        MemCacheDaemon second = (MemCacheDaemon)memcachedsByNodeId.get(nodeIdList.getNextNodeId(nodeId));
        TestUtils.assertNotNullElementWaitingWithProxy(0, 4000L, second.getCache()).get(new Key[]{TestUtils.key(fmt.createBackupKey(sessionId1))});
        TestUtils.assertNotNullElementWaitingWithProxy(0, 200L, second.getCache()).get(new Key[]{TestUtils.key(fmt.createBackupKey(fmt.createValidityInfoKeyName(sessionId1)))});
        second.stop();
        Thread.sleep(100L);
        String sessionId2 = TestUtils.post(this._httpClient, 18888, sessionId1, "key", "v2").getSessionId();
        Assert.assertEquals((String)sessionId2, (String)sessionId1);
        MemCacheDaemon third = (MemCacheDaemon)memcachedsByNodeId.get(nodeIdList.getNextNodeId(nodeIdList.getNextNodeId(nodeId)));
        TestUtils.assertNotNullElementWaitingWithProxy(0, 4000L, third.getCache()).get(new Key[]{TestUtils.key(fmt.createBackupKey(sessionId1))});
        TestUtils.assertNotNullElementWaitingWithProxy(0, 200L, third.getCache()).get(new Key[]{TestUtils.key(fmt.createBackupKey(fmt.createValidityInfoKeyName(sessionId1)))});
        first.stop();
        Thread.sleep(100L);
        TestUtils.Response response3 = TestUtils.get(this._httpClient, 18888, sessionId1);
        String sessionId3 = response3.getResponseSessionId();
        Assert.assertNotNull((Object)sessionId3);
        Assert.assertFalse((boolean)sessionId3.equals(sessionId1));
        Assert.assertEquals((String)sessionId3, (String)fmt.createNewSessionId(sessionId1, fmt.extractMemcachedId(sessionId3)));
        Assert.assertEquals((String)response3.get("key"), (String)"v2");
    }

    @Test(enabled=true)
    @SuppressWarnings(value={"NP_NULL_ON_SOME_PATH_FROM_RETURN_VALUE"})
    public void testNonStickySessionSecondaryBackupFailoverForSkippedUpdate() throws IOException, InterruptedException, HttpException {
        InetSocketAddress address3 = new InetSocketAddress("localhost", 21213);
        this._daemon3 = TestUtils.createDaemon(address3);
        this._daemon3.start();
        String memcachedNodes = "n1:localhost:21211,n2:localhost:21212,n3:localhost:21213";
        MemcachedSessionService.SessionManager manager = this._tomcat1.getManager();
        manager.setMaxInactiveInterval(5);
        manager.setMemcachedNodes("n1:localhost:21211,n2:localhost:21212,n3:localhost:21213");
        manager.getMemcachedSessionService().setSessionBackupAsync(false);
        TestUtils.waitForReconnect(manager.getMemcachedSessionService().getMemcached(), 3, 1000L);
        NodeIdList nodeIdList = NodeIdList.create((String[])new String[]{NODE_ID_1, NODE_ID_2, NODE_ID_3});
        HashMap memcachedsByNodeId = new HashMap();
        memcachedsByNodeId.put(NODE_ID_1, this._daemon1);
        memcachedsByNodeId.put(NODE_ID_2, this._daemon2);
        memcachedsByNodeId.put(NODE_ID_3, this._daemon3);
        String sessionId1 = TestUtils.post(this._httpClient, 18888, null, "key", "v1").getSessionId();
        Assert.assertNotNull((Object)sessionId1);
        SessionIdFormat fmt = new SessionIdFormat();
        String nodeId = fmt.extractMemcachedId(sessionId1);
        MemCacheDaemon first = (MemCacheDaemon)memcachedsByNodeId.get(nodeId);
        TestUtils.assertNotNullElementWaitingWithProxy(0, 100L, first.getCache()).get(new Key[]{TestUtils.key(sessionId1)});
        TestUtils.assertNotNullElementWaitingWithProxy(0, 100L, first.getCache()).get(new Key[]{TestUtils.key(fmt.createValidityInfoKeyName(sessionId1))});
        MemCacheDaemon second = (MemCacheDaemon)memcachedsByNodeId.get(nodeIdList.getNextNodeId(nodeId));
        TestUtils.assertNotNullElementWaitingWithProxy(0, 4000L, second.getCache()).get(new Key[]{TestUtils.key(fmt.createBackupKey(sessionId1))});
        TestUtils.assertNotNullElementWaitingWithProxy(0, 200L, second.getCache()).get(new Key[]{TestUtils.key(fmt.createBackupKey(fmt.createValidityInfoKeyName(sessionId1)))});
        second.stop();
        Thread.sleep(100L);
        String sessionId2 = TestUtils.get(this._httpClient, 18888, sessionId1).getSessionId();
        Assert.assertEquals((String)sessionId2, (String)sessionId1);
        MemCacheDaemon third = (MemCacheDaemon)memcachedsByNodeId.get(nodeIdList.getNextNodeId(nodeIdList.getNextNodeId(nodeId)));
        TestUtils.assertNotNullElementWaitingWithProxy(0, 4000L, third.getCache()).get(new Key[]{TestUtils.key(fmt.createBackupKey(sessionId1))});
        TestUtils.assertNotNullElementWaitingWithProxy(0, 200L, third.getCache()).get(new Key[]{TestUtils.key(fmt.createBackupKey(fmt.createValidityInfoKeyName(sessionId1)))});
        first.stop();
        Thread.sleep(100L);
        TestUtils.Response response3 = TestUtils.get(this._httpClient, 18888, sessionId1);
        String sessionId3 = response3.getResponseSessionId();
        Assert.assertNotNull((Object)sessionId3);
        Assert.assertFalse((boolean)sessionId3.equals(sessionId1));
        Assert.assertEquals((String)sessionId3, (String)fmt.createNewSessionId(sessionId1, fmt.extractMemcachedId(sessionId3)));
        Assert.assertEquals((String)response3.get("key"), (String)"v1");
    }

    @Test(enabled=true)
    public void testNoBackupWhenRunningASingleMemcachedOnly() throws IOException, HttpException, InterruptedException {
        this._tomcat1.getManager().setMemcachedNodes("n1:localhost:21211");
        Thread.sleep(500L);
        try {
            String sessionId1 = TestUtils.post(this._httpClient, 18888, null, "foo", "bar").getSessionId();
            Assert.assertNotNull((Object)sessionId1);
            this.waitForMemcachedClient(500L);
            Assert.assertEquals((int)this._daemon1.getCache().getSetCmds(), (int)2);
            Assert.assertEquals((int)this._daemon2.getCache().getSetCmds(), (int)0);
        }
        finally {
            this._tomcat1.getManager().setMemcachedNodes(MEMCACHED_NODES);
        }
    }

    private void waitForMemcachedClient(long millis) {
        try {
            Thread.sleep(millis);
        }
        catch (InterruptedException e) {
            throw new RuntimeException(e);
        }
    }

    @Test(enabled=true)
    public void testSessionNotLoadedForNoSessionAccess() throws IOException, HttpException, InterruptedException {
        this._tomcat1.getManager().setMemcachedNodes("n1:localhost:21211");
        TestUtils.waitForReconnect(this._tomcat1.getService().getMemcached(), 1, 1000L);
        String sessionId1 = TestUtils.post(this._httpClient, 18888, null, "foo", "bar").getSessionId();
        Assert.assertNotNull((Object)sessionId1);
        TestUtils.assertWaitingWithProxy(TestUtils.Predicates.equalTo(2), 1000L, this._daemon1.getCache()).getSetCmds();
        Assert.assertEquals((int)this._daemon1.getCache().getGetHits(), (int)0);
        TestUtils.get(this._httpClient, 18888, "/noSessionAccess", sessionId1);
        TestUtils.assertWaitingWithProxy(TestUtils.Predicates.equalTo(3), 1000L, this._daemon1.getCache()).getSetCmds();
        Assert.assertEquals((int)this._daemon1.getCache().getGetHits(), (int)this.getExpectedHitsForNoSessionAccess());
    }

    protected int getExpectedHitsForNoSessionAccess() {
        return 1;
    }

    @Test(enabled=true)
    public void testIgnoredResourcesWithSessionCookieDontCauseSessionStaleness() throws Exception {
        this._tomcat1.stop();
        this._tomcat2.stop();
        this._tomcat1 = this.startTomcat(18888, "n1:localhost:21211", LockingStrategy.LockingMode.AUTO);
        this._tomcat2 = this.startTomcat(18889, "n1:localhost:21211", LockingStrategy.LockingMode.AUTO);
        TestUtils.Response tc1Response1 = TestUtils.post(this._httpClient, 18888, "/", null, TestUtils.asMap("foo", "bar"));
        String sessionId = tc1Response1.getSessionId();
        Assert.assertNotNull((Object)sessionId);
        Assert.assertEquals((int)this._daemon1.getCache().getGetHits(), (int)0);
        Assert.assertEquals((int)this._daemon1.getCache().getSetCmds(), (int)2);
        TestUtils.Response tc1Response2 = TestUtils.get(this._httpClient, 18888, "/pixel.gif", sessionId);
        Assert.assertNull((Object)tc1Response2.getResponseSessionId());
        Assert.assertEquals((int)this._daemon1.getCache().getGetHits(), (int)0);
        Assert.assertEquals((int)this._daemon1.getCache().getSetCmds(), (int)2);
        TestUtils.Response tc1Response3 = TestUtils.post(this._httpClient, 18888, "/", sessionId, TestUtils.asMap("bar", "baz"));
        Assert.assertEquals((String)tc1Response3.getSessionId(), (String)sessionId);
        Assert.assertNull((Object)tc1Response3.getResponseSessionId());
        TestUtils.Response tc2Response1 = TestUtils.get(this._httpClient, 18889, sessionId);
        Assert.assertEquals((String)tc2Response1.getSessionId(), (String)sessionId);
        Assert.assertEquals((String)tc2Response1.get("id"), (String)sessionId);
        Assert.assertEquals((String)tc2Response1.get("foo"), (String)"bar");
        Assert.assertEquals((String)tc2Response1.get("bar"), (String)"baz");
    }

    @Test(enabled=true)
    public void testBasicAuth() throws Exception {
        this._tomcat1.stop();
        this._tomcat2.stop();
        this._tomcat1 = this.startTomcatWithAuth(18888, LockingStrategy.LockingMode.AUTO);
        this._tomcat2 = this.startTomcatWithAuth(18889, LockingStrategy.LockingMode.AUTO);
        this._tomcat1.setChangeSessionIdOnAuth(false);
        this._tomcat2.setChangeSessionIdOnAuth(false);
        TestUtils.Response tc1Response1 = TestUtils.post(this._httpClient, 18888, "/", null, TestUtils.asMap("foo", "bar"), (Credentials)new UsernamePasswordCredentials("testuser", "secret"), true);
        String sessionId = tc1Response1.getSessionId();
        Assert.assertNotNull((Object)sessionId);
        TestUtils.Response tc2Response1 = TestUtils.get(this._httpClient, 18889, sessionId);
        Assert.assertEquals((String)sessionId, (String)tc2Response1.get("id"));
        Assert.assertEquals((String)tc2Response1.get("foo"), (String)"bar");
    }

    @Test(enabled=true)
    public void testIgnoredResourcesWithFormAuthDontCauseSessionStaleness() throws Exception {
        this._tomcat1.stop();
        this._tomcat2.stop();
        this._tomcat1 = this.startTomcatWithAuth(18888, "n1:localhost:21211", LockingStrategy.LockingMode.AUTO, TestUtils.LoginType.FORM);
        this._tomcat2 = this.startTomcatWithAuth(18889, "n1:localhost:21211", LockingStrategy.LockingMode.AUTO, TestUtils.LoginType.FORM);
        this._tomcat1.setChangeSessionIdOnAuth(false);
        this._tomcat2.setChangeSessionIdOnAuth(false);
        String sessionId = TestUtils.loginWithForm(this._httpClient, 18888);
        TestUtils.Response tc1Response1 = TestUtils.post(this._httpClient, 18888, "/", sessionId, TestUtils.asMap("foo", "bar"));
        Assert.assertEquals((String)tc1Response1.getSessionId(), (String)sessionId);
        Assert.assertEquals((int)this._daemon1.getCache().getGetHits(), (int)6);
        Assert.assertEquals((int)this._daemon1.getCache().getSetCmds(), (int)8);
        TestUtils.Response tc1Response2 = TestUtils.get(this._httpClient, 18888, "/pixel.gif", sessionId);
        Assert.assertNull((Object)tc1Response2.getResponseSessionId());
        Assert.assertEquals((int)tc1Response2.getStatusCode(), (int)200);
        Assert.assertEquals((int)this._daemon1.getCache().getGetHits(), (int)8);
        Assert.assertEquals((int)this._daemon1.getCache().getSetCmds(), (int)8);
        TestUtils.Response tc1Response3 = TestUtils.post(this._httpClient, 18888, "/", sessionId, TestUtils.asMap("bar", "baz"));
        Assert.assertEquals((String)tc1Response3.getSessionId(), (String)sessionId);
        Assert.assertNull((Object)tc1Response3.getResponseSessionId());
        TestUtils.Response tc2Response1 = TestUtils.get(this._httpClient, 18889, sessionId);
        Assert.assertEquals((String)tc2Response1.getSessionId(), (String)sessionId);
        Assert.assertNull((Object)tc2Response1.getResponseSessionId());
        Assert.assertEquals((String)tc2Response1.get("id"), (String)sessionId);
        Assert.assertEquals((String)tc2Response1.get("foo"), (String)"bar");
        Assert.assertEquals((String)tc2Response1.get("bar"), (String)"baz");
    }

    @Test(enabled=true)
    public void testSessionCreatedForContainerProtectedResourceIsStoredInMemcached() throws Exception {
        this._tomcat1.stop();
        this._tomcat2.stop();
        this._tomcat1 = this.startTomcatWithAuth(18888, "n1:localhost:21211", LockingStrategy.LockingMode.AUTO, TestUtils.LoginType.FORM);
        this._tomcat2 = this.startTomcatWithAuth(18889, "n1:localhost:21211", LockingStrategy.LockingMode.AUTO, TestUtils.LoginType.FORM);
        this._tomcat1.setChangeSessionIdOnAuth(false);
        this._tomcat2.setChangeSessionIdOnAuth(false);
        LOG.info((Object)"START foo1234");
        TestUtils.Response response1 = TestUtils.get(this._httpClient, 18888, null);
        LOG.info((Object)"END foo1234");
        String sessionId = response1.getSessionId();
        Assert.assertNotNull((Object)sessionId);
        Assert.assertTrue((boolean)response1.getContent().contains("j_security_check"), (String)"IllegalState: /j_security_check not found, app is not properly initialized");
        Thread.sleep(200L);
        Assert.assertEquals((int)this._daemon1.getCache().getSetCmds(), (int)2);
        HashMap<String, String> params = new HashMap<String, String>();
        params.put("j_username", "testuser");
        params.put("j_password", "secret");
        TestUtils.Response response2 = TestUtils.post(this._httpClient, 18889, "/j_security_check", sessionId, params, null, false);
        Assert.assertNull((Object)response2.getResponseSessionId());
        Assert.assertTrue((boolean)TestUtils.isRedirect(response2.getStatusCode()), (String)("IllegalState: 'POST /j_security_check' did not issue a redirect, but status " + response2.getStatusCode() + ". Page content: " + response2.getContent()));
        Assert.assertEquals((int)this._daemon1.getCache().getGetHits(), (int)2);
        Assert.assertEquals((int)this._daemon1.getCache().getSetCmds(), (int)4);
    }

    @Test(enabled=true)
    public void testFormAuthDontCauseSessionStaleness() throws Exception {
        this._tomcat1.stop();
        this._tomcat2.stop();
        this._tomcat1 = this.startTomcatWithAuth(18888, "n1:localhost:21211", LockingStrategy.LockingMode.AUTO, TestUtils.LoginType.FORM);
        this._tomcat2 = this.startTomcatWithAuth(18889, "n1:localhost:21211", LockingStrategy.LockingMode.AUTO, TestUtils.LoginType.FORM);
        this._tomcat1.setChangeSessionIdOnAuth(false);
        this._tomcat2.setChangeSessionIdOnAuth(false);
        TestUtils.waitForReconnect(this._tomcat1.getService().getMemcached(), 1, 1000L);
        TestUtils.waitForReconnect(this._tomcat2.getService().getMemcached(), 1, 1000L);
        TestUtils.Response response1 = TestUtils.get(this._httpClient, 18888, null);
        String sessionId = response1.getSessionId();
        Assert.assertNotNull((Object)sessionId);
        Assert.assertTrue((boolean)response1.getContent().contains("j_security_check"), (String)"IllegalState: /j_security_check not found, app is not properly initialized");
        Thread.sleep(200L);
        HashMap<String, String> params = new HashMap<String, String>();
        params.put("j_username", "testuser");
        params.put("j_password", "secret");
        TestUtils.Response response2 = TestUtils.post(this._httpClient, 18889, "/j_security_check", sessionId, params, null, true);
        Assert.assertNull((Object)response2.getResponseSessionId());
        Assert.assertEquals((int)response2.getStatusCode(), (int)200, (String)response2.getContent());
        Assert.assertEquals((String)response2.get("id"), (String)sessionId);
        TestUtils.Response response3 = TestUtils.post(this._httpClient, 18889, "/", sessionId, TestUtils.asMap("foo", "bar"));
        Assert.assertEquals((String)response3.getSessionId(), (String)sessionId);
        TestUtils.Response response4 = TestUtils.get(this._httpClient, 18888, sessionId);
        Assert.assertEquals((String)response4.getSessionId(), (String)sessionId);
        Assert.assertEquals((String)response4.get("id"), (String)sessionId);
        Assert.assertEquals((String)response4.get("foo"), (String)"bar");
    }

    @Test(enabled=true)
    public void testInvalidateSessionShouldReleaseLockIssue144() throws IOException, InterruptedException, HttpException {
        this._tomcat1.getManager().setLockingMode(LockingStrategy.LockingMode.AUTO.name());
        String sessionId1 = TestUtils.get(this._httpClient, 18888, null).getSessionId();
        Assert.assertNotNull((Object)sessionId1, (String)"No session created.");
        TestUtils.Response response = TestUtils.get(this._httpClient, 18888, "/invalidate", sessionId1);
        Assert.assertNull((Object)response.getResponseSessionId());
        Assert.assertNull((Object)this._client.get(sessionId1), (String)"Invalidated session should be removed from memcached");
        Assert.assertNull((Object)this._client.get(new SessionIdFormat().createLockName(sessionId1)), (String)"Lock should be released.");
    }

    private TomcatBuilder<?> startTomcatWithAuth(int port, @Nonnull LockingStrategy.LockingMode lockingMode) throws Exception {
        return this.startTomcatWithAuth(port, MEMCACHED_NODES, lockingMode, TestUtils.LoginType.BASIC);
    }

    private TomcatBuilder<?> startTomcatWithAuth(int port, String memcachedNodes, LockingStrategy.LockingMode lockingMode, TestUtils.LoginType loginType) throws Exception {
        return ((TomcatBuilder)this.getTestUtils().tomcatBuilder()).port(port).sessionTimeout(5).loginType(loginType).memcachedNodes(memcachedNodes).sticky(false).lockingMode(lockingMode).buildAndStart();
    }

    @DataProvider
    public Object[][] sessionTrackingModesProvider() {
        return new Object[][]{{TestUtils.SessionTrackingMode.COOKIE}, {TestUtils.SessionTrackingMode.URL}};
    }
}

