/*
 * Decompiled with CFR 0.152.
 */
package de.javakaffee.web.msm.integration;

import com.thimbleware.jmemcached.CacheElement;
import com.thimbleware.jmemcached.Key;
import com.thimbleware.jmemcached.MemCacheDaemon;
import de.javakaffee.web.msm.MemcachedSessionService;
import de.javakaffee.web.msm.integration.TestUtils;
import de.javakaffee.web.msm.integration.TomcatBuilder;
import java.io.IOException;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.net.InetSocketAddress;
import java.net.SocketAddress;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Set;
import net.spy.memcached.MemcachedClient;
import org.apache.catalina.Session;
import org.apache.catalina.session.ManagerBase;
import org.apache.http.HttpException;
import org.apache.http.client.HttpClient;
import org.apache.http.impl.client.DefaultHttpClient;
import org.apache.juli.logging.Log;
import org.apache.juli.logging.LogFactory;
import org.testng.Assert;
import org.testng.annotations.AfterMethod;
import org.testng.annotations.BeforeMethod;
import org.testng.annotations.Test;

public abstract class MemcachedFailoverIntegrationTest {
    private static final Log LOG = LogFactory.getLog(MemcachedFailoverIntegrationTest.class);
    private MemCacheDaemon<? extends CacheElement> _daemon1;
    private MemCacheDaemon<? extends CacheElement> _daemon2;
    private MemCacheDaemon<? extends CacheElement> _daemon3;
    private TomcatBuilder<?> _tomcat1;
    private int _portTomcat1;
    private DefaultHttpClient _httpClient;
    private String _nodeId1;
    private String _nodeId2;
    private String _nodeId3;
    private InetSocketAddress _address1;
    private InetSocketAddress _address2;
    private InetSocketAddress _address3;

    @BeforeMethod
    public void setUp() throws Throwable {
        this._portTomcat1 = 18888;
        this._address1 = new InetSocketAddress("localhost", 21211);
        this._daemon1 = TestUtils.createDaemon(this._address1);
        this._daemon1.start();
        this._address2 = new InetSocketAddress("localhost", 21212);
        this._daemon2 = TestUtils.createDaemon(this._address2);
        this._daemon2.start();
        this._address3 = new InetSocketAddress("localhost", 21213);
        this._daemon3 = TestUtils.createDaemon(this._address3);
        this._daemon3.start();
        this._nodeId1 = "n1";
        this._nodeId2 = "n2";
        this._nodeId3 = "n3";
        try {
            String memcachedNodes = this.toString(this._nodeId1, this._address1) + " " + this.toString(this._nodeId2, this._address2) + " " + this.toString(this._nodeId3, this._address3);
            this._tomcat1 = ((TomcatBuilder)this.getTestUtils().tomcatBuilder()).port(this._portTomcat1).sessionTimeout(10).memcachedNodes(memcachedNodes).sticky(true).buildAndStart();
        }
        catch (Throwable e) {
            LOG.error((Object)"could not start tomcat.", e);
            throw e;
        }
        this._httpClient = new DefaultHttpClient();
    }

    abstract TestUtils<?> getTestUtils();

    private String toString(String nodeId, InetSocketAddress address) {
        return nodeId + ":" + address.getHostName() + ":" + address.getPort();
    }

    @AfterMethod
    public void tearDown() throws Exception {
        if (this._daemon1.isRunning()) {
            this._daemon1.stop();
        }
        if (this._daemon2.isRunning()) {
            this._daemon2.stop();
        }
        if (this._daemon3.isRunning()) {
            this._daemon3.stop();
        }
        this._tomcat1.stop();
        this._httpClient.getConnectionManager().shutdown();
    }

    @Test(enabled=true, dataProviderClass=TestUtils.class, dataProvider="stickynessProvider")
    public void testRelocateSession(TestUtils.SessionAffinityMode sessionAffinity) throws Throwable {
        this._tomcat1.getManager().setSticky(sessionAffinity.isSticky());
        Thread.sleep(200L);
        String sid1 = TestUtils.makeRequest((HttpClient)this._httpClient, this._portTomcat1, null);
        Assert.assertNotNull((Object)sid1, (String)"No session created.");
        String firstNode = TestUtils.extractNodeId(sid1);
        Assert.assertNotNull((Object)firstNode, (String)"No node id encoded in session id.");
        FailoverInfo info = this.getFailoverInfo(firstNode);
        info.activeNode.stop();
        Thread.sleep(50L);
        String sid2 = TestUtils.makeRequest((HttpClient)this._httpClient, this._portTomcat1, sid1);
        String secondNode = TestUtils.extractNodeId(sid2);
        Assert.assertNotSame((Object)secondNode, (Object)firstNode, (String)"First node again selected");
        Assert.assertEquals((String)sid2, (String)(sid1.substring(0, sid1.indexOf("-") + 1) + secondNode), (String)("Unexpected sessionId, sid1: " + sid1 + ", sid2: " + sid2));
        Assert.assertEquals((String)TestUtils.makeRequest((HttpClient)this._httpClient, this._portTomcat1, sid2), (String)sid2, (String)"We should keep the sessionId.");
        Assert.assertNotNull((Object)this.getFailoverInfo((String)secondNode).activeNode.getCache().get(new Key[]{TestUtils.key(sid2)})[0], (String)"The session should exist in memcached.");
        if (sessionAffinity.isSticky()) {
            Session session = this._tomcat1.getManager().findSession(sid2);
            Assert.assertNotNull((Object)session, (String)("Session not found by new id " + sid2));
            Assert.assertFalse((boolean)session.getNoteNames().hasNext(), (String)("Some notes are set: " + this.toArray(session.getNoteNames())));
        }
    }

    @Test(enabled=true, dataProviderClass=TestUtils.class, dataProvider="stickynessProvider")
    public void testMultipleMemcachedNodesFailure(TestUtils.SessionAffinityMode sessionAffinity) throws Throwable {
        this._tomcat1.getManager().setSticky(sessionAffinity.isSticky());
        Thread.sleep(200L);
        String paramKey = "foo";
        String paramValue = "bar";
        String sid1 = TestUtils.post(this._httpClient, this._portTomcat1, null, "foo", "bar").getResponseSessionId();
        Assert.assertNotNull((Object)sid1, (String)"No session created.");
        String firstNode = TestUtils.extractNodeId(sid1);
        Assert.assertNotNull((Object)firstNode, (String)"No node id encoded in session id.");
        FailoverInfo info = this.getFailoverInfo(firstNode);
        info.activeNode.stop();
        Map.Entry<String, MemCacheDaemon<?>> otherNodeWithId = info.previousNode();
        otherNodeWithId.getValue().stop();
        Thread.sleep(100L);
        String sid2 = TestUtils.get(this._httpClient, this._portTomcat1, sid1).getResponseSessionId();
        String secondNode = TestUtils.extractNodeId(sid2);
        LOG.debug((Object)("Have secondNode " + secondNode));
        String expectedNode = info.otherNodeExcept(otherNodeWithId.getKey()).getKey();
        Assert.assertEquals((String)secondNode, (String)expectedNode, (String)("Unexpected nodeId: " + secondNode + "."));
        Assert.assertEquals((String)sid2, (String)(sid1.substring(0, sid1.indexOf("-") + 1) + expectedNode), (String)("Unexpected sessionId, sid1: " + sid1 + ", sid2: " + sid2));
        TestUtils.Response response2 = TestUtils.get(this._httpClient, this._portTomcat1, sid2);
        Assert.assertEquals((String)response2.getSessionId(), (String)sid2, (String)"We should keep the sessionId.");
        MemCacheDaemon<?> activeNode = this.getFailoverInfo((String)secondNode).activeNode;
        Assert.assertNotNull((Object)activeNode.getCache().get(new Key[]{TestUtils.key(sid2)})[0], (String)"The session should exist in memcached.");
        Assert.assertEquals((String)response2.get("foo"), (String)"bar", (String)"The session should still contain the previously stored value.");
        if (sessionAffinity.isSticky()) {
            Session session = this._tomcat1.getManager().findSession(sid2);
            Assert.assertFalse((boolean)session.getNoteNames().hasNext(), (String)("Some notes are set: " + this.toArray(session.getNoteNames())));
        }
    }

    @Test(enabled=true)
    public void testSecondaryBackupForNonStickySessionAfterMemcachedFailover() throws Throwable {
        this._tomcat1.getManager().setSticky(false);
        Thread.sleep(200L);
        String paramKey = "foo";
        String paramValue = "bar";
        String sid1 = TestUtils.post(this._httpClient, this._portTomcat1, null, "foo", "bar").getResponseSessionId();
        Assert.assertNotNull((Object)sid1, (String)"No session created.");
        String firstNode = TestUtils.extractNodeId(sid1);
        Assert.assertNotNull((Object)firstNode, (String)"No node id encoded in session id.");
        LOG.info((Object)"-------------- stopping other nodes...");
        FailoverInfo info = this.getFailoverInfo(firstNode);
        for (MemCacheDaemon<?> node : info.otherNodes.values()) {
            node.stop();
        }
        Thread.sleep(100L);
        Assert.assertEquals((String)TestUtils.get(this._httpClient, this._portTomcat1, sid1).getSessionId(), (String)sid1);
        Thread.sleep(300L);
        LOG.info((Object)"-------------- starting next node...");
        info.nextNode().getValue().start();
        this.waitForReconnect(this._tomcat1.getManager().getMemcachedSessionService(), info.nextNode().getValue(), 5000L);
        Assert.assertEquals((String)TestUtils.get(this._httpClient, this._portTomcat1, sid1).getSessionId(), (String)sid1);
        Thread.sleep(300L);
        LOG.info((Object)"-------------- stopping active node...");
        info.activeNode.stop();
        Thread.sleep(100L);
        String sid2 = TestUtils.get(this._httpClient, this._portTomcat1, sid1).getSessionId();
        String secondNode = TestUtils.extractNodeId(sid2);
        String expectedNode = info.nextNode().getKey();
        Assert.assertEquals((String)secondNode, (String)expectedNode, (String)("Unexpected nodeId: " + secondNode + "."));
        Assert.assertEquals((String)sid2, (String)(sid1.substring(0, sid1.indexOf("-") + 1) + expectedNode), (String)("Unexpected sessionId, sid1: " + sid1 + ", sid2: " + sid2));
        TestUtils.Response response2 = TestUtils.get(this._httpClient, this._portTomcat1, sid2);
        Assert.assertEquals((String)response2.getSessionId(), (String)sid2, (String)"We should keep the sessionId.");
        Assert.assertNotNull((Object)this.getFailoverInfo((String)secondNode).activeNode.getCache().get(new Key[]{TestUtils.key(sid2)})[0], (String)"The session should exist in memcached.");
        Assert.assertEquals((String)response2.get("foo"), (String)"bar", (String)"The session should still contain the previously stored value.");
    }

    private void waitForReconnect(MemcachedSessionService service, MemCacheDaemon<?> value, long timeToWait) throws InterruptedException {
        InetSocketAddress serverAddress;
        MemcachedClient client;
        try {
            Method m = MemcachedSessionService.class.getDeclaredMethod("getMemcached", new Class[0]);
            m.setAccessible(true);
            client = (MemcachedClient)m.invoke((Object)service, new Object[0]);
            Field field = MemCacheDaemon.class.getDeclaredField("addr");
            field.setAccessible(true);
            serverAddress = (InetSocketAddress)field.get(value);
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
        this.waitForReconnect(client, serverAddress, timeToWait);
    }

    public void waitForReconnect(MemcachedClient client, InetSocketAddress serverAddressToCheck, long timeToWait) throws InterruptedException, RuntimeException {
        long start = System.currentTimeMillis();
        while (System.currentTimeMillis() < start + timeToWait) {
            for (SocketAddress address : client.getAvailableServers()) {
                if (!address.equals(serverAddressToCheck)) continue;
                return;
            }
            Thread.sleep(100L);
        }
        throw new RuntimeException("MemcachedClient did not reconnect after " + timeToWait + " millis.");
    }

    private Set<String> toArray(Iterator<String> noteNames) {
        HashSet<String> result = new HashSet<String>();
        while (noteNames.hasNext()) {
            result.add(noteNames.next());
        }
        return result;
    }

    @Test(enabled=true)
    public void testAllMemcachedNodesFailure() throws Throwable {
        this._tomcat1.getManager().setSticky(true);
        Thread.sleep(200L);
        String sid1 = TestUtils.makeRequest((HttpClient)this._httpClient, this._portTomcat1, null);
        Assert.assertNotNull((Object)sid1, (String)"No session created.");
        this._daemon1.stop();
        this._daemon2.stop();
        this._daemon3.stop();
        Thread.sleep(200L);
        String sid2 = TestUtils.makeRequest((HttpClient)this._httpClient, this._portTomcat1, sid1);
        Assert.assertEquals((String)sid1, (String)sid2, (String)"SessionId changed.");
        Assert.assertNotNull((Object)this.getSessions().get(sid1), (String)("Session " + sid1 + " not existing."));
        Session session = this._tomcat1.getManager().findSession(sid2);
        Assert.assertFalse((boolean)session.getNoteNames().hasNext(), (String)("Some notes are set: " + this.toArray(session.getNoteNames())));
    }

    @Test(enabled=true)
    public void testCookieNotSetWhenAllMemcachedsDownIssue40() throws IOException, HttpException, InterruptedException {
        this._tomcat1.getManager().setSticky(true);
        Thread.sleep(200L);
        this._daemon1.stop();
        this._daemon2.stop();
        this._daemon3.stop();
        TestUtils.Response response1 = TestUtils.get(this._httpClient, this._portTomcat1, null);
        String sessionId = response1.getSessionId();
        Assert.assertNotNull((Object)sessionId);
        Assert.assertNotNull((Object)response1.getResponseSessionId());
        String nodeId = TestUtils.extractNodeId(response1.getResponseSessionId());
        Assert.assertNull((Object)nodeId, (String)("NodeId should be null, but is " + nodeId + "."));
        TestUtils.Response response2 = TestUtils.get(this._httpClient, this._portTomcat1, sessionId);
        Assert.assertEquals((String)response2.getSessionId(), (String)sessionId, (String)"SessionId changed");
        Assert.assertNull((Object)response2.getResponseSessionId());
    }

    @Test(enabled=true, dataProviderClass=TestUtils.class, dataProvider="stickynessProvider")
    public void testCookieNotSetWhenRegularMemcachedDownIssue40(TestUtils.SessionAffinityMode sessionAffinity) throws Exception {
        String memcachedNodes = this.toString(this._nodeId1, this._address1) + " " + this.toString(this._nodeId2, this._address2);
        this.restartTomcat(memcachedNodes, this._nodeId1);
        this._tomcat1.getManager().setSticky(sessionAffinity.isSticky());
        this._daemon2.stop();
        TestUtils.waitForReconnect(this._tomcat1.getService().getMemcached(), 1, 1000L);
        TestUtils.Response response1 = TestUtils.get(this._httpClient, this._portTomcat1, null);
        String sessionId = response1.getSessionId();
        Assert.assertNotNull((Object)sessionId);
        Assert.assertNotNull((Object)response1.getResponseSessionId());
        String nodeId = TestUtils.extractNodeId(response1.getResponseSessionId());
        Assert.assertEquals((String)nodeId, (String)this._nodeId1);
        TestUtils.Response response2 = TestUtils.get(this._httpClient, this._portTomcat1, sessionId);
        Assert.assertEquals((String)response2.getSessionId(), (String)sessionId, (String)"SessionId changed");
        Assert.assertNull((Object)response2.getResponseSessionId());
    }

    @Test(enabled=true, dataProviderClass=TestUtils.class, dataProvider="stickynessProvider")
    public void testReconfigureMemcachedNodesAtRuntimeFeature46(TestUtils.SessionAffinityMode sessionAffinity) throws Exception {
        this._tomcat1.getManager().setSticky(sessionAffinity.isSticky());
        Thread.sleep(200L);
        String memcachedNodes1 = this.toString(this._nodeId1, this._address1) + " " + this.toString(this._nodeId2, this._address2);
        this.restartTomcat(memcachedNodes1, this._nodeId2);
        Thread.sleep(200L);
        TestUtils.Response response1 = TestUtils.get(this._httpClient, this._portTomcat1, null);
        String sessionId1 = response1.getSessionId();
        Assert.assertNotNull((Object)sessionId1);
        Assert.assertEquals((String)TestUtils.extractNodeId(sessionId1), (String)this._nodeId1);
        String memcachedNodes2 = this.toString(this._nodeId1, this._address1) + " " + this.toString(this._nodeId2, this._address2) + " " + this.toString(this._nodeId3, this._address3);
        this._tomcat1.getManager().setMemcachedNodes(memcachedNodes2);
        this._daemon1.stop();
        Thread.sleep(1000L);
        TestUtils.Response response2 = TestUtils.get(this._httpClient, this._portTomcat1, sessionId1);
        Assert.assertNotSame((Object)response2.getSessionId(), (Object)sessionId1);
        String sessionId2 = response2.getResponseSessionId();
        Assert.assertNotNull((Object)sessionId2);
        Assert.assertEquals((String)TestUtils.extractNodeId(sessionId2), (String)this._nodeId3);
    }

    @Test(enabled=true)
    public void testReconfigureFailoverNodesAtRuntimeFeature46() throws Exception {
        this._tomcat1.getManager().setSticky(true);
        this._tomcat1.getManager().setFailoverNodes(this._nodeId2 + " " + this._nodeId3);
        Thread.sleep(200L);
        TestUtils.Response response1 = TestUtils.get(this._httpClient, this._portTomcat1, null);
        String sessionId1 = response1.getSessionId();
        Assert.assertNotNull((Object)sessionId1);
        Assert.assertEquals((String)TestUtils.extractNodeId(sessionId1), (String)this._nodeId1);
        this._tomcat1.getManager().setFailoverNodes(this._nodeId1 + " " + this._nodeId2);
        Thread.sleep(200L);
        TestUtils.Response response2 = TestUtils.get(new DefaultHttpClient(), this._portTomcat1, null);
        String sessionId2 = response2.getSessionId();
        Assert.assertNotNull((Object)sessionId2);
        Assert.assertEquals((String)TestUtils.extractNodeId(sessionId2), (String)this._nodeId3);
    }

    private void restartTomcat(String memcachedNodes, String failoverNodes) throws Exception {
        this._tomcat1.stop();
        Thread.sleep(500L);
        this._tomcat1 = ((TomcatBuilder)this.getTestUtils().tomcatBuilder()).port(this._portTomcat1).sessionTimeout(10).memcachedNodes(memcachedNodes).failoverNodes(failoverNodes).buildAndStart();
    }

    private Map<String, Session> getSessions() throws NoSuchFieldException, IllegalAccessException {
        Field field = ManagerBase.class.getDeclaredField("sessions");
        field.setAccessible(true);
        Map sessions = (Map)field.get(this._tomcat1.getManager());
        return sessions;
    }

    private FailoverInfo getFailoverInfo(String nodeId) {
        if (this._nodeId1.equals(nodeId)) {
            return new FailoverInfo(this._daemon1, this.asMap(this._nodeId2, this._daemon2, this._nodeId3, this._daemon3));
        }
        if (this._nodeId2.equals(nodeId)) {
            return new FailoverInfo(this._daemon2, this.asMap(this._nodeId3, this._daemon3, this._nodeId1, this._daemon1));
        }
        if (this._nodeId3.equals(nodeId)) {
            return new FailoverInfo(this._daemon3, this.asMap(this._nodeId1, this._daemon1, this._nodeId2, this._daemon2));
        }
        throw new IllegalArgumentException("Node " + nodeId + " is not a valid node id.");
    }

    private Map<String, MemCacheDaemon<?>> asMap(String nodeId1, MemCacheDaemon<?> daemon1, String nodeId2, MemCacheDaemon<?> daemon2) {
        LinkedHashMap result = new LinkedHashMap(2);
        result.put(nodeId1, daemon1);
        result.put(nodeId2, daemon2);
        return result;
    }

    static class FailoverInfo {
        MemCacheDaemon<?> activeNode;
        Map<String, MemCacheDaemon<?>> otherNodes;

        public FailoverInfo(MemCacheDaemon<?> first, Map<String, MemCacheDaemon<?>> otherNodes) {
            this.activeNode = first;
            this.otherNodes = otherNodes;
        }

        public Map.Entry<String, MemCacheDaemon<?>> nextNode() {
            return this.otherNodes.entrySet().iterator().next();
        }

        public Map.Entry<String, MemCacheDaemon<?>> previousNode() {
            Map.Entry<String, MemCacheDaemon<?>> last = null;
            Iterator<Map.Entry<String, MemCacheDaemon<?>>> iterator = this.otherNodes.entrySet().iterator();
            while (iterator.hasNext()) {
                Map.Entry<String, MemCacheDaemon<?>> entry;
                last = entry = iterator.next();
            }
            return last;
        }

        public Map.Entry<String, MemCacheDaemon<?>> otherNodeExcept(String key) {
            for (Map.Entry<String, MemCacheDaemon<?>> entry : this.otherNodes.entrySet()) {
                if (entry.getKey().equals(key)) continue;
                return entry;
            }
            throw new IllegalStateException();
        }
    }
}

