/*
 * Decompiled with CFR 0.152.
 */
package de.javakaffee.web.msm;

import de.javakaffee.web.msm.DummyMemcachedSessionService;
import de.javakaffee.web.msm.JavaSerializationTranscoder;
import de.javakaffee.web.msm.MemcachedBackupSession;
import de.javakaffee.web.msm.MemcachedSessionService;
import de.javakaffee.web.msm.SessionAttributesTranscoder;
import de.javakaffee.web.msm.TranscoderService;
import de.javakaffee.web.msm.integration.TestUtils;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.security.Principal;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import org.apache.catalina.LifecycleException;
import org.apache.catalina.Manager;
import org.apache.catalina.authenticator.SavedRequest;
import org.apache.catalina.core.StandardContext;
import org.apache.catalina.realm.GenericPrincipal;
import org.mockito.Matchers;
import org.mockito.Mockito;
import org.mockito.invocation.InvocationOnMock;
import org.mockito.stubbing.Answer;
import org.testng.Assert;
import org.testng.annotations.BeforeMethod;
import org.testng.annotations.Test;

public abstract class TranscoderServiceTest {
    protected static MemcachedSessionService.SessionManager _manager;
    private static boolean _managerHasGetContainer;

    @BeforeMethod
    public void setup() throws LifecycleException, ClassNotFoundException, IOException {
        _manager = (MemcachedSessionService.SessionManager)Mockito.mock(MemcachedSessionService.SessionManager.class);
        StandardContext context = new StandardContext();
        Mockito.when((Object)_manager.getContext()).thenReturn((Object)context);
        if (_managerHasGetContainer) {
            Mockito.when((Object)_manager.getContainer()).thenReturn((Object)context);
        }
        Mockito.when((Object)_manager.newMemcachedBackupSession()).thenAnswer((Answer)new Answer<MemcachedBackupSession>(){

            public MemcachedBackupSession answer(InvocationOnMock invocation) throws Throwable {
                return TranscoderServiceTest.this.newMemcachedBackupSession(_manager);
            }
        });
        DummyMemcachedSessionService service = new DummyMemcachedSessionService(_manager);
        Mockito.when((Object)_manager.createSession(Matchers.anyString())).thenAnswer((Answer)new Answer<MemcachedBackupSession>((MemcachedSessionService)service){
            final /* synthetic */ MemcachedSessionService val$service;
            {
                this.val$service = memcachedSessionService;
            }

            public MemcachedBackupSession answer(InvocationOnMock invocation) throws Throwable {
                return TestUtils.createSession(this.val$service);
            }
        });
        Mockito.when((Object)_manager.readPrincipal((ObjectInputStream)Matchers.any())).thenReturn((Object)this.createPrincipal());
        Mockito.when((Object)_manager.getMemcachedSessionService()).thenReturn((Object)service);
        Mockito.when((Object)_manager.willAttributeDistribute(Matchers.anyString(), Matchers.any())).thenReturn((Object)true);
    }

    @Nonnull
    protected MemcachedBackupSession newMemcachedBackupSession(@Nullable MemcachedSessionService.SessionManager manager) {
        return new MemcachedBackupSession(manager);
    }

    @Test
    public void testSerializeSessionFieldsIncludesFormPrincipalNote() {
        MemcachedBackupSession session = (MemcachedBackupSession)_manager.createSession(null);
        GenericPrincipal saved = this.createPrincipal();
        session.setNote("org.apache.catalina.authenticator.PRINCIPAL", (Object)saved);
        byte[] data = TranscoderService.serializeSessionFields((MemcachedBackupSession)session);
        MemcachedBackupSession deserialized = TranscoderService.deserializeSessionFields((byte[])data, (MemcachedSessionService.SessionManager)_manager).getSession();
        Principal actual = (Principal)deserialized.getNote("org.apache.catalina.authenticator.PRINCIPAL");
        Assert.assertNotNull((Object)actual);
        TestUtils.assertDeepEquals(actual, saved);
    }

    @Test
    public void testSerializeSessionFieldsIncludesFormRequestNote() {
        MemcachedBackupSession session = (MemcachedBackupSession)_manager.createSession(null);
        SavedRequest saved = new SavedRequest();
        saved.setQueryString("foo=bar");
        saved.setRequestURI("http://www.foo.org");
        session.setNote("org.apache.catalina.authenticator.REQUEST", (Object)saved);
        byte[] data = TranscoderService.serializeSessionFields((MemcachedBackupSession)session);
        MemcachedBackupSession deserialized = TranscoderService.deserializeSessionFields((byte[])data, (MemcachedSessionService.SessionManager)_manager).getSession();
        SavedRequest actual = (SavedRequest)deserialized.getNote("org.apache.catalina.authenticator.REQUEST");
        Assert.assertNotNull((Object)actual);
        TestUtils.assertDeepEquals(actual, saved);
    }

    @Test
    public void testVersionUpgrade() {
        MemcachedBackupSession session = (MemcachedBackupSession)_manager.createSession(null);
        byte[] data = TranscoderService.serializeSessionFields((MemcachedBackupSession)session, (int)1);
        byte[] attributesData = TranscoderService.deserializeSessionFields((byte[])data, (MemcachedSessionService.SessionManager)_manager).getAttributesData();
        Assert.assertEquals((int)attributesData.length, (int)0);
    }

    @Test
    public void testSerializeSessionFields() {
        MemcachedBackupSession session = (MemcachedBackupSession)_manager.createSession(null);
        session.setLastBackupTime(System.currentTimeMillis());
        byte[] data = TranscoderService.serializeSessionFields((MemcachedBackupSession)session);
        MemcachedBackupSession deserialized = TranscoderService.deserializeSessionFields((byte[])data, (MemcachedSessionService.SessionManager)_manager).getSession();
        this.assertSessionFields(session, deserialized);
    }

    @Test
    public void testSerializeSessionFieldsWithAuthenticatedPrincipal() {
        MemcachedBackupSession session = (MemcachedBackupSession)_manager.createSession(null);
        session.setAuthType("FORM");
        session.setPrincipal((Principal)this.createPrincipal());
        session.setLastBackupTime(System.currentTimeMillis());
        byte[] data = TranscoderService.serializeSessionFields((MemcachedBackupSession)session);
        MemcachedBackupSession deserialized = TranscoderService.deserializeSessionFields((byte[])data, (MemcachedSessionService.SessionManager)_manager).getSession();
        this.assertSessionFields(session, deserialized);
    }

    @Nonnull
    protected abstract GenericPrincipal createPrincipal();

    @Test
    public void testSerializeSessionWithoutAttributes() {
        MemcachedBackupSession session = (MemcachedBackupSession)_manager.createSession(null);
        session.setLastBackupTime(System.currentTimeMillis());
        TranscoderService transcoderService = new TranscoderService((SessionAttributesTranscoder)new JavaSerializationTranscoder(_manager));
        byte[] data = transcoderService.serialize(session);
        MemcachedBackupSession deserialized = transcoderService.deserialize(data, _manager);
        this.assertSessionFields(session, deserialized);
    }

    @Test
    public void testSerializeSessionWithAttributes() {
        MemcachedBackupSession session = (MemcachedBackupSession)_manager.createSession(null);
        TranscoderService transcoderService = new TranscoderService((SessionAttributesTranscoder)new JavaSerializationTranscoder(_manager));
        String value = "bar";
        session.setAttribute("foo", (Object)"bar");
        session.setLastBackupTime(System.currentTimeMillis());
        byte[] data = transcoderService.serialize(session);
        MemcachedBackupSession deserialized = transcoderService.deserialize(data, _manager);
        this.assertSessionFields(session, deserialized);
        Assert.assertEquals((Object)"bar", (Object)deserialized.getAttribute("foo"));
    }

    private void assertSessionFields(MemcachedBackupSession session, MemcachedBackupSession deserialized) {
        Assert.assertEquals((long)session.getCreationTimeInternal(), (long)deserialized.getCreationTimeInternal());
        Assert.assertEquals((long)session.getLastAccessedTimeInternal(), (long)deserialized.getLastAccessedTimeInternal());
        Assert.assertEquals((int)session.getMaxInactiveInterval(), (int)deserialized.getMaxInactiveInterval());
        Assert.assertEquals((boolean)session.isNewInternal(), (boolean)deserialized.isNewInternal());
        Assert.assertEquals((boolean)session.isValidInternal(), (boolean)deserialized.isValidInternal());
        Assert.assertEquals((long)session.getThisAccessedTimeInternal(), (long)deserialized.getThisAccessedTimeInternal());
        Assert.assertEquals((long)session.getLastBackupTime(), (long)deserialized.getLastBackupTime());
        Assert.assertEquals((String)session.getIdInternal(), (String)deserialized.getIdInternal());
        Assert.assertEquals((String)session.getAuthType(), (String)deserialized.getAuthType());
        TestUtils.assertDeepEquals(session.getPrincipal(), deserialized.getPrincipal());
    }

    static {
        try {
            Manager.class.getDeclaredMethod("getContainer", new Class[0]);
            _managerHasGetContainer = true;
        }
        catch (NoSuchMethodException noSuchMethodException) {
            // empty catch block
        }
    }
}

