/*
 * Decompiled with CFR 0.152.
 */
package de.javakaffee.web.msm;

import de.javakaffee.web.msm.StorageKeyFormat;
import org.testng.Assert;
import org.testng.annotations.Test;

public class StorageKeyFormatTest {
    @Test
    public void testBlankValue() {
        Assert.assertEquals((String)StorageKeyFormat.of(null, null, null, null).format("foo"), (String)"foo");
        Assert.assertEquals((String)StorageKeyFormat.of((String)"", null, null, null).format("foo"), (String)"foo");
    }

    @Test
    public void testPrefixBuilderFactory() {
        String prefix = StorageKeyFormat.PrefixTokenFactory.parse((String)"static:foo", null, null, null);
        Assert.assertEquals((String)prefix, (String)"foo");
    }

    @Test
    public void testStaticValue() {
        StorageKeyFormat cut = StorageKeyFormat.of((String)"static:x", null, null, null);
        Assert.assertNotNull((Object)cut);
        Assert.assertEquals((String)cut.format("foo"), (String)"x_foo");
    }

    @Test
    public void testHost() {
        StorageKeyFormat cut = StorageKeyFormat.of((String)"host", (String)"hst", null, null);
        Assert.assertNotNull((Object)cut);
        Assert.assertEquals((String)cut.format("foo"), (String)"hst_foo");
    }

    @Test
    public void testHostHash() {
        StorageKeyFormat cut = StorageKeyFormat.of((String)"host.hash", (String)"hst", null, null);
        Assert.assertNotNull((Object)cut);
        Assert.assertEquals((String)cut.format("foo"), (String)(StorageKeyFormat.hashString((String)"hst") + "_foo"));
    }

    @Test
    public void testContext() {
        Assert.assertEquals((String)StorageKeyFormat.of((String)"context", null, (String)"ctxt", null).format("foo"), (String)"ctxt_foo");
        Assert.assertEquals((String)StorageKeyFormat.of((String)"context", null, null, null).format("foo"), (String)"foo");
        Assert.assertEquals((String)StorageKeyFormat.of((String)"context", null, (String)"", null).format("foo"), (String)"foo");
    }

    @Test
    public void testContextHash() {
        Assert.assertEquals((String)StorageKeyFormat.of((String)"context.hash", null, (String)"ctxt", null).format("foo"), (String)(StorageKeyFormat.hashString((String)"ctxt") + "_foo"));
    }

    @Test
    public void testWebappVersion() {
        Assert.assertEquals((String)StorageKeyFormat.of((String)"webappVersion", null, null, (String)"001").format("foo"), (String)"001_foo");
        Assert.assertEquals((String)StorageKeyFormat.of((String)"webappVersion", null, null, null).format("foo"), (String)"foo");
        Assert.assertEquals((String)StorageKeyFormat.of((String)"webappVersion", null, null, (String)"").format("foo"), (String)"foo");
    }

    @Test
    public void testHostAndContext() {
        Assert.assertEquals((String)StorageKeyFormat.of((String)"host,context", (String)"hst", (String)"ctxt", null).format("foo"), (String)"hst:ctxt_foo");
        Assert.assertEquals((String)StorageKeyFormat.of((String)"host,context", (String)"hst", (String)"", null).format("foo"), (String)"hst_foo");
    }

    @Test
    public void testHostAndContextHashesWithWebappVersion() {
        StorageKeyFormat cut = StorageKeyFormat.of((String)"host.hash,context.hash,webappVersion", (String)"hst", (String)"ctxt", (String)"001");
        Assert.assertNotNull((Object)cut);
        Assert.assertEquals((String)cut.format("foo"), (String)(StorageKeyFormat.hashString((String)"hst") + ":" + StorageKeyFormat.hashString((String)"ctxt") + ":001_foo"));
    }
}

