/*
 * Decompiled with CFR 0.152.
 */
package de.javakaffee.web.msm;

import de.javakaffee.web.msm.NodeAvailabilityCache;
import de.javakaffee.web.msm.NodeIdList;
import de.javakaffee.web.msm.NodeIdService;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import org.testng.Assert;
import org.testng.annotations.Test;

public class NodeIdServiceTest {
    @Test
    public void testSetNodeAvailability() {
        String nodeId1 = "n1";
        NodeAvailabilityCache.CacheLoader<String> cacheLoader = new NodeAvailabilityCache.CacheLoader<String>(){

            public boolean isNodeAvailable(String key) {
                return true;
            }
        };
        NodeIdService cut = new NodeIdService(new NodeAvailabilityCache(10, 100L, (NodeAvailabilityCache.CacheLoader)cacheLoader), NodeIdList.create((String[])new String[]{"n1"}), Collections.emptyList());
        Assert.assertTrue((boolean)cut.isNodeAvailable("n1"));
        cut.setNodeAvailable("n1", false);
        Assert.assertFalse((boolean)cut.isNodeAvailable("n1"));
        cut.setNodeAvailable("n1", true);
        Assert.assertTrue((boolean)cut.isNodeAvailable("n1"));
    }

    @Test
    public final void testGetNextNodeId_SingleNode() {
        DummyCacheLoader cacheLoader = new DummyCacheLoader(null);
        NodeIdService cut = new NodeIdService(new NodeAvailabilityCache(10, 100L, (NodeAvailabilityCache.CacheLoader)cacheLoader), NodeIdList.create((String[])new String[]{"n1"}), null);
        String actual = cut.getAvailableNodeId("n1");
        Assert.assertNull((Object)actual, (String)"For a sole existing node we cannot get a next node");
    }

    @Test
    public final void testGetNextNodeId_TwoNodes() {
        String nodeId1 = "n1";
        String nodeId2 = "n2";
        DummyCacheLoader cacheLoader = new DummyCacheLoader(null);
        NodeIdService cut = new NodeIdService(new NodeAvailabilityCache(10, 100L, (NodeAvailabilityCache.CacheLoader)cacheLoader), NodeIdList.create((String[])new String[]{"n1", "n2"}), null);
        String actual = cut.getAvailableNodeId("n1");
        Assert.assertEquals((String)"n2", (String)actual);
        actual = cut.getAvailableNodeId("n2");
        Assert.assertEquals((String)"n1", (String)actual);
    }

    @Test
    public final void testGetNextNodeId_TwoNodes_NoNodeLeft() {
        String nodeId1 = "n1";
        String nodeId2 = "n2";
        DummyCacheLoader cacheLoader = new DummyCacheLoader(Arrays.asList("n1"));
        NodeIdService cut = new NodeIdService(new NodeAvailabilityCache(10, 100L, (NodeAvailabilityCache.CacheLoader)cacheLoader), NodeIdList.create((String[])new String[]{"n1", "n2"}), null);
        String actual = cut.getAvailableNodeId("n2");
        Assert.assertNull((Object)actual);
    }

    @Test
    public final void testGetNextNodeId_RegularNode_NoRegularNodeLeft() {
        String nodeId1 = "n1";
        String nodeId2 = "n2";
        NodeIdService cut = new NodeIdService(this.createNodeAvailabilityCache(new String[0]), NodeIdList.create((String[])new String[]{"n1"}), Arrays.asList("n2"));
        String actual = cut.getAvailableNodeId("n1");
        Assert.assertEquals((String)"n2", (String)actual, (String)"The failover node is not chosen");
    }

    @Test
    public final void testGetNextNodeId_FailoverNode_RegularNodeLeft() {
        String nodeId1 = "n1";
        String nodeId2 = "n2";
        NodeIdService cut = new NodeIdService(this.createNodeAvailabilityCache(new String[0]), NodeIdList.create((String[])new String[]{"n1"}), Arrays.asList("n2"));
        String actual = cut.getAvailableNodeId("n2");
        Assert.assertEquals((String)"n1", (String)actual, (String)"The regular node is not chosen");
    }

    @Test
    public final void testGetNextNodeId_FailoverNode_NoRegularNodeLeft() {
        String nodeId1 = "n1";
        String nodeId2 = "n2";
        NodeIdService cut = new NodeIdService(this.createNodeAvailabilityCache("n1"), NodeIdList.create((String[])new String[]{"n1"}), Arrays.asList("n2"));
        String actual = cut.getAvailableNodeId("n2");
        Assert.assertNull((Object)actual);
    }

    @Test
    public final void testGetNextNodeId_FailoverNode_NoRegularNodeButAnotherFailoverNodeLeft() {
        String nodeId1 = "n1";
        String nodeId2 = "n2";
        String nodeId3 = "n3";
        NodeIdService cut = new NodeIdService(this.createNodeAvailabilityCache("n1"), NodeIdList.create((String[])new String[]{"n1"}), Arrays.asList("n2", "n3"));
        String actual = cut.getAvailableNodeId("n2");
        Assert.assertEquals((String)"n3", (String)actual, (String)"The second failover node is not chosen");
    }

    private NodeAvailabilityCache<String> createNodeAvailabilityCache(String ... unavailableNodes) {
        List<String> unavailable = unavailableNodes != null ? Arrays.asList(unavailableNodes) : null;
        return new NodeAvailabilityCache(10, 100L, (NodeAvailabilityCache.CacheLoader)new DummyCacheLoader(unavailable));
    }

    private static final class DummyCacheLoader
    implements NodeAvailabilityCache.CacheLoader<String> {
        private final List<String> _unavailable;

        private DummyCacheLoader(List<String> unavailable) {
            this._unavailable = unavailable;
        }

        public boolean isNodeAvailable(String key) {
            return this._unavailable == null || !this._unavailable.contains(key);
        }
    }
}

