/*
 * Decompiled with CFR 0.152.
 */
package de.javakaffee.web.msm;

import com.couchbase.client.CouchbaseClient;
import de.javakaffee.web.msm.BackupResultStatus;
import de.javakaffee.web.msm.BackupSessionTask;
import de.javakaffee.web.msm.JavaSerializationTranscoder;
import de.javakaffee.web.msm.MemcachedBackupSession;
import de.javakaffee.web.msm.MemcachedSessionService;
import de.javakaffee.web.msm.Pair;
import de.javakaffee.web.msm.SessionAttributesTranscoder;
import de.javakaffee.web.msm.TranscoderService;
import de.javakaffee.web.msm.integration.TestUtils;
import de.javakaffee.web.msm.integration.TomcatBuilder;
import java.io.IOException;
import java.lang.reflect.Method;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ExecutionException;
import net.spy.memcached.MemcachedClient;
import org.apache.juli.logging.Log;
import org.apache.juli.logging.LogFactory;
import org.couchbase.mock.CouchbaseMock;
import org.testng.Assert;
import org.testng.annotations.AfterMethod;
import org.testng.annotations.BeforeMethod;
import org.testng.annotations.Test;

public abstract class CouchbaseIntegrationTest {
    private static final Log LOG = LogFactory.getLog(CouchbaseIntegrationTest.class);
    private final List<Pair<CouchbaseMock, Thread>> cluster = new ArrayList<Pair<CouchbaseMock, Thread>>(2);
    private MemcachedClient mc;
    private TomcatBuilder<?> _tomcat1;
    private final int _portTomcat1 = 18888;
    private boolean couchbaseProvided;
    private TranscoderService transcoderService;

    abstract TestUtils<?> getTestUtils();

    @BeforeMethod
    public void setUp(Method testMethod) throws Throwable {
        this.couchbaseProvided = Boolean.parseBoolean(System.getProperty("couchbase.provided", "false"));
        int couchbasePort = Integer.parseInt(System.getProperty("couchbase.port", "18091"));
        if (!this.couchbaseProvided) {
            this.cluster.add(this.setupCouchbase(couchbasePort));
        }
        try {
            System.setProperty("org.apache.catalina.startup.EXIT_ON_INIT_FAILURE", "true");
            this._tomcat1 = ((TomcatBuilder)this.getTestUtils().tomcatBuilder()).port(18888).memcachedNodes("http://localhost:" + couchbasePort + "/pools").sticky(true).memcachedProtocol("binary").username("default").buildAndStart();
        }
        catch (Throwable e) {
            LOG.error((Object)"could not start tomcat.", e);
            throw e;
        }
        this.setupCouchbaseClient();
        this.transcoderService = new TranscoderService((SessionAttributesTranscoder)new JavaSerializationTranscoder(this._tomcat1.getManager()));
    }

    @AfterMethod
    public void tearDown() throws Exception {
        this.mc.shutdown();
        this.mc = null;
        if (!this.couchbaseProvided) {
            this.tearDownCouchbase();
        }
        this._tomcat1.stop();
    }

    @Test
    public void testBackupSessionInCouchbase() throws InterruptedException, ExecutionException {
        MemcachedSessionService service = this._tomcat1.getService();
        MemcachedBackupSession session = TestUtils.createSession(service);
        String sessionId = "12345";
        session.setId("12345");
        session.setAttribute("foo", (Object)"bar");
        BackupSessionTask.BackupResult backupResult = (BackupSessionTask.BackupResult)service.backupSession(session.getIdInternal(), false, null).get();
        Assert.assertEquals((Object)backupResult.getStatus(), (Object)BackupResultStatus.SUCCESS);
        MemcachedBackupSession loadedSession = this.transcoderService.deserialize((byte[])this.mc.get("12345"), this._tomcat1.getManager());
        this.checkSession(loadedSession, session);
    }

    @Test(enabled=false)
    public void testBackupSessionInCouchbaseCluster() throws Exception {
        MemcachedSessionService service = this._tomcat1.getService();
        this.cluster.add(this.setupCouchbase(this.getMaxCouchbasePort() + 1));
        service.setMemcachedNodes(this.getMemcachedNodesConfig(this.getURIs()));
        this.setupCouchbaseClient();
        this.waitForReconnect(service.getMemcached(), this.cluster.size(), 1000L);
        this.waitForReconnect(this.mc, this.cluster.size(), 1000L);
        MemcachedBackupSession session = TestUtils.createSession(service);
        String sessionId = "12345";
        session.setId("12345");
        session.setAttribute("foo", (Object)"bar");
        BackupSessionTask.BackupResult backupResult = (BackupSessionTask.BackupResult)service.backupSession(session.getIdInternal(), false, null).get();
        Assert.assertEquals((Object)backupResult.getStatus(), (Object)BackupResultStatus.SUCCESS);
        MemcachedBackupSession loadedSession = this.transcoderService.deserialize((byte[])this.mc.get("12345"), this._tomcat1.getManager());
        this.checkSession(loadedSession, session);
    }

    private void checkSession(MemcachedBackupSession actual, MemcachedBackupSession expected) {
        Assert.assertNotNull((Object)actual);
        Assert.assertEquals((String)actual.getId(), (String)expected.getId());
        Assert.assertEquals((Map)actual.getAttributesInternal(), (Map)expected.getAttributesInternal());
    }

    private void waitForReconnect(MemcachedClient client, int expectedServers, long timeToWait) throws InterruptedException, RuntimeException {
        long start = System.currentTimeMillis();
        while (System.currentTimeMillis() < start + timeToWait) {
            if (client.getAvailableServers().size() == expectedServers) {
                return;
            }
            Thread.sleep(20L);
        }
        throw new RuntimeException("MemcachedClient did not reconnect after " + timeToWait + " millis.");
    }

    private void setupCouchbaseClient() throws URISyntaxException, IOException {
        if (this.mc != null) {
            LOG.info((Object)"Closing existing couchbase client.");
            this.mc.shutdown();
        }
        List<URI> uris = this.getURIs();
        LOG.info((Object)("Creating new couchbase client with uris " + uris));
        this.mc = new CouchbaseClient(uris, "default", "");
    }

    private List<URI> getURIs() throws URISyntaxException {
        ArrayList<URI> uris = new ArrayList<URI>(this.cluster.size());
        for (Pair<CouchbaseMock, Thread> server : this.cluster) {
            uris.add(new URI("http://localhost:" + ((CouchbaseMock)server.getFirst()).getHttpPort() + "/pools"));
        }
        return uris;
    }

    private Pair<CouchbaseMock, Thread> setupCouchbase(int couchbasePort) throws IOException {
        CouchbaseMock couchbase = new CouchbaseMock("localhost", couchbasePort, 1, 1);
        couchbase.setRequiredHttpAuthorization(null);
        Thread thread = new Thread((Runnable)couchbase);
        thread.start();
        return Pair.of((Object)couchbase, (Object)thread);
    }

    private void tearDownCouchbase() throws InterruptedException {
        for (Pair<CouchbaseMock, Thread> server : this.cluster) {
            ((Thread)server.getSecond()).interrupt();
            ((Thread)server.getSecond()).join(1000L);
            ((CouchbaseMock)server.getFirst()).close();
        }
        this.cluster.clear();
    }

    private String getMemcachedNodesConfig(List<URI> urIs) {
        StringBuilder sb = new StringBuilder();
        for (URI uri : urIs) {
            if (sb.length() > 1) {
                sb.append(",");
            }
            sb.append(uri.toString());
        }
        String couchbaseNodes = sb.toString();
        return couchbaseNodes;
    }

    private int getMaxCouchbasePort() {
        return ((CouchbaseMock)this.cluster.get(this.cluster.size() - 1).getFirst()).getHttpPort();
    }
}

