/*
 * Copyright 2013 Martin Grotzke
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an &quot;AS IS&quot; BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
package de.javakaffee.web.msm;

import org.apache.catalina.connector.Request;

/**
 * Provides access to the current request.
 *
 * @author @author <a href="mailto:martin.grotzke@javakaffee.de">Martin Grotzke</a>
 */
public class CurrentRequest {

    private final InheritableThreadLocal<Request> _requestsThreadLocal = new InheritableThreadLocal<Request>();

    public Request get() {
        return _requestsThreadLocal.get();
    }

    public void set(final Request request) {
        _requestsThreadLocal.set(request);
    }

    public void reset() {
        _requestsThreadLocal.set(null);
    }

}
