/*
 * Decompiled with CFR 0.152.
 */
package de.javakaffee.web.msm;

import de.javakaffee.web.msm.SessionTrackerValve;
import de.javakaffee.web.msm.Statistics;
import java.lang.reflect.Method;
import java.util.concurrent.atomic.AtomicBoolean;
import javax.annotation.CheckForNull;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import org.apache.catalina.Context;
import org.apache.catalina.Globals;

class SessionTrackerValveTC6
extends SessionTrackerValve {
    public SessionTrackerValveTC6(@Nullable String ignorePattern, @Nonnull Context context, @Nonnull SessionTrackerValve.SessionBackupService sessionBackupService, @Nonnull Statistics statistics, @Nonnull AtomicBoolean enabled) {
        super(ignorePattern, context, sessionBackupService, statistics, enabled);
    }

    protected String getSessionCookieName(Context context) {
        String result = this.getSessionCookieNameFromContext(context);
        if (result == null) {
            result = Globals.SESSION_COOKIE_NAME;
            this._log.debug((Object)("Using session cookie name from context: " + result));
        }
        return result;
    }

    @CheckForNull
    private String getSessionCookieNameFromContext(Context context) {
        try {
            Method getSessionCookieName = Context.class.getDeclaredMethod("getSessionCookieName", new Class[0]);
            String result = (String)getSessionCookieName.invoke((Object)context, new Object[0]);
            if (result != null) {
                this._log.debug((Object)("Using session cookie name from context: " + result));
            }
            return result;
        }
        catch (NoSuchMethodException e) {
        }
        catch (Exception e) {
            throw new RuntimeException("Could not read session cookie name from context.", e);
        }
        return null;
    }
}

