/*
 * Decompiled with CFR 0.152.
 */
package de.javakaffee.kryoserializers;

import com.esotericsoftware.kryo.Kryo;
import com.esotericsoftware.kryo.Serializer;
import com.esotericsoftware.kryo.io.Input;
import com.esotericsoftware.kryo.io.Output;
import java.lang.reflect.Field;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.SortedMap;
import java.util.SortedSet;
import java.util.TreeMap;
import java.util.TreeSet;

public class SynchronizedCollectionsSerializer
extends Serializer<Object> {
    private static final Field SOURCE_COLLECTION_FIELD;
    private static final Field SOURCE_MAP_FIELD;

    public Object read(Kryo kryo, Input input, Class<Object> clazz) {
        int ordinal = input.readInt(true);
        SynchronizedCollection collection = SynchronizedCollection.values()[ordinal];
        Object sourceCollection = kryo.readClassAndObject(input);
        return collection.create(sourceCollection);
    }

    public void write(Kryo kryo, Output output, Object object) {
        try {
            SynchronizedCollection collection = SynchronizedCollection.valueOfType(object.getClass());
            output.writeInt(collection.ordinal(), true);
            kryo.writeClassAndObject(output, collection.sourceCollectionField.get(object));
        }
        catch (RuntimeException e) {
            throw e;
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    public static void registerSerializers(Kryo kryo) {
        SynchronizedCollectionsSerializer serializer = new SynchronizedCollectionsSerializer();
        SynchronizedCollection.values();
        for (SynchronizedCollection item : SynchronizedCollection.values()) {
            kryo.register(item.type, (Serializer)serializer);
        }
    }

    static /* synthetic */ Field access$100() {
        return SOURCE_COLLECTION_FIELD;
    }

    static /* synthetic */ Field access$300() {
        return SOURCE_MAP_FIELD;
    }

    static {
        try {
            SOURCE_COLLECTION_FIELD = Class.forName("java.util.Collections$SynchronizedCollection").getDeclaredField("c");
            SOURCE_COLLECTION_FIELD.setAccessible(true);
            SOURCE_MAP_FIELD = Class.forName("java.util.Collections$SynchronizedMap").getDeclaredField("m");
            SOURCE_MAP_FIELD.setAccessible(true);
        }
        catch (Exception e) {
            throw new RuntimeException("Could not access source collection field in java.util.Collections$SynchronizedCollection.", e);
        }
    }

    private static enum SynchronizedCollection {
        COLLECTION((Class)Collections.synchronizedCollection(Arrays.asList("")).getClass(), SynchronizedCollectionsSerializer.access$100()){

            @Override
            public Object create(Object sourceCollection) {
                return Collections.synchronizedCollection((Collection)sourceCollection);
            }
        }
        ,
        RANDOM_ACCESS_LIST((Class)Collections.synchronizedList(new ArrayList<E>()).getClass(), SynchronizedCollectionsSerializer.access$100()){

            @Override
            public Object create(Object sourceCollection) {
                return Collections.synchronizedList((List)sourceCollection);
            }
        }
        ,
        LIST((Class)Collections.synchronizedList(new LinkedList<E>()).getClass(), SynchronizedCollectionsSerializer.access$100()){

            @Override
            public Object create(Object sourceCollection) {
                return Collections.synchronizedList((List)sourceCollection);
            }
        }
        ,
        SET((Class)Collections.synchronizedSet(new HashSet<E>()).getClass(), SynchronizedCollectionsSerializer.access$100()){

            @Override
            public Object create(Object sourceCollection) {
                return Collections.synchronizedSet((Set)sourceCollection);
            }
        }
        ,
        SORTED_SET((Class)Collections.synchronizedSortedSet(new TreeSet<E>()).getClass(), SynchronizedCollectionsSerializer.access$100()){

            @Override
            public Object create(Object sourceCollection) {
                return Collections.synchronizedSortedSet((SortedSet)sourceCollection);
            }
        }
        ,
        MAP((Class)Collections.synchronizedMap(new HashMap<K, V>()).getClass(), SynchronizedCollectionsSerializer.access$300()){

            @Override
            public Object create(Object sourceCollection) {
                return Collections.synchronizedMap((Map)sourceCollection);
            }
        }
        ,
        SORTED_MAP((Class)Collections.synchronizedSortedMap(new TreeMap<K, V>()).getClass(), SynchronizedCollectionsSerializer.access$300()){

            @Override
            public Object create(Object sourceCollection) {
                return Collections.synchronizedSortedMap((SortedMap)sourceCollection);
            }
        };

        private final Class<?> type;
        private final Field sourceCollectionField;

        private SynchronizedCollection(Class<?> type, Field sourceCollectionField) {
            this.type = type;
            this.sourceCollectionField = sourceCollectionField;
        }

        public abstract Object create(Object var1);

        static SynchronizedCollection valueOfType(Class<?> type) {
            for (SynchronizedCollection item : SynchronizedCollection.values()) {
                if (!item.type.equals(type)) continue;
                return item;
            }
            throw new IllegalArgumentException("The type " + type + " is not supported.");
        }
    }
}

