/*
 * Decompiled with CFR 0.152.
 */
package de.javakaffee.validation;

import de.javakaffee.validation.EntityManagerAwareValidator;
import de.javakaffee.validation.UniqueKey;
import java.io.Serializable;
import java.lang.reflect.Field;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.List;
import java.util.Locale;
import javax.annotation.CheckForNull;
import javax.annotation.Nonnull;
import javax.persistence.EntityManager;
import javax.persistence.Id;
import javax.persistence.criteria.CriteriaBuilder;
import javax.persistence.criteria.CriteriaQuery;
import javax.persistence.criteria.Expression;
import javax.persistence.criteria.Predicate;
import javax.persistence.criteria.Root;
import javax.validation.ConstraintValidator;
import javax.validation.ConstraintValidatorContext;

public class UniqueKeyValidator
implements ConstraintValidator<UniqueKey, Serializable>,
EntityManagerAwareValidator {
    private EntityManager entityManager;
    private UniqueKey constraintAnnotation;

    public UniqueKeyValidator() {
    }

    public UniqueKeyValidator(EntityManager entityManager) {
        this.entityManager = entityManager;
    }

    @Override
    public void setEntityManager(EntityManager entityManager) {
        this.entityManager = entityManager;
    }

    public EntityManager getEntityManager() {
        return this.entityManager;
    }

    public void initialize(UniqueKey constraintAnnotation) {
        this.constraintAnnotation = constraintAnnotation;
    }

    public boolean isValid(Serializable target, ConstraintValidatorContext context) {
        if (this.entityManager == null) {
            return true;
        }
        Class<?> entityClass = target.getClass();
        CriteriaBuilder criteriaBuilder = this.entityManager.getCriteriaBuilder();
        CriteriaQuery criteriaQuery = criteriaBuilder.createQuery();
        Root root = criteriaQuery.from(entityClass);
        try {
            Object propertyValue = this.getPropertyValue(target, this.constraintAnnotation.property());
            Predicate uniquePropertyPredicate = criteriaBuilder.equal((Expression)root.get(this.constraintAnnotation.property()), propertyValue);
            Field idField = this.getIdField(entityClass);
            String idProperty = idField.getName();
            Object idValue = this.getPropertyValue(target, idProperty);
            if (idValue != null) {
                Predicate idNotEqualsPredicate = criteriaBuilder.notEqual((Expression)root.get(idProperty), idValue);
                criteriaQuery.where(new Predicate[]{uniquePropertyPredicate, idNotEqualsPredicate});
            } else {
                criteriaQuery.where((Expression)uniquePropertyPredicate);
            }
        }
        catch (Exception e) {
            throw new RuntimeException("An error occurred when trying to create the jpa predicate for the @UniqueKey '" + this.constraintAnnotation.property() + "' on bean " + entityClass + ".", e);
        }
        List resultSet = this.entityManager.createQuery(criteriaQuery).getResultList();
        if (!resultSet.isEmpty()) {
            context.buildConstraintViolationWithTemplate(this.constraintAnnotation.message()).addNode(this.constraintAnnotation.property()).addConstraintViolation().disableDefaultConstraintViolation();
            return false;
        }
        return true;
    }

    private Field getIdField(Class<?> entityClass) {
        Field[] fields;
        for (Field field : fields = entityClass.getDeclaredFields()) {
            Id annotation = field.getAnnotation(Id.class);
            if (annotation == null) continue;
            return field;
        }
        if (entityClass.getSuperclass() != Object.class) {
            return this.getIdField(entityClass.getSuperclass());
        }
        throw new IllegalArgumentException("No id field found on class " + entityClass);
    }

    @CheckForNull
    protected Object getPropertyValue(@Nonnull Object object, @Nonnull String propertyName) throws IllegalArgumentException, IllegalAccessException, InvocationTargetException {
        Method method = this.getGetter(object.getClass(), propertyName);
        return method.invoke(object, (Object[])null);
    }

    @Nonnull
    private String toMethodName(@Nonnull String methodPrefix, @Nonnull String propertyName) {
        return methodPrefix + propertyName.substring(0, 1).toUpperCase(Locale.ENGLISH) + propertyName.substring(1);
    }

    @Nonnull
    private Method getGetter(@Nonnull Class<?> clazz, @Nonnull String property) {
        Method getter;
        String get = this.toMethodName("get", property);
        String is = this.toMethodName("is", property);
        try {
            getter = clazz.getMethod(get, new Class[0]);
        }
        catch (NoSuchMethodException noSuchMethodException) {
            try {
                getter = clazz.getMethod(is, new Class[0]);
            }
            catch (NoSuchMethodException noSuchMethodException2) {
                throw new RuntimeException("Getter for '" + clazz.getSimpleName() + '#' + property + "' not found.", noSuchMethodException2);
            }
            catch (SecurityException securityException) {
                throw new RuntimeException("Method '" + clazz.getSimpleName() + '#' + is + "()' is protected by the security manager.");
            }
        }
        catch (SecurityException securityException) {
            try {
                getter = clazz.getMethod(is, new Class[0]);
            }
            catch (NoSuchMethodException noSuchMethodException) {
                throw new RuntimeException("Method '" + clazz.getSimpleName() + '#' + get + "()' is protected by the security manager.");
            }
            catch (SecurityException securityException2) {
                throw new RuntimeException("Methods '" + clazz.getSimpleName() + '#' + get + "()' and " + clazz.getSimpleName() + '#' + is + "()' are protected by the security manager.");
            }
        }
        return getter;
    }
}

