/*
 * Decompiled with CFR 0.152.
 */
package de.javakaffee.validation;

import java.lang.annotation.Annotation;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.Locale;
import javax.annotation.CheckForNull;
import javax.annotation.Nonnull;
import javax.validation.ConstraintValidator;

public abstract class AbstractValidator<T extends Annotation>
implements ConstraintValidator<T, Object> {
    @CheckForNull
    protected Object getPropertyValue(@Nonnull Object object, @Nonnull String propertyName) throws IllegalArgumentException, IllegalAccessException, InvocationTargetException {
        Method method = this.getGetter(object.getClass(), propertyName);
        return method.invoke(object, (Object[])null);
    }

    @Nonnull
    private String toMethodName(@Nonnull String methodPrefix, @Nonnull String propertyName) {
        return methodPrefix + propertyName.substring(0, 1).toUpperCase(Locale.ENGLISH) + propertyName.substring(1);
    }

    @Nonnull
    private Method getGetter(@Nonnull Class<?> clazz, @Nonnull String property) {
        Method getter;
        String get = this.toMethodName("get", property);
        String is = this.toMethodName("is", property);
        try {
            getter = clazz.getMethod(get, new Class[0]);
        }
        catch (NoSuchMethodException noSuchMethodException) {
            try {
                getter = clazz.getMethod(is, new Class[0]);
            }
            catch (NoSuchMethodException noSuchMethodException2) {
                throw new RuntimeException("Getter for '" + clazz.getSimpleName() + '#' + property + "' not found.", noSuchMethodException2);
            }
            catch (SecurityException securityException) {
                throw new RuntimeException("Method '" + clazz.getSimpleName() + '#' + is + "()' is protected by the security manager.");
            }
        }
        catch (SecurityException securityException) {
            try {
                getter = clazz.getMethod(is, new Class[0]);
            }
            catch (NoSuchMethodException noSuchMethodException) {
                throw new RuntimeException("Method '" + clazz.getSimpleName() + '#' + get + "()' is protected by the security manager.");
            }
            catch (SecurityException securityException2) {
                throw new RuntimeException("Methods '" + clazz.getSimpleName() + '#' + get + "()' and " + clazz.getSimpleName() + '#' + is + "()' are protected by the security manager.");
            }
        }
        return getter;
    }
}

