/*
 * Decompiled with CFR 0.152.
 */
package de.javagl.viewer.selection;

import java.awt.Shape;
import java.awt.geom.AffineTransform;
import java.awt.geom.Point2D;
import java.util.ArrayList;
import java.util.List;
import java.util.function.IntFunction;
import java.util.function.IntToDoubleFunction;

public class Selectors {
    public static List<Integer> computeShapeIndicesForPoint(Point2D point, AffineTransform worldToScreen, int numPoints, IntToDoubleFunction xFunction, IntToDoubleFunction yFunction, IntFunction<? extends Shape> shapeFunction) {
        Point2D.Double worldPoint = new Point2D.Double();
        Point2D.Double screenPoint = new Point2D.Double();
        Point2D.Double relativeScreenPoint = new Point2D.Double();
        ArrayList<Integer> indices = new ArrayList<Integer>();
        for (int i = 0; i < numPoints; ++i) {
            double x = xFunction.applyAsDouble(i);
            double y = yFunction.applyAsDouble(i);
            ((Point2D)worldPoint).setLocation(x, y);
            worldToScreen.transform(worldPoint, screenPoint);
            Shape shape = shapeFunction.apply(i);
            ((Point2D)relativeScreenPoint).setLocation(point.getX() - ((Point2D)screenPoint).getX(), point.getY() - ((Point2D)screenPoint).getY());
            if (!shape.contains(relativeScreenPoint)) continue;
            indices.add(i);
        }
        return indices;
    }

    public static List<Point2D> computePointsForPoint(Point2D point, AffineTransform worldToScreen, Iterable<? extends Point2D> points, double pointRadius) {
        ArrayList<Point2D> result = new ArrayList<Point2D>();
        double rr = pointRadius * pointRadius;
        Point2D.Double screenPoint = new Point2D.Double();
        for (Point2D point2D : points) {
            worldToScreen.transform(point2D, screenPoint);
            double ds = screenPoint.distanceSq(point);
            if (!(ds <= rr)) continue;
            result.add(point2D);
        }
        return result;
    }

    public static List<Integer> computePointIndicesForPoint(Point2D point, AffineTransform worldToScreen, int numPoints, IntToDoubleFunction xFunction, IntToDoubleFunction yFunction, double pointRadius) {
        double rr = pointRadius * pointRadius;
        Point2D.Double worldPoint = new Point2D.Double();
        Point2D.Double screenPoint = new Point2D.Double();
        ArrayList<Integer> indices = new ArrayList<Integer>();
        for (int i = 0; i < numPoints; ++i) {
            double x = xFunction.applyAsDouble(i);
            double y = yFunction.applyAsDouble(i);
            ((Point2D)worldPoint).setLocation(x, y);
            worldToScreen.transform(worldPoint, screenPoint);
            double ds = screenPoint.distanceSq(point);
            if (!(ds <= rr)) continue;
            indices.add(i);
        }
        return indices;
    }

    public static List<Point2D> computePointsForShape(Shape shape, AffineTransform worldToScreen, Iterable<? extends Point2D> points) {
        ArrayList<Point2D> result = new ArrayList<Point2D>();
        Point2D.Double screenPoint = new Point2D.Double();
        for (Point2D point2D : points) {
            worldToScreen.transform(point2D, screenPoint);
            if (!shape.contains(screenPoint)) continue;
            result.add(point2D);
        }
        return result;
    }

    public static List<Integer> computePointIndicesForShape(Shape shape, AffineTransform worldToScreen, int numPoints, IntToDoubleFunction xFunction, IntToDoubleFunction yFunction) {
        Point2D.Double worldPoint = new Point2D.Double();
        Point2D.Double screenPoint = new Point2D.Double();
        ArrayList<Integer> indices = new ArrayList<Integer>();
        for (int i = 0; i < numPoints; ++i) {
            double x = xFunction.applyAsDouble(i);
            double y = yFunction.applyAsDouble(i);
            ((Point2D)worldPoint).setLocation(x, y);
            worldToScreen.transform(worldPoint, screenPoint);
            if (!shape.contains(screenPoint)) continue;
            indices.add(i);
        }
        return indices;
    }

    private Selectors() {
    }
}

