/*
 * Decompiled with CFR 0.152.
 */
package de.javagl.viewer.selection;

import de.javagl.viewer.Painter;
import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Graphics2D;
import java.awt.Shape;
import java.awt.Stroke;
import java.awt.geom.AffineTransform;
import java.awt.geom.Path2D;
import java.util.Objects;
import java.util.function.Supplier;

class SelectionShapePainter
implements Painter {
    private final Supplier<? extends Shape> selectionShapeSupplier;
    private final float strokeWidth = 1.0f;
    private final float dash = 5.0f;
    private final Stroke strokeA = new BasicStroke(1.0f, 0, 0, 1.0f, new float[]{5.0f}, 0.0f);
    private final Stroke strokeB = new BasicStroke(1.0f, 0, 0, 1.0f, new float[]{5.0f}, 5.0f);
    private final Color fillColor = new Color(0, 255, 0, 32);

    SelectionShapePainter(Supplier<? extends Shape> selectionShapeSupplier) {
        this.selectionShapeSupplier = Objects.requireNonNull(selectionShapeSupplier, "The selectionShapeSupplier may not be null");
    }

    public void paint(Graphics2D g, AffineTransform worldToScreen, double w, double h) {
        Shape selectionShape = this.selectionShapeSupplier.get();
        if (selectionShape != null) {
            Path2D.Double paintedPath = new Path2D.Double(0);
            ((Path2D)paintedPath).append(selectionShape.getPathIterator(null), false);
            paintedPath.closePath();
            g.setColor(this.fillColor);
            g.fill(paintedPath);
            g.setStroke(this.strokeA);
            g.setColor(Color.BLACK);
            g.draw(paintedPath);
            g.setStroke(this.strokeB);
            g.setColor(Color.WHITE);
            g.draw(paintedPath);
        }
    }
}

