/*
 * Decompiled with CFR 0.152.
 */
package de.javagl.viewer.selection;

import de.javagl.selection.SelectionModel;
import de.javagl.viewer.InputEventPredicates;
import de.javagl.viewer.Painter;
import de.javagl.viewer.Viewer;
import de.javagl.viewer.selection.CollectionSelectionModelUpdater;
import de.javagl.viewer.selection.SelectionHandler;
import de.javagl.viewer.selection.SelectionModelUpdater;
import de.javagl.viewer.selection.SelectionShapePainter;
import de.javagl.viewer.selection.ShapeBasedSelector;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.event.MouseMotionListener;
import java.awt.geom.AffineTransform;
import java.awt.geom.Point2D;
import java.awt.geom.Rectangle2D;
import java.util.Collection;
import java.util.Objects;
import java.util.function.Predicate;

class RectangleSelectionHandler<T>
implements SelectionHandler<T> {
    private Viewer viewer;
    private SelectionModel<T> selectionModel;
    private final SelectionModelUpdater<T> selectionModelUpdater;
    private Point2D rectangleStart = null;
    private Rectangle2D selectionRectangle = null;
    private final Painter selectionShapePainter;
    private final ShapeBasedSelector<T> shapeBasedSelector;
    private Predicate<MouseEvent> selectPredicate = InputEventPredicates.button((int)1);
    private final MouseAdapter mouseAdapter = new MouseAdapter(){

        @Override
        public void mousePressed(MouseEvent e) {
            if (!RectangleSelectionHandler.this.selectPredicate.test(e)) {
                return;
            }
            RectangleSelectionHandler.this.rectangleStart = new Point2D.Double(e.getX(), e.getY());
            RectangleSelectionHandler.this.selectionRectangle = new Rectangle2D.Double(e.getX(), e.getY(), 0.0, 0.0);
            RectangleSelectionHandler.this.viewer.repaint();
        }

        @Override
        public void mouseDragged(MouseEvent e) {
            if (RectangleSelectionHandler.this.selectionRectangle != null) {
                double minX = Math.min(RectangleSelectionHandler.this.rectangleStart.getX(), (double)e.getX());
                double minY = Math.min(RectangleSelectionHandler.this.rectangleStart.getY(), (double)e.getY());
                double maxX = Math.max(RectangleSelectionHandler.this.rectangleStart.getX(), (double)e.getX());
                double maxY = Math.max(RectangleSelectionHandler.this.rectangleStart.getY(), (double)e.getY());
                RectangleSelectionHandler.this.selectionRectangle.setRect(minX, minY, maxX - minX, maxY - minY);
                RectangleSelectionHandler.this.viewer.repaint();
            }
        }

        @Override
        public void mouseReleased(MouseEvent e) {
            if (RectangleSelectionHandler.this.selectionRectangle != null) {
                AffineTransform worldToScreen = RectangleSelectionHandler.this.viewer.getWorldToScreen();
                Collection affectedElements = RectangleSelectionHandler.this.shapeBasedSelector.computeElementsForShape(RectangleSelectionHandler.this.selectionRectangle, worldToScreen);
                RectangleSelectionHandler.this.selectionModelUpdater.updateSelectionModel(e, RectangleSelectionHandler.this.selectionModel, affectedElements);
            }
            RectangleSelectionHandler.this.selectionRectangle = null;
            RectangleSelectionHandler.this.viewer.repaint();
        }
    };

    RectangleSelectionHandler(ShapeBasedSelector<T> shapeBasedSelector) {
        this.shapeBasedSelector = Objects.requireNonNull(shapeBasedSelector, "The shapeBasedSelector may not be null");
        this.selectionShapePainter = new SelectionShapePainter(() -> this.selectionRectangle);
        this.selectionModelUpdater = new CollectionSelectionModelUpdater();
    }

    @Override
    public void connect(Viewer viewer, SelectionModel<T> selectionModel) {
        if (viewer == null && selectionModel == null) {
            this.disconnect();
            return;
        }
        this.viewer = Objects.requireNonNull(viewer, "The viewer may not be null");
        this.selectionModel = Objects.requireNonNull(selectionModel, "The selectionModel may not be null");
        viewer.addMouseListener((MouseListener)this.mouseAdapter);
        viewer.addMouseMotionListener((MouseMotionListener)this.mouseAdapter);
        viewer.addPainter(this.selectionShapePainter);
    }

    @Override
    public void disconnect() {
        if (this.viewer != null) {
            this.viewer.removeMouseListener((MouseListener)this.mouseAdapter);
            this.viewer.removeMouseMotionListener((MouseMotionListener)this.mouseAdapter);
            this.viewer.removePainter(this.selectionShapePainter);
            this.viewer = null;
        }
        this.selectionModel = null;
    }
}

