/*
 * Decompiled with CFR 0.152.
 */
package de.javagl.viewer.selection;

import de.javagl.selection.SelectionModel;
import de.javagl.viewer.InputEventPredicates;
import de.javagl.viewer.Painter;
import de.javagl.viewer.Viewer;
import de.javagl.viewer.selection.CollectionSelectionModelUpdater;
import de.javagl.viewer.selection.SelectionHandler;
import de.javagl.viewer.selection.SelectionModelUpdater;
import de.javagl.viewer.selection.SelectionShapePainter;
import de.javagl.viewer.selection.ShapeBasedSelector;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.event.MouseMotionListener;
import java.awt.geom.AffineTransform;
import java.awt.geom.Path2D;
import java.util.Collection;
import java.util.Objects;
import java.util.function.Predicate;

class LassoSelectionHandler<T>
implements SelectionHandler<T> {
    private Viewer viewer;
    private SelectionModel<T> selectionModel;
    private final SelectionModelUpdater<T> selectionModelUpdater;
    private Path2D selectionPath = null;
    private final Painter selectionShapePainter;
    private final ShapeBasedSelector<T> shapeBasedSelector;
    private final Predicate<MouseEvent> selectPredicate = InputEventPredicates.button((int)1);
    private final MouseAdapter mouseAdapter = new MouseAdapter(){

        @Override
        public void mousePressed(MouseEvent e) {
            if (!LassoSelectionHandler.this.selectPredicate.test(e)) {
                return;
            }
            LassoSelectionHandler.this.selectionPath = new Path2D.Double(0);
            LassoSelectionHandler.this.selectionPath.moveTo(e.getX(), e.getY());
            LassoSelectionHandler.this.viewer.repaint();
        }

        @Override
        public void mouseDragged(MouseEvent e) {
            if (LassoSelectionHandler.this.selectionPath != null) {
                LassoSelectionHandler.this.selectionPath.lineTo(e.getX(), e.getY());
                LassoSelectionHandler.this.viewer.repaint();
            }
        }

        @Override
        public void mouseReleased(MouseEvent e) {
            if (LassoSelectionHandler.this.selectionPath != null) {
                AffineTransform worldToScreen = LassoSelectionHandler.this.viewer.getWorldToScreen();
                Collection affectedElements = LassoSelectionHandler.this.shapeBasedSelector.computeElementsForShape(LassoSelectionHandler.this.selectionPath, worldToScreen);
                LassoSelectionHandler.this.selectionModelUpdater.updateSelectionModel(e, LassoSelectionHandler.this.selectionModel, affectedElements);
            }
            LassoSelectionHandler.this.selectionPath = null;
            LassoSelectionHandler.this.viewer.repaint();
        }
    };

    LassoSelectionHandler(ShapeBasedSelector<T> shapeBasedSelector) {
        this.shapeBasedSelector = Objects.requireNonNull(shapeBasedSelector, "The shapeBasedSelector may not be null");
        this.selectionShapePainter = new SelectionShapePainter(() -> this.selectionPath);
        this.selectionModelUpdater = new CollectionSelectionModelUpdater();
    }

    @Override
    public void connect(Viewer viewer, SelectionModel<T> selectionModel) {
        if (viewer == null && selectionModel == null) {
            this.disconnect();
            return;
        }
        this.viewer = Objects.requireNonNull(viewer, "The viewer may not be null");
        this.selectionModel = Objects.requireNonNull(selectionModel, "The selectionModel may not be null");
        viewer.addMouseListener((MouseListener)this.mouseAdapter);
        viewer.addMouseMotionListener((MouseMotionListener)this.mouseAdapter);
        viewer.addPainter(this.selectionShapePainter);
    }

    @Override
    public void disconnect() {
        if (this.viewer != null) {
            this.viewer.removeMouseListener((MouseListener)this.mouseAdapter);
            this.viewer.removeMouseMotionListener((MouseMotionListener)this.mouseAdapter);
            this.viewer.removePainter(this.selectionShapePainter);
            this.viewer = null;
        }
        this.selectionModel = null;
    }
}

