/*
 * Decompiled with CFR 0.152.
 */
package de.javagl.viewer.selection;

import de.javagl.selection.SelectionModel;
import de.javagl.viewer.InputEventPredicates;
import de.javagl.viewer.Viewer;
import de.javagl.viewer.selection.PointBasedSelector;
import de.javagl.viewer.selection.SelectionHandler;
import de.javagl.viewer.selection.SelectionModelUpdater;
import de.javagl.viewer.selection.ToggleSelectionModelUpdater;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.event.MouseMotionListener;
import java.awt.geom.AffineTransform;
import java.util.Collection;
import java.util.Objects;
import java.util.function.Predicate;

class ClickSelectionHandler<T>
implements SelectionHandler<T> {
    private Viewer viewer;
    private SelectionModel<T> selectionModel;
    private final SelectionModelUpdater<T> selectionModelUpdater;
    private final PointBasedSelector<T> pointBasedSelector;
    private final Predicate<MouseEvent> selectPredicate = InputEventPredicates.button((int)1);
    private final MouseAdapter mouseAdapter = new MouseAdapter(){

        @Override
        public void mouseClicked(MouseEvent e) {
            if (!ClickSelectionHandler.this.selectPredicate.test(e)) {
                return;
            }
            AffineTransform worldToScreen = ClickSelectionHandler.this.viewer.getWorldToScreen();
            Collection affectedElements = ClickSelectionHandler.this.pointBasedSelector.computeElementsForPoint(e.getPoint(), worldToScreen);
            ClickSelectionHandler.this.selectionModelUpdater.updateSelectionModel(e, ClickSelectionHandler.this.selectionModel, affectedElements);
            ClickSelectionHandler.this.viewer.repaint();
        }
    };

    public ClickSelectionHandler(PointBasedSelector<T> pointBasedSelector) {
        this.pointBasedSelector = Objects.requireNonNull(pointBasedSelector, "The pointBasedSelector may not be null");
        this.selectionModelUpdater = new ToggleSelectionModelUpdater();
    }

    @Override
    public void connect(Viewer viewer, SelectionModel<T> selectionModel) {
        if (viewer == null && selectionModel == null) {
            this.disconnect();
            return;
        }
        this.viewer = Objects.requireNonNull(viewer, "The viewer may not be null");
        this.selectionModel = Objects.requireNonNull(selectionModel, "The selectionModel may not be null");
        viewer.addMouseListener((MouseListener)this.mouseAdapter);
        viewer.addMouseMotionListener((MouseMotionListener)this.mouseAdapter);
    }

    @Override
    public void disconnect() {
        if (this.viewer != null) {
            this.viewer.removeMouseListener((MouseListener)this.mouseAdapter);
            this.viewer.removeMouseMotionListener((MouseMotionListener)this.mouseAdapter);
            this.viewer = null;
        }
        this.selectionModel = null;
    }
}

