/*
 * Decompiled with CFR 0.152.
 */
package de.javagl.viewer.glyphs;

import java.awt.Shape;
import java.awt.geom.Ellipse2D;
import java.awt.geom.Path2D;
import java.awt.geom.Rectangle2D;

public class TickShapes {
    public static Shape xShape(double size) {
        Path2D.Double p = new Path2D.Double();
        double r = size * 0.5;
        ((Path2D)p).moveTo(-r, -r);
        ((Path2D)p).lineTo(r, r);
        ((Path2D)p).moveTo(r, -r);
        ((Path2D)p).lineTo(-r, r);
        return p;
    }

    public static Shape cross(double size) {
        Path2D.Double p = new Path2D.Double();
        double r = size * 0.5;
        ((Path2D)p).moveTo(-r, 0.0);
        ((Path2D)p).lineTo(r, 0.0);
        ((Path2D)p).moveTo(0.0, -r);
        ((Path2D)p).lineTo(0.0, r);
        return p;
    }

    public static Shape diamond(double size) {
        Path2D.Double p = new Path2D.Double();
        double r = size * 0.5;
        ((Path2D)p).moveTo(-r, 0.0);
        ((Path2D)p).lineTo(0.0, -r);
        ((Path2D)p).lineTo(r, 0.0);
        ((Path2D)p).lineTo(0.0, r);
        p.closePath();
        return p;
    }

    public static Shape circle(double size) {
        double r = size * 0.5;
        return new Ellipse2D.Double(-r, -r, size, size);
    }

    public static Shape square(double size) {
        double r = size * 0.5;
        return new Rectangle2D.Double(-r, -r, size, size);
    }

    public static Shape triangle(double size) {
        Path2D.Double p = new Path2D.Double();
        double r = size * 0.5;
        ((Path2D)p).moveTo(-r, r);
        ((Path2D)p).lineTo(r, r);
        ((Path2D)p).lineTo(0.0, -r);
        p.closePath();
        return p;
    }

    private TickShapes() {
    }
}

