/*
 * Decompiled with CFR 0.152.
 */
package de.javagl.viewer.glyphs;

import de.javagl.viewer.glyphs.ScatterChart;
import java.awt.Paint;
import java.awt.Shape;
import java.awt.geom.Point2D;
import java.awt.geom.Rectangle2D;
import java.util.List;
import java.util.Objects;

public class ScatterCharts {
    public static ScatterChart create(final List<? extends Point2D> points, final Paint paint, final Shape shape) {
        Objects.requireNonNull(points, "The points are null");
        return new ScatterChart(){

            @Override
            public int getNumPoints() {
                return points.size();
            }

            @Override
            public double getPointX(int index) {
                return ((Point2D)points.get(index)).getX();
            }

            @Override
            public double getPointY(int index) {
                return ((Point2D)points.get(index)).getY();
            }

            @Override
            public Paint getPaint(int index) {
                return paint;
            }

            @Override
            public Shape getShape(int index) {
                return shape;
            }
        };
    }

    public static ScatterChart create(final List<? extends Number> xCoordinates, final List<? extends Number> yCoordinates, final Paint paint, final Shape shape) {
        Objects.requireNonNull(xCoordinates, "The xCoordinates are null");
        Objects.requireNonNull(yCoordinates, "The yCoordinates are null");
        if (xCoordinates.size() != yCoordinates.size()) {
            throw new IllegalArgumentException("The xCoordinates have a size of " + xCoordinates.size() + " and the xCoordinates have a size of " + yCoordinates.size());
        }
        return new ScatterChart(){

            @Override
            public int getNumPoints() {
                return xCoordinates.size();
            }

            @Override
            public double getPointX(int index) {
                return ((Number)xCoordinates.get(index)).doubleValue();
            }

            @Override
            public double getPointY(int index) {
                return ((Number)yCoordinates.get(index)).doubleValue();
            }

            @Override
            public Paint getPaint(int index) {
                return paint;
            }

            @Override
            public Shape getShape(int index) {
                return shape;
            }
        };
    }

    public static double computeMinX(ScatterChart scatterChart) {
        double min = Double.POSITIVE_INFINITY;
        int n = scatterChart.getNumPoints();
        for (int i = 0; i < n; ++i) {
            min = Math.min(min, scatterChart.getPointX(i));
        }
        return min;
    }

    public static double computeMinY(ScatterChart scatterChart) {
        double min = Double.POSITIVE_INFINITY;
        int n = scatterChart.getNumPoints();
        for (int i = 0; i < n; ++i) {
            min = Math.min(min, scatterChart.getPointY(i));
        }
        return min;
    }

    public static double computeMaxX(ScatterChart scatterChart) {
        double max = Double.NEGATIVE_INFINITY;
        int n = scatterChart.getNumPoints();
        for (int i = 0; i < n; ++i) {
            max = Math.max(max, scatterChart.getPointX(i));
        }
        return max;
    }

    public static double computeMaxY(ScatterChart scatterChart) {
        double max = Double.NEGATIVE_INFINITY;
        int n = scatterChart.getNumPoints();
        for (int i = 0; i < n; ++i) {
            max = Math.max(max, scatterChart.getPointY(i));
        }
        return max;
    }

    static double getMinX(double optionalMin, ScatterChart scatterChart) {
        if (!Double.isNaN(optionalMin)) {
            return optionalMin;
        }
        if (scatterChart.getNumPoints() == 0) {
            return 0.0;
        }
        return ScatterCharts.computeMinX(scatterChart);
    }

    static double getMinY(double optionalMin, ScatterChart scatterChart) {
        if (!Double.isNaN(optionalMin)) {
            return optionalMin;
        }
        if (scatterChart.getNumPoints() == 0) {
            return 0.0;
        }
        return ScatterCharts.computeMinY(scatterChart);
    }

    static double getMaxX(double optionalMax, ScatterChart scatterChart) {
        if (!Double.isNaN(optionalMax)) {
            return optionalMax;
        }
        if (scatterChart.getNumPoints() == 0) {
            return 1.0;
        }
        return ScatterCharts.computeMaxX(scatterChart);
    }

    static double getMaxY(double optionalMax, ScatterChart scatterChart) {
        if (!Double.isNaN(optionalMax)) {
            return optionalMax;
        }
        if (scatterChart.getNumPoints() == 0) {
            return 1.0;
        }
        return ScatterCharts.computeMaxY(scatterChart);
    }

    static Rectangle2D computeBounds(ScatterChart scatterChart) {
        double minX = ScatterCharts.computeMinX(scatterChart);
        double minY = ScatterCharts.computeMinY(scatterChart);
        double maxX = ScatterCharts.computeMaxX(scatterChart);
        double maxY = ScatterCharts.computeMaxY(scatterChart);
        return new Rectangle2D.Double(minX, minY, maxX - minX, maxY - minY);
    }

    private ScatterCharts() {
    }
}

