/*
 * Decompiled with CFR 0.152.
 */
package de.javagl.viewer.glyphs;

import de.javagl.geom.Lines;
import de.javagl.viewer.ObjectPainter;
import de.javagl.viewer.glyphs.ScatterChart;
import java.awt.Graphics2D;
import java.awt.Paint;
import java.awt.Shape;
import java.awt.Stroke;
import java.awt.geom.AffineTransform;
import java.awt.geom.Line2D;
import java.awt.geom.Point2D;

public final class ScatterChartPainter
implements ObjectPainter<ScatterChart> {
    private static final Point2D TEMP_POINT = new Point2D.Double();
    private static final Line2D TEMP_LINE = new Line2D.Double();
    private Paint linePaint = null;
    private Stroke lineStroke = null;

    public void setLinePaint(Paint linePaint) {
        this.linePaint = linePaint;
    }

    public void setLineStroke(Stroke lineStroke) {
        this.lineStroke = lineStroke;
    }

    public void paint(Graphics2D g, AffineTransform worldToScreen, double w, double h, ScatterChart scatterChart) {
        if (scatterChart == null) {
            return;
        }
        this.paintLines(g, worldToScreen, w, h, scatterChart);
        this.paintPoints(g, worldToScreen, w, h, scatterChart);
    }

    private void paintLines(Graphics2D g, AffineTransform worldToScreen, double w, double h, ScatterChart scatterChart) {
        if (this.linePaint == null || this.lineStroke == null) {
            return;
        }
        g.setPaint(this.linePaint);
        g.setStroke(this.lineStroke);
        double prevX = 0.0;
        double prevY = 0.0;
        int n = scatterChart.getNumPoints();
        for (int i = 0; i < n; ++i) {
            double x = scatterChart.getPointX(i);
            double y = scatterChart.getPointY(i);
            if (i > 0) {
                TEMP_LINE.setLine(prevX, prevY, x, y);
                Lines.transform((AffineTransform)worldToScreen, (Line2D)TEMP_LINE, (Line2D)TEMP_LINE);
                g.draw(TEMP_LINE);
            }
            prevX = x;
            prevY = y;
        }
    }

    private void paintPoints(Graphics2D g, AffineTransform worldToScreen, double w, double h, ScatterChart scatterChart) {
        int n = scatterChart.getNumPoints();
        for (int i = 0; i < n; ++i) {
            Shape shape;
            Paint paint = scatterChart.getPaint(i);
            if (paint == null || (shape = scatterChart.getShape(i)) == null) continue;
            double x = scatterChart.getPointX(i);
            double y = scatterChart.getPointY(i);
            AffineTransform oldAT = g.getTransform();
            TEMP_POINT.setLocation(x, y);
            worldToScreen.transform(TEMP_POINT, TEMP_POINT);
            g.translate(TEMP_POINT.getX(), TEMP_POINT.getY());
            g.setPaint(paint);
            g.draw(shape);
            g.setTransform(oldAT);
        }
    }
}

