/*
 * Decompiled with CFR 0.152.
 */
package de.javagl.viewer.glyphs;

import de.javagl.geom.AffineTransforms;
import de.javagl.viewer.ObjectPainter;
import de.javagl.viewer.glyphs.ScatterChart;
import de.javagl.viewer.glyphs.ScatterChartMatrix;
import de.javagl.viewer.glyphs.ScatterChartPainter;
import de.javagl.viewer.glyphs.ScatterCharts;
import de.javagl.viewer.painters.GeneralLabelPainterPredicate;
import de.javagl.viewer.painters.LabelPainter;
import java.awt.Color;
import java.awt.Font;
import java.awt.Graphics2D;
import java.awt.Paint;
import java.awt.geom.AffineTransform;
import java.awt.geom.Rectangle2D;
import java.util.function.Predicate;

public final class ScatterChartMatrixPainter
implements ObjectPainter<ScatterChartMatrix> {
    private static final AffineTransform TEMP_TRANSFORM = new AffineTransform();
    private Paint borderPaint = null;
    private double borderSpacingTop = 0.08;
    private double borderSpacingBottom = 0.025;
    private double borderSpacingLeft = 0.025;
    private double borderSpacingRight = 0.025;
    private final LabelPainter labelPainter = new LabelPainter();
    private final ScatterChartPainter scatterChartPainter;
    private final GeneralLabelPainterPredicate generalLabelPainterPredicate;

    public ScatterChartMatrixPainter() {
        this.labelPainter.setLabelAnchor(0.0, 0.0);
        this.labelPainter.setLabelLocation(this.borderSpacingLeft, 0.0);
        this.labelPainter.setPaint((Paint)Color.BLACK);
        this.labelPainter.setFont(new Font("Dialog", 0, 9).deriveFont(0.06f));
        this.labelPainter.setTransformingLabels(true);
        this.generalLabelPainterPredicate = new GeneralLabelPainterPredicate();
        this.labelPainter.setLabelPaintingCondition((Predicate)this.generalLabelPainterPredicate);
        this.scatterChartPainter = new ScatterChartPainter();
    }

    public ScatterChartPainter getScatterChartPainter() {
        return this.scatterChartPainter;
    }

    public void paint(Graphics2D g, AffineTransform worldToScreen, double w, double h, ScatterChartMatrix scatterChartMatrix) {
        if (scatterChartMatrix == null) {
            return;
        }
        int n = scatterChartMatrix.getNumCharts();
        double cellSize = 1.0 / (double)n;
        double chartScaleX = 1.0 - this.borderSpacingLeft - this.borderSpacingRight;
        double chartScaleY = 1.0 - this.borderSpacingTop - this.borderSpacingBottom;
        for (int r = 0; r < n; ++r) {
            for (int c = 0; c < n; ++c) {
                ScatterChart scatterChart = scatterChartMatrix.getChart(r, c);
                if (scatterChart == null) continue;
                TEMP_TRANSFORM.setTransform(worldToScreen);
                TEMP_TRANSFORM.translate((double)c * cellSize, (double)r * cellSize);
                TEMP_TRANSFORM.scale(cellSize, cellSize);
                String label = scatterChartMatrix.getLabel(r, c);
                if (label != null) {
                    double availableScreenSpaceY = AffineTransforms.computeDistanceY((AffineTransform)TEMP_TRANSFORM, (double)this.borderSpacingTop);
                    this.generalLabelPainterPredicate.setMaximumScreenHeight(availableScreenSpaceY);
                    this.labelPainter.paint(g, TEMP_TRANSFORM, w, h, label);
                }
                TEMP_TRANSFORM.translate(this.borderSpacingLeft, this.borderSpacingTop);
                TEMP_TRANSFORM.scale(chartScaleX, chartScaleY);
                g.setColor(Color.LIGHT_GRAY);
                g.draw(TEMP_TRANSFORM.createTransformedShape(new Rectangle2D.Double(0.0, 0.0, 1.0, 1.0)));
                Rectangle2D bounds = ScatterCharts.computeBounds(scatterChart);
                AffineTransform at = AffineTransforms.getScaleInstance((Rectangle2D)bounds, null);
                AffineTransforms.invert((AffineTransform)at, (AffineTransform)at);
                TEMP_TRANSFORM.concatenate(at);
                this.scatterChartPainter.paint(g, TEMP_TRANSFORM, w, h, scatterChart);
            }
        }
    }
}

