/*
 * Decompiled with CFR 0.152.
 */
package de.javagl.viewer.glyphs;

import de.javagl.viewer.glyphs.LineChart;
import java.awt.BasicStroke;
import java.awt.Paint;
import java.awt.Shape;
import java.awt.Stroke;
import java.util.List;

public class LineCharts {
    private static final Stroke DEFAULT_STROKE = new BasicStroke(1.0f);

    public static LineChart createFromList(List<? extends Number> list, Paint paint) {
        return LineCharts.createFromList(list, paint, DEFAULT_STROKE, null);
    }

    public static LineChart createFromList(final List<? extends Number> list, final Paint paint, final Stroke stroke, final Shape tickShape) {
        return new LineChart(){

            @Override
            public int getNumPoints() {
                return list.size();
            }

            @Override
            public double getValue(int index) {
                Number number = (Number)list.get(index);
                if (number == null) {
                    return 0.0;
                }
                return number.doubleValue();
            }

            @Override
            public Paint getPaint() {
                return paint;
            }

            @Override
            public Stroke getStroke() {
                return stroke;
            }

            @Override
            public Shape getTickShape() {
                return tickShape;
            }
        };
    }

    public static double computeMin(LineChart lineChart) {
        double min = Double.POSITIVE_INFINITY;
        int n = lineChart.getNumPoints();
        for (int i = 0; i < n; ++i) {
            min = Math.min(min, lineChart.getValue(i));
        }
        return min;
    }

    public static double computeMax(LineChart lineChart) {
        double max = Double.NEGATIVE_INFINITY;
        int n = lineChart.getNumPoints();
        for (int i = 0; i < n; ++i) {
            max = Math.max(max, lineChart.getValue(i));
        }
        return max;
    }

    public static double computeMin(Iterable<? extends LineChart> lineCharts) {
        double min = Double.POSITIVE_INFINITY;
        for (LineChart lineChart : lineCharts) {
            min = Math.min(min, LineCharts.computeMin(lineChart));
        }
        return min;
    }

    public static double computeMax(Iterable<? extends LineChart> lineCharts) {
        double max = Double.NEGATIVE_INFINITY;
        for (LineChart lineChart : lineCharts) {
            max = Math.max(max, LineCharts.computeMax(lineChart));
        }
        return max;
    }

    static double getMin(double optionalMin, LineChart lineChart) {
        if (!Double.isNaN(optionalMin)) {
            return optionalMin;
        }
        double min = LineCharts.computeMin(lineChart);
        if (!Double.isFinite(min)) {
            return 0.0;
        }
        return min;
    }

    static double getMax(double optionalMax, LineChart lineChart) {
        if (!Double.isNaN(optionalMax)) {
            return optionalMax;
        }
        double max = LineCharts.computeMax(lineChart);
        if (!Double.isFinite(max)) {
            return 1.0;
        }
        return max;
    }

    static double getMin(double optionalMin, Iterable<? extends LineChart> lineCharts) {
        if (!Double.isNaN(optionalMin)) {
            return optionalMin;
        }
        double min = LineCharts.computeMin(lineCharts);
        if (!Double.isFinite(min)) {
            return 0.0;
        }
        return min;
    }

    static double getMax(double optionalMax, Iterable<? extends LineChart> lineCharts) {
        if (!Double.isNaN(optionalMax)) {
            return optionalMax;
        }
        double max = LineCharts.computeMax(lineCharts);
        if (!Double.isFinite(max)) {
            return 1.0;
        }
        return max;
    }

    private LineCharts() {
    }
}

