/*
 * Decompiled with CFR 0.152.
 */
package de.javagl.viewer.glyphs;

import de.javagl.viewer.ObjectPainter;
import de.javagl.viewer.glyphs.LineChart;
import java.awt.BasicStroke;
import java.awt.Graphics2D;
import java.awt.Paint;
import java.awt.Shape;
import java.awt.Stroke;
import java.awt.geom.AffineTransform;
import java.awt.geom.Path2D;
import java.awt.geom.Point2D;

public final class LineChartPainter
implements ObjectPainter<LineChart> {
    private static final Point2D TEMP_POINT = new Point2D.Double();
    private static final Stroke DEFAULT_STROKE = new BasicStroke(1.0f);

    public void paint(Graphics2D g, AffineTransform worldToScreen, double w, double h, LineChart lineChart) {
        if (lineChart == null) {
            return;
        }
        Paint paint = lineChart.getPaint();
        if (paint == null) {
            return;
        }
        g.setPaint(paint);
        this.paintLine(g, worldToScreen, lineChart);
        this.paintTickMarks(g, worldToScreen, lineChart);
    }

    private void paintLine(Graphics2D g, AffineTransform worldToScreen, LineChart lineChart) {
        Stroke stroke = lineChart.getStroke();
        if (stroke != null) {
            Path2D.Double p = new Path2D.Double();
            for (int i = 0; i < lineChart.getNumPoints(); ++i) {
                double value;
                double worldX = i;
                double worldY = value = lineChart.getValue(i);
                if (i == 0) {
                    ((Path2D)p).moveTo(worldX, worldY);
                    continue;
                }
                ((Path2D)p).lineTo(worldX, worldY);
            }
            g.setStroke(stroke);
            g.draw(worldToScreen.createTransformedShape(p));
        }
    }

    private void paintTickMarks(Graphics2D g, AffineTransform worldToScreen, LineChart lineChart) {
        Shape tickShape = lineChart.getTickShape();
        if (tickShape != null) {
            Stroke stroke = lineChart.getStroke();
            if (stroke != null) {
                g.setStroke(stroke);
            } else {
                g.setStroke(DEFAULT_STROKE);
            }
            for (int i = 0; i < lineChart.getNumPoints(); ++i) {
                double value;
                double worldX = i;
                double worldY = value = lineChart.getValue(i);
                AffineTransform oldAT = g.getTransform();
                TEMP_POINT.setLocation(worldX, worldY);
                worldToScreen.transform(TEMP_POINT, TEMP_POINT);
                g.translate(TEMP_POINT.getX(), TEMP_POINT.getY());
                g.draw(tickShape);
                g.setTransform(oldAT);
            }
        }
    }
}

