/*
 * Decompiled with CFR 0.152.
 */
package de.javagl.viewer.glyphs;

import de.javagl.geom.AffineTransforms;
import de.javagl.viewer.Painter;
import java.awt.Graphics2D;
import java.awt.geom.AffineTransform;

public final class GridLayoutPainter
implements Painter {
    private static final AffineTransform TEMP_TRANSFORM = new AffineTransform();
    private final int cellsX;
    private final int cellsY;
    private double relativeCellBorderSizeX0;
    private double relativeCellBorderSizeY0;
    private double relativeCellBorderSizeX1;
    private double relativeCellBorderSizeY1;
    private final Painter[][] delegates;
    private final AffineTransform delegateWorldToScreen;

    public GridLayoutPainter(int cellsX, int cellsY) {
        this(cellsX, cellsY, 0.0, 0.0);
    }

    public GridLayoutPainter(int cellsX, int cellsY, double relativeCellBorderSizeX, double relativeCellBorderSizeY) {
        if (cellsX <= 0) {
            throw new IllegalArgumentException("The value of cellsX must be positive, but is " + cellsX);
        }
        if (cellsY <= 0) {
            throw new IllegalArgumentException("The value of cellsY must be positive, but is " + cellsY);
        }
        this.cellsX = cellsX;
        this.cellsY = cellsY;
        this.relativeCellBorderSizeX0 = relativeCellBorderSizeX;
        this.relativeCellBorderSizeY0 = relativeCellBorderSizeY;
        this.relativeCellBorderSizeX1 = relativeCellBorderSizeX;
        this.relativeCellBorderSizeY1 = relativeCellBorderSizeY;
        this.delegates = new Painter[cellsX][cellsY];
        this.delegateWorldToScreen = new AffineTransform();
    }

    public int getCellsX() {
        return this.cellsX;
    }

    public int getCellsY() {
        return this.cellsY;
    }

    public void setDelegate(int x, int y, Painter delegate) {
        this.delegates[x][y] = delegate;
    }

    public void paint(Graphics2D g, AffineTransform worldToScreen, double w, double h) {
        double stepSizeX = 1.0 / (double)this.cellsX;
        double stepSizeY = 1.0 / (double)this.cellsY;
        for (int y = 0; y < this.cellsY; ++y) {
            for (int x = 0; x < this.cellsX; ++x) {
                Painter delegate = this.delegates[x][y];
                if (delegate == null) continue;
                double x0 = (double)x * stepSizeX;
                double y0 = (double)y * stepSizeY;
                double x1 = x0 + stepSizeX;
                double y1 = y0 + stepSizeY;
                AffineTransforms.getScaleInstance((double)(x0 += this.relativeCellBorderSizeX0 * stepSizeX), (double)(y0 += this.relativeCellBorderSizeY0 * stepSizeY), (double)(x1 -= this.relativeCellBorderSizeX1 * stepSizeX), (double)(y1 -= this.relativeCellBorderSizeY1 * stepSizeY), (AffineTransform)TEMP_TRANSFORM);
                this.delegateWorldToScreen.setTransform(worldToScreen);
                this.delegateWorldToScreen.concatenate(TEMP_TRANSFORM);
                delegate.paint(g, this.delegateWorldToScreen, w, h);
            }
        }
    }
}

