/*
 * Decompiled with CFR 0.152.
 */
package de.javagl.viewer.glyphs;

import de.javagl.viewer.glyphs.BoxPlot;
import java.util.Arrays;
import java.util.Collection;
import java.util.stream.DoubleStream;

public class BoxPlots {
    public static BoxPlot create(DoubleStream stream) {
        double[] array = stream.toArray();
        Arrays.sort(array);
        double sum = 0.0;
        double min = Double.POSITIVE_INFINITY;
        double max = Double.NEGATIVE_INFINITY;
        for (int j = 0; j < array.length; ++j) {
            min = Math.min(min, array[j]);
            max = Math.max(max, array[j]);
            sum += array[j];
        }
        double mean = sum / (double)array.length;
        double lowerQuantile = BoxPlots.quantile(array, 0.25);
        double upperQuantile = BoxPlots.quantile(array, 0.75);
        double median = BoxPlots.quantile(array, 0.5);
        BoxPlot boxPlot = BoxPlots.create(min, lowerQuantile, median, upperQuantile, max, mean);
        return boxPlot;
    }

    private static double quantile(double[] sortedArray, double p) {
        if (sortedArray.length == 1) {
            return sortedArray[0];
        }
        double pos = p * (double)(sortedArray.length + 1);
        double floorPos = Math.floor(pos);
        double d = pos - floorPos;
        if (pos < 1.0) {
            return sortedArray[0];
        }
        if (pos >= (double)sortedArray.length) {
            return sortedArray[sortedArray.length - 1];
        }
        double lower = sortedArray[(int)floorPos - 1];
        double upper = sortedArray[(int)floorPos];
        return lower + d * (upper - lower);
    }

    public static BoxPlot create(double minimum, double lowerQuantile, double median, double upperQuantile, double maximum) {
        return BoxPlots.create(minimum, lowerQuantile, median, upperQuantile, maximum, Double.NaN);
    }

    public static BoxPlot create(final double minimum, final double lowerQuantile, final double median, final double upperQuantile, final double maximum, final double mean) {
        return new BoxPlot(){

            @Override
            public double getMinimum() {
                return minimum;
            }

            @Override
            public double getLowerQuantile() {
                return lowerQuantile;
            }

            @Override
            public double getMedian() {
                return median;
            }

            @Override
            public double getUpperQuantile() {
                return upperQuantile;
            }

            @Override
            public double getMaximum() {
                return maximum;
            }

            @Override
            public double getMean() {
                return mean;
            }
        };
    }

    public static double computeMin(Iterable<? extends BoxPlot> boxPlots) {
        double min = Double.POSITIVE_INFINITY;
        for (BoxPlot boxPlot : boxPlots) {
            min = Math.min(min, boxPlot.getMinimum());
        }
        return min;
    }

    public static double computeMax(Iterable<? extends BoxPlot> boxPlots) {
        double max = Double.NEGATIVE_INFINITY;
        for (BoxPlot boxPlot : boxPlots) {
            max = Math.max(max, boxPlot.getMaximum());
        }
        return max;
    }

    public static double getMin(double optionalMin, Collection<? extends BoxPlot> boxPlots) {
        if (!Double.isNaN(optionalMin)) {
            return optionalMin;
        }
        double min = Double.POSITIVE_INFINITY;
        for (BoxPlot boxPlot : boxPlots) {
            min = Math.min(min, boxPlot.getMinimum());
        }
        if (!Double.isFinite(min)) {
            return 0.0;
        }
        return min;
    }

    public static double getMax(double optionalMax, Collection<? extends BoxPlot> boxPlots) {
        if (!Double.isNaN(optionalMax)) {
            return optionalMax;
        }
        double max = Double.NEGATIVE_INFINITY;
        for (BoxPlot boxPlot : boxPlots) {
            max = Math.max(max, boxPlot.getMaximum());
        }
        if (!Double.isFinite(max)) {
            return 1.0;
        }
        return max;
    }

    private BoxPlots() {
    }
}

