/*
 * Decompiled with CFR 0.152.
 */
package de.javagl.viewer.glyphs;

import de.javagl.geom.AffineTransforms;
import de.javagl.geom.Lines;
import de.javagl.viewer.ObjectPainter;
import de.javagl.viewer.glyphs.BoxPlot;
import de.javagl.viewer.glyphs.TickShapes;
import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Graphics2D;
import java.awt.Paint;
import java.awt.Shape;
import java.awt.Stroke;
import java.awt.geom.AffineTransform;
import java.awt.geom.Line2D;
import java.awt.geom.Point2D;
import java.awt.geom.Rectangle2D;

public final class BoxPlotPainter
implements ObjectPainter<BoxPlot> {
    private static final Shape DOT_SHAPE = TickShapes.circle(4.0);
    private static final Rectangle2D TEMP_RECTANGLE = new Rectangle2D.Double();
    private static final Line2D TEMP_LINE = new Line2D.Double();
    private static final Point2D TEMP_POINT = new Point2D.Double();
    private static final Stroke DEFAULT_STROKE = new BasicStroke(1.0f);
    private static final Stroke BOLD_STROKE = new BasicStroke(2.0f);
    private final Paint boxFillPaint = new Color(240, 240, 240);
    private final Paint boxDrawPaint = new Color(100, 100, 100);
    private final Paint whiskerPaint = new Color(100, 100, 100);
    private final Paint medianPaint = new Color(40, 40, 40);
    private final Paint meanPaint = new Color(40, 40, 40);
    private final double relativeBoxWidth = 0.8;
    private final double relativeWhiskerWidth = 0.5;
    private double width = 1.0;

    public void setWidth(double width) {
        this.width = width;
    }

    public void paint(Graphics2D g, AffineTransform worldToScreen, double w, double h, BoxPlot boxPlot) {
        Stroke oldStroke = g.getStroke();
        g.setStroke(DEFAULT_STROKE);
        double minimum = boxPlot.getMinimum();
        double maximum = boxPlot.getMaximum();
        double lowerQuantile = boxPlot.getLowerQuantile();
        double upperQuantile = boxPlot.getUpperQuantile();
        double median = boxPlot.getMedian();
        double mean = boxPlot.getMean();
        double boxOffsetX = (this.width - 0.8 * this.width) * 0.5;
        TEMP_RECTANGLE.setRect(boxOffsetX, lowerQuantile, 0.8 * this.width, upperQuantile - lowerQuantile);
        if (this.boxFillPaint != null || this.boxDrawPaint != null) {
            Shape s = AffineTransforms.createTransformedShape((AffineTransform)worldToScreen, (Shape)TEMP_RECTANGLE);
            if (this.boxFillPaint != null) {
                g.setPaint(this.boxFillPaint);
                g.fill(s);
            }
            if (this.boxDrawPaint != null) {
                g.setPaint(this.boxDrawPaint);
                g.draw(s);
            }
        }
        if (this.whiskerPaint != null) {
            g.setPaint(this.whiskerPaint);
            double centerX = this.width * 0.5;
            double whiskerX0 = centerX - 0.25 * this.width;
            double whiskerX1 = centerX + 0.25 * this.width;
            AffineTransform at = worldToScreen;
            BoxPlotPainter.drawLine(g, at, centerX, minimum, centerX, lowerQuantile);
            BoxPlotPainter.drawLine(g, at, whiskerX0, minimum, whiskerX1, minimum);
            BoxPlotPainter.drawLine(g, at, centerX, maximum, centerX, upperQuantile);
            BoxPlotPainter.drawLine(g, at, whiskerX0, maximum, whiskerX1, maximum);
        }
        if (this.medianPaint != null) {
            g.setPaint(this.medianPaint);
            g.setStroke(BOLD_STROKE);
            BoxPlotPainter.drawLine(g, worldToScreen, boxOffsetX, median, this.width - boxOffsetX, median);
        }
        if (this.meanPaint != null) {
            double meanX = this.width * 0.5;
            AffineTransform oldAT = g.getTransform();
            TEMP_POINT.setLocation(meanX, mean);
            worldToScreen.transform(TEMP_POINT, TEMP_POINT);
            g.translate(TEMP_POINT.getX(), TEMP_POINT.getY());
            g.setPaint(this.meanPaint);
            g.setStroke(DEFAULT_STROKE);
            g.draw(DOT_SHAPE);
            g.setTransform(oldAT);
        }
        g.setStroke(oldStroke);
    }

    private static void drawLine(Graphics2D g, AffineTransform worldToScreen, double x0, double y0, double x1, double y1) {
        TEMP_LINE.setLine(x0, y0, x1, y1);
        Lines.transform((AffineTransform)worldToScreen, (Line2D)TEMP_LINE, (Line2D)TEMP_LINE);
        g.draw(TEMP_LINE);
    }
}

