/*
 * Decompiled with CFR 0.152.
 */
package de.javagl.viewer.glyphs;

import de.javagl.viewer.glyphs.BarChart;
import java.awt.Paint;
import java.util.List;
import java.util.Locale;

public class BarCharts {
    public static BarChart createFromList(List<? extends Number> list, Paint barPaint) {
        return BarCharts.createFromList(list, barPaint, false, true);
    }

    public static BarChart createFromList(final List<? extends Number> list, final Paint barPaint, final boolean paintLabels, final boolean paintValueStrings) {
        return new BarChart(){

            @Override
            public String getValueString(int index) {
                if (!paintValueStrings) {
                    return null;
                }
                return String.format(Locale.ENGLISH, "%.3f", this.getValue(index));
            }

            @Override
            public double getValue(int index) {
                Number number = (Number)list.get(index);
                if (number == null) {
                    return 0.0;
                }
                return number.doubleValue();
            }

            @Override
            public int getNumBars() {
                return list.size();
            }

            @Override
            public String getLabel(int index) {
                if (!paintLabels) {
                    return null;
                }
                return String.valueOf(index);
            }

            @Override
            public Paint getBarPaint(int index) {
                return barPaint;
            }
        };
    }

    public static double computeMin(BarChart barChart) {
        double min = Double.POSITIVE_INFINITY;
        int n = barChart.getNumBars();
        for (int i = 0; i < n; ++i) {
            min = Math.min(min, barChart.getValue(i));
        }
        return min;
    }

    public static double computeMax(BarChart barChart) {
        double max = Double.NEGATIVE_INFINITY;
        int n = barChart.getNumBars();
        for (int i = 0; i < n; ++i) {
            max = Math.max(max, barChart.getValue(i));
        }
        return max;
    }

    public static double getMin(double optionalMin, BarChart barChart) {
        if (!Double.isNaN(optionalMin)) {
            return optionalMin;
        }
        if (barChart.getNumBars() == 0) {
            return 0.0;
        }
        return BarCharts.computeMin(barChart);
    }

    public static double getMax(double optionalMax, BarChart barChart) {
        if (!Double.isNaN(optionalMax)) {
            return optionalMax;
        }
        if (barChart.getNumBars() == 0) {
            return 1.0;
        }
        return BarCharts.computeMax(barChart);
    }

    private BarCharts() {
    }
}

