/*
 * Decompiled with CFR 0.152.
 */
package de.javagl.viewer.glyphs;

import de.javagl.geom.AffineTransforms;
import de.javagl.geom.Lines;
import de.javagl.viewer.ObjectPainter;
import de.javagl.viewer.glyphs.BarChart;
import de.javagl.viewer.painters.GeneralLabelPainterPredicate;
import de.javagl.viewer.painters.LabelPainter;
import java.awt.Color;
import java.awt.Font;
import java.awt.Graphics2D;
import java.awt.Paint;
import java.awt.Shape;
import java.awt.geom.AffineTransform;
import java.awt.geom.Line2D;
import java.awt.geom.Rectangle2D;
import java.util.function.Predicate;

public final class BarChartPainter
implements ObjectPainter<BarChart> {
    private static final Rectangle2D TEMP_RECTANGLE = new Rectangle2D.Double();
    private static final Line2D TEMP_LINE = new Line2D.Double();
    private final Color labelColor = Color.BLACK;
    private final double relativeBarWidth = 0.9;
    private final LabelPainter valueStringLabelPainter;
    private final LabelPainter labelPainter;
    private final GeneralLabelPainterPredicate widthPredicate = new GeneralLabelPainterPredicate();

    public BarChartPainter() {
        Font font = new Font("Dialog", 0, 9);
        this.valueStringLabelPainter = new LabelPainter();
        this.valueStringLabelPainter.setTransformingLabels(false);
        this.valueStringLabelPainter.setFont(font);
        this.valueStringLabelPainter.setLabelAnchor(0.5, 1.0);
        this.valueStringLabelPainter.setLabelPaintingCondition((Predicate)this.widthPredicate);
        this.labelPainter = new LabelPainter();
        this.labelPainter.setTransformingLabels(false);
        this.labelPainter.setFont(font);
        this.labelPainter.setLabelAnchor(0.5, 0.0);
        this.labelPainter.setLabelPaintingCondition((Predicate)this.widthPredicate);
    }

    public void paint(Graphics2D g, AffineTransform worldToScreen, double w, double h, BarChart barChart) {
        if (barChart == null) {
            return;
        }
        int n = barChart.getNumBars();
        double spacePerBarX = 1.0;
        double offsetX = 0.09999999999999998 * spacePerBarX * 0.5;
        double barWidth = spacePerBarX - offsetX - offsetX;
        for (int i = 0; i < n; ++i) {
            String valueString;
            double value = barChart.getValue(i);
            double barRectMinY = 0.0;
            double barRectMaxY = value;
            if (value < 0.0) {
                barRectMinY = value;
                barRectMaxY = 0.0;
            }
            double barRectMinX = (double)i * spacePerBarX + offsetX;
            double barRectHeight = barRectMaxY - barRectMinY;
            TEMP_RECTANGLE.setRect(barRectMinX, Math.min(value, 0.0), barWidth, barRectHeight);
            Paint barPaint = barChart.getBarPaint(i);
            if (barPaint != null) {
                g.setPaint(barPaint);
                if (barRectHeight < 1.0E-5) {
                    TEMP_LINE.setLine(barRectMinX, barRectMinY, barRectMinX + barWidth, barRectMinY);
                    Lines.transform((AffineTransform)worldToScreen, (Line2D)TEMP_LINE, (Line2D)TEMP_LINE);
                    g.draw(TEMP_LINE);
                } else {
                    Shape s = AffineTransforms.createTransformedShape((AffineTransform)worldToScreen, (Shape)TEMP_RECTANGLE);
                    g.fill(s);
                }
            }
            double spacePerBarScreenX = AffineTransforms.computeDistanceX((AffineTransform)worldToScreen, (double)spacePerBarX);
            this.widthPredicate.setMaximumScreenWidth(spacePerBarScreenX);
            if (!(spacePerBarScreenX > 5.0)) continue;
            String label = barChart.getLabel(i);
            if (label != null) {
                g.setColor(this.labelColor);
                this.labelPainter.setLabelLocation(TEMP_RECTANGLE.getCenterX(), 0.0);
                this.labelPainter.paint(g, worldToScreen, w, h, label);
            }
            if ((valueString = barChart.getValueString(i)) == null) continue;
            g.setColor(this.labelColor);
            this.valueStringLabelPainter.setLabelLocation(TEMP_RECTANGLE.getCenterX(), value);
            this.valueStringLabelPainter.paint(g, worldToScreen, w, h, valueString);
        }
    }
}

