/*
 * Decompiled with CFR 0.152.
 */
package de.javagl.viewer.glyphs.selection;

import de.javagl.viewer.glyphs.ScatterChart;
import de.javagl.viewer.glyphs.ScatterChartMatrix;
import de.javagl.viewer.glyphs.ScatterCharts;
import de.javagl.viewer.glyphs.selection.ScatterChartSelector;
import de.javagl.viewer.selection.PointBasedSelector;
import de.javagl.viewer.selection.ShapeBasedSelector;
import java.awt.Shape;
import java.awt.geom.AffineTransform;
import java.awt.geom.Point2D;
import java.awt.geom.Rectangle2D;
import java.util.Collection;
import java.util.Collections;
import java.util.LinkedHashSet;

class ScatterChartMatrixSelector
implements PointBasedSelector<Integer>,
ShapeBasedSelector<Integer> {
    private ScatterChartMatrix scatterChartMatrix;
    private final ScatterChartSelector scatterChartSelector = new ScatterChartSelector();

    ScatterChartMatrixSelector() {
    }

    void setScatterChartMatrix(ScatterChartMatrix scatterChartMatrix) {
        this.scatterChartMatrix = scatterChartMatrix;
    }

    public Collection<Integer> computeElementsForShape(Shape shape, AffineTransform worldToScreen) {
        return this.computeElements(null, shape, worldToScreen);
    }

    public Collection<Integer> computeElementsForPoint(Point2D point, AffineTransform worldToScreen) {
        return this.computeElements(point, null, worldToScreen);
    }

    private Collection<Integer> computeElements(Point2D point, Shape shape, AffineTransform worldToScreen) {
        if (this.scatterChartMatrix == null) {
            return Collections.emptySet();
        }
        LinkedHashSet<Integer> indices = new LinkedHashSet<Integer>();
        int n = this.scatterChartMatrix.getNumCharts();
        double cellSize = 1.0 / (double)n;
        for (int r = 0; r < n; ++r) {
            for (int c = 0; c < n; ++c) {
                Collection<Integer> cellElements;
                ScatterChart scatterChart = this.scatterChartMatrix.getChart(r, c);
                if (scatterChart == null) continue;
                Rectangle2D cellBounds = this.scatterChartMatrix.getRelativeCellBounds(r, c);
                AffineTransform cellTransform = new AffineTransform();
                cellTransform.setTransform(worldToScreen);
                cellTransform.translate((double)c * cellSize, (double)r * cellSize);
                cellTransform.scale(cellSize, cellSize);
                cellTransform.translate(cellBounds.getX(), cellBounds.getY());
                cellTransform.scale(cellBounds.getWidth(), cellBounds.getHeight());
                Rectangle2D bounds = ScatterCharts.computeBounds((ScatterChart)scatterChart);
                cellTransform.scale(1.0 / bounds.getWidth(), -1.0 / bounds.getHeight());
                cellTransform.translate(-bounds.getMinX(), -bounds.getMaxY());
                this.scatterChartSelector.setScatterChart(scatterChart);
                if (point != null) {
                    cellElements = this.scatterChartSelector.computeElementsForPoint(point, cellTransform);
                    indices.addAll(cellElements);
                }
                if (shape == null) continue;
                cellElements = this.scatterChartSelector.computeElementsForShape(shape, cellTransform);
                indices.addAll(cellElements);
            }
        }
        return indices;
    }
}

