/*
 * Decompiled with CFR 0.152.
 */
package de.javagl.viewer.glyphs.selection;

import de.javagl.selection.SelectionModel;
import de.javagl.viewer.Viewer;
import de.javagl.viewer.glyphs.ScatterChart;
import de.javagl.viewer.glyphs.ScatterChartMatrix;
import de.javagl.viewer.glyphs.selection.GlyphSelectionHandler;
import de.javagl.viewer.glyphs.selection.ScatterChartMatrixSelector;
import de.javagl.viewer.glyphs.selection.ScatterChartSelector;
import de.javagl.viewer.selection.PointBasedSelector;
import de.javagl.viewer.selection.SelectionHandler;
import de.javagl.viewer.selection.SelectionHandlers;
import de.javagl.viewer.selection.ShapeBasedSelector;

public class GlyphSelectionHandlers {
    public static GlyphSelectionHandler<ScatterChart, Integer> createDefaultScatterChart() {
        ScatterChartSelector scatterChartSelector;
        ScatterChartSelector pointBasedSelector = scatterChartSelector = new ScatterChartSelector();
        ScatterChartSelector shapeBasedSelector = scatterChartSelector;
        final SelectionHandler clickSelectionHandler = SelectionHandlers.createClick((PointBasedSelector)pointBasedSelector);
        final SelectionHandler lassoSelectionHandler = SelectionHandlers.createLasso((ShapeBasedSelector)shapeBasedSelector);
        return new GlyphSelectionHandler<ScatterChart, Integer>(){

            public void disconnect() {
                clickSelectionHandler.disconnect();
                lassoSelectionHandler.disconnect();
            }

            public void connect(Viewer viewer, SelectionModel<Integer> selectionModel) {
                clickSelectionHandler.connect(viewer, selectionModel);
                lassoSelectionHandler.connect(viewer, selectionModel);
            }

            @Override
            public void setGlyph(ScatterChart glyph) {
                scatterChartSelector.setScatterChart(glyph);
            }
        };
    }

    public static GlyphSelectionHandler<ScatterChartMatrix, Integer> createDefaultScatterChartMatrix() {
        ScatterChartMatrixSelector scatterChartMatrixSelector;
        ScatterChartMatrixSelector pointBasedSelector = scatterChartMatrixSelector = new ScatterChartMatrixSelector();
        ScatterChartMatrixSelector shapeBasedSelector = scatterChartMatrixSelector;
        final SelectionHandler clickSelectionHandler = SelectionHandlers.createClick((PointBasedSelector)pointBasedSelector);
        final SelectionHandler lassoSelectionHandler = SelectionHandlers.createLasso((ShapeBasedSelector)shapeBasedSelector);
        return new GlyphSelectionHandler<ScatterChartMatrix, Integer>(){

            public void disconnect() {
                clickSelectionHandler.disconnect();
                lassoSelectionHandler.disconnect();
            }

            public void connect(Viewer viewer, SelectionModel<Integer> selectionModel) {
                clickSelectionHandler.connect(viewer, selectionModel);
                lassoSelectionHandler.connect(viewer, selectionModel);
            }

            @Override
            public void setGlyph(ScatterChartMatrix glyph) {
                scatterChartMatrixSelector.setScatterChartMatrix(glyph);
            }
        };
    }

    private GlyphSelectionHandlers() {
    }
}

