/*
 * Decompiled with CFR 0.152.
 */
package de.javagl.viewer.functions;

import de.javagl.viewer.Painter;
import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics2D;
import java.awt.Paint;
import java.awt.geom.AffineTransform;
import java.awt.geom.Rectangle2D;
import java.util.ArrayList;
import java.util.List;

class LegendPainter
implements Painter {
    private final Font font = new Font("Dialog", 0, 9);
    private final List<String> strings = new ArrayList<String>();
    private final List<Paint> paints = new ArrayList<Paint>();
    private String prototypeString;

    LegendPainter() {
    }

    void addString(String string, Paint paint) {
        this.strings.add(string);
        this.paints.add(paint);
    }

    void clearStrings() {
        this.strings.clear();
        this.paints.clear();
    }

    void setPrototypeString(String prototypeString) {
        this.prototypeString = prototypeString;
    }

    public void paint(Graphics2D g, AffineTransform worldToScreen, double w, double h) {
        if (this.strings.size() == 0) {
            return;
        }
        g.setFont(this.font);
        FontMetrics fontMetrics = g.getFontMetrics();
        double maxWidth = 0.0;
        double sumHeight = 0.0;
        for (String string : this.strings) {
            Rectangle2D lineBounds = fontMetrics.getStringBounds(string, g);
            maxWidth = Math.max(maxWidth, lineBounds.getWidth());
            sumHeight += lineBounds.getHeight();
        }
        if (this.prototypeString != null) {
            Rectangle2D lineBounds = fontMetrics.getStringBounds(this.prototypeString, g);
            maxWidth = Math.max(maxWidth, lineBounds.getWidth());
        }
        double borderH = 5.0;
        double borderV = 2.0;
        double totalWidth = maxWidth + borderH + borderH;
        double totalHeight = sumHeight + borderV + borderV;
        Rectangle2D.Double totalBounds = new Rectangle2D.Double(w - totalWidth, 0.0, totalWidth, totalHeight);
        g.setStroke(new BasicStroke(1.0f));
        g.setColor(new Color(255, 255, 255, 210));
        g.fill(totalBounds);
        g.setColor(Color.GRAY);
        g.draw(totalBounds);
        g.setColor(Color.BLACK);
        double y = 0.0;
        double x = w - maxWidth - borderH;
        for (int i = 0; i < this.strings.size(); ++i) {
            String string = this.strings.get(i);
            Paint paint = this.paints.get(i);
            Rectangle2D lineBounds = fontMetrics.getStringBounds(string, g);
            g.setPaint(paint);
            g.drawString(string, (int)x, (int)(y += lineBounds.getHeight()));
        }
    }
}

