/*
 * Decompiled with CFR 0.152.
 */
package de.javagl.viewer.functions;

import de.javagl.viewer.functions.LegendProvider;
import java.util.Arrays;
import java.util.List;
import java.util.Locale;
import java.util.function.DoubleFunction;

public class LegendProviders {
    public static LegendProvider createDefault(final String string) {
        return new LegendProvider(){

            @Override
            public List<String> getLegend(DoubleFunction<? extends Number> function, int screenX, int screenY, double worldX, double worldY) {
                return Arrays.asList(string);
            }
        };
    }

    public static LegendProvider createFunctionValuesLegendProvider(final String title) {
        return new LegendProvider(){

            @Override
            public List<String> getLegend(DoubleFunction<? extends Number> function, int screenX, int screenY, double worldX, double worldY) {
                double x = worldX;
                Number y = function.apply(x);
                String xValueString = "   x = " + LegendProviders.defaultFormat(x);
                String yValueString = "f(x) = " + LegendProviders.defaultFormat(y);
                return Arrays.asList(title, xValueString, yValueString);
            }
        };
    }

    public static LegendProvider createFunctionValuesLegendProvider() {
        return new LegendProvider(){

            @Override
            public List<String> getLegend(DoubleFunction<? extends Number> function, int screenX, int screenY, double worldX, double worldY) {
                double x = worldX;
                Number y = function.apply(x);
                String xValueString = "   x = " + LegendProviders.defaultFormat(x);
                String yValueString = "f(x) = " + LegendProviders.defaultFormat(y);
                return Arrays.asList(xValueString, yValueString);
            }
        };
    }

    private static String defaultFormat(Number value) {
        if (value == null) {
            return "?";
        }
        String s = String.format(Locale.ENGLISH, "%.4f", value.doubleValue());
        return String.format("%8s", s);
    }

    private LegendProviders() {
    }
}

